<?php

/*
 *******************
 * INCLUDE ENVATO [ONLY] ACTIVATION ASSETS
 *******************
 *
 *	Function to enqueue important assets for the activation process.
 *
 *  @type	action
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_envato_activation_js' ) ) :

	function wphave_admin_envato_activation_js( $hook ) {

		if( wphave_admin_activation_process_switch() != 'envato' ) {
			// Stop here, if the activation process is not set to "envato" only verification
			return;
		}

		// Method to get the page hook
		//wp_die($hook);

		// Load the following JS files only on theme welcome page
		if( $hook != 'tools_page_wphave-admin-purchase-code' ) {
			return;
		}

		wp_enqueue_script( 
			'wphave-admin-activation', wphave_admin_path( 'inc/init/setup/assets/js/setup_envato.js' ), array( 'jquery' ), null, true 
		);

		wp_localize_script( 
			'wphave-admin-activation', 'wp_ajax_data', array( 'wp_ajax_url' => admin_url( 'admin-ajax.php' ),
		));

		// Localize the script with new data
		$vars = wphave_admin_activation_localized_script_vars();
		wp_localize_script( 'wphave-admin-activation', 'WP_JS_Theme_Activation', $vars );

	}

endif;

add_action( 'admin_enqueue_scripts', 'wphave_admin_envato_activation_js', 30 );


/*
 *******************
 * ENVATO [ONLY] THEME PURCHASE CODE AJAX CHECK
 *******************
 *
 *	Function to manage the AJAX action to activate the theme license via the passed purchase code.
 *
 *  @type	action
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_envato_activation_process' ) ) :

	function wphave_admin_envato_activation_process() {

		if( wphave_admin_activation_process_switch() != 'envato' ) {
			// Stop here, if the activation process is not set to "envato" only verification
			return;
		}

		// --> !!! For security check and verify wp_nonce() before saving new values from AJAX request
		check_ajax_referer( 'verify_sec_request', 'security' );

		if( $_POST ) {		

			// Get user purchase code from theme validation check
			$request = json_decode( stripslashes( $_POST['fieldData'] ) );

			if( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
				$code = $request[0]->purchase_code;
			}

			$action = __( 'Something went wrong', 'wphave-admin' );

			// 1. Check if there is a connection to the Envato API
			if( wphave_admin_license_action( 'envato', $code )['status'] == 'success' ) {	

				// 2. Send verification purchase code notice (if process is successfully set theme license to active)
				$action = wphave_admin_license_action( 'envato_only_verify', $code );			

			} else {

				// 2. Evato API connection failed
				// Cancel license installation and send Evato connection notice
				$action = wphave_admin_license_action( 'envato' );

			}

			wp_send_json( array(
				//'success' => 'SUCCESS',
				//'fieldData' => $request,,
				//'verify_status' => wphave_purchase_code_verify( $code, $root_url, $client_mail ),
				'license_action' => $action['notice'],
				'license_status' => $action['status']
			) );			

		}

		die();

	}

endif;

add_action( 'wp_ajax_wphave_admin_envato_activation_process', 'wphave_admin_envato_activation_process' );
add_action( 'wp_ajax_nopriv_wphave_admin_envato_activation_process', 'wphave_admin_envato_activation_process' );


/*
 *******************
 * ENVATO [ONLY] THEME UNLOCK PURCHASE CODE AJAX ACTIOB
 *******************
 *
 *	Function to manage the AJAX action to uninstall the active theme license.
 *
 *  @type	action
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_envato_deactivation_process' ) ) :

	function wphave_admin_envato_deactivation_process() {

		if( wphave_admin_activation_process_switch() != 'envato' ) {
			// Stop here, if the activation process is not set to "envato" only verification
			return;
		}

		// --> !!! For security check and verify wp_nonce() before saving new values from AJAX request
		check_ajax_referer( 'verify_sec_request', 'security' );

		if( $_POST ) {		

			// Get client action to uninstall license
			$request = json_decode( stripslashes( $_POST['fieldData'] ) );

			if( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
				$unlock_action = $request[0]->command;
			}

			$action = __( 'Something went wrong', 'wphave-admin' );

			// 1. Check for client unlocking license request
			if( $unlock_action == 'unlock_purchase_code' ) {

				// 2. Send uninstall license notice (if process is successfully set theme license to inactive)
				$action = wphave_admin_license_action( 'envato_only_uninstall' );	

			}

			wp_send_json( array(
				//'success' => 'SUCCESS',
				'license_action' => $action['notice'],
				'license_status' => $action['status'],
			) );			

		}

		die();

	}

endif;

add_action( 'wp_ajax_wphave_admin_envato_deactivation_process', 'wphave_admin_envato_deactivation_process' );
add_action( 'wp_ajax_nopriv_wphave_admin_envato_deactivation_process', 'wphave_admin_envato_deactivation_process' );


/*
 *******************
 * ENVATO API CONNECTION
 *******************
 *
 *	Function to connect to the Envato api to get data about the purchase code.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_envato_purchase_validation' ) ) :

	function wphave_admin_envato_purchase_validation( $get_code ) {

		$code = trim( $get_code );

		// Make sure the code is valid before sending it to Envato
		if( ! preg_match("/^(\w{8})-((\w{4})-){3}(\w{12})$/", $code) ) {
			return __( 'Invalid Purchase Code', 'wphave-admin' );
		}

		// Envato API url
		$url = 'https://api.envato.com/v3/market/author/sale?code=' . $code;	
		$curl = curl_init( $url );

		// Base64 encode key
		$str = 'Z0hZS25tMkJyZnJIQWJuVzNOcGtIWGUzNGNGSEQ0TGI=';
		$token = base64_decode( $str );

		$header = array();
		$header[] = 'Authorization: Bearer ' . $token;
		//$header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
		$header[] = 'User-Agent: Plugin purchase code verification';
		$header[] = 'timeout: 20';

		curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $curl, CURLOPT_HTTPHEADER, $header );	
		$envatoData = curl_exec( $curl );
		curl_close( $curl );
		$envatoData = json_decode( $envatoData );

		return $envatoData;

	}

endif;


/*
 *******************
 * ENVATO API CONNECTION - CHECK PURCHASE COUNT
 *******************
 *
 *	Function to get the purchase count of an Envato item.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_purchase_count' ) ) :

	function wphave_admin_purchase_count( $code ) {

		// Connect to Envato API
		$envatoData = wphave_admin_envato_purchase_validation( $code );

		// Default purchase count is 1 (was purchased only once)
		$purchase_count = 1;

		// Check purchase count (API data) is accessible
		if( isset( $envatoData->purchase_count ) ) {	
			// Check purchase count is more than 1
			if( $envatoData->purchase_count >= 1 ) {
				// Get purchase count from Envato API
				$purchase_count = $envatoData->purchase_count;
			}
		}

		// Count of purchases
		return $purchase_count;

	}

endif;


/*
 *******************
 * ENVATO API CONNECTION - PURCHASE CODE VERIFICATION
 *******************
 *
 *	Function to check if the passed Envato purchase code is valid.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_purchase_code_verify' ) ) :

	function wphave_admin_purchase_code_verify( $code ) {

		// Connect to Envato API
		$envatoData = wphave_admin_envato_purchase_validation( $code );

		// Check if Envato API data is accessible
		if( isset( $envatoData->item->name ) ) {

			// Check if the purchase code is valid for a different theme
			if( $envatoData->item->id != WPHAVE_ADMIN_ENVATO_ID ) {

				// Purchase code is valid, but for a different theme
				return 'different';

			}

			// Purchase Code is valid
			return 'valid';
		}

		// Purchase Code is invalid
		return 'invalid';

	}

endif;


/*
 *******************
 * ENVATO PURCHASE CODE SYNTAX
 *******************
 *
 *	Function to provide the correct purchase code syntax depending on the theme id.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_envato_purchase_code' ) ) :

	function wphave_admin_envato_purchase_code() {

		return 'envato_purchase_code_' . WPHAVE_ADMIN_ENVATO_ID;

	}

endif;


/*
 *******************
 * ENVATO PURCHASE CODE TRANSIENT SYNTAX
 *******************
 *
 *	Function to provide the correct purchase code transient syntax depending on the theme id.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_envato_purchase_code_transient' ) ) :

	function wphave_admin_envato_purchase_code_transient() {

		return 'envato_purchase_code_transient_' . WPHAVE_ADMIN_ENVATO_ID;

	}

endif;


/*
 *******************
 * GET AND SAVE ENVATO PURCHASE THEME DETAILS
 *******************
 *
 *	Function to get purchase data about the theme via the Envato api.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_purchase_details' ) ) :

	function wphave_admin_purchase_details( $code ) {

		$option = get_option('wphave_data');
		
		// Define theme purchase transient
		$transient_id = wphave_admin_envato_purchase_code_transient();

		// Get the saved purchase code
		$saved_purchase_code = isset( $option['wphave_admin_envato_purchase_code'] ) ? $option['wphave_admin_envato_purchase_code'] : '';

		// Check if the old transient exist and the saved purchase code is the same as the incoming purchase code
		if( get_transient( $transient_id ) && $code == $saved_purchase_code ) {
			// Stop here, resaving is not necessary
			return;
		}

		// Delete the old transient
		delete_transient( $transient_id );	

		// Connect to Envato API
		$envatoData = wphave_admin_envato_purchase_validation( $code );	

		// Create transient if theme purchase transient not exists
		if( false === ( $get_data = get_transient( $transient_id ) ) ) {

			// Get data from Envato API
			$data = $envatoData;

			if( isset( $data ) && wphave_admin_purchase_code_verify( $code ) == 'valid' ) {

				// Define theme purchase user data
				$get_data = array();

				$get_data['theme_id'] = $data->item->id;
				$get_data['theme_name'] = $data->item->name;
				$get_data['amount'] = $data->amount;
				$get_data['license'] = $data->license;
				$get_data['purchase_count'] = $data->purchase_count;
				$get_data['sold_at'] = $data->sold_at;
				$get_data['support_amount'] = $data->support_amount;
				$get_data['supported_until'] = $data->supported_until;
				$get_data['buyer'] = $data->buyer;
				$get_data['purchase_code'] = $code;

				// Set theme purchase transient, only if purchase code is valid
				// Will automatically resaved each 14 days by aplVerifyLicense() function
				set_transient( $transient_id, $get_data, 14 * DAY_IN_SECONDS );

			} else {
				$get_data = 'Data Error';
			}				

		}

	}

endif;


/*
 *******************
 * GET ENVATO PURCHASE THEME DETAILS FROM TRANSIENT
 *******************
 *
 *	Function to get the cached purchase data from transient, to avoid to connect to the Envato api on each page request.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists( 'wphave_admin_get_purchase_details' ) ) :

	function wphave_admin_get_purchase_details() {

		$option = get_option('wphave_data');
		
		// Get purchase data from the users purchase code
		$purchase_code = isset( $option['wphave_admin_envato_purchase_code'] ) ? $option['wphave_admin_envato_purchase_code'] : '';			
		$transient_id = wphave_admin_envato_purchase_code_transient();
		$purchase_data = get_transient( $transient_id );

		$wp_date_format = get_option('date_format');
		$current_date = current_time( 'mysql' );
		$supported = '';
		if( isset( $purchase_data['supported_until'] ) ) {
			$supported = date( $wp_date_format, strtotime( $purchase_data['supported_until'] ) );
		}
		$purchased = '';
		if( isset( $purchase_data['sold_at'] ) ) {
			$purchased = date( $wp_date_format, strtotime( $purchase_data['sold_at'] ) );
		}

		$data = array();

		// Otherwise use purchase details from manually created license
		// Theme license details from personal issued license
		$data['theme_name'] = WPHAVE_ADMIN_PLUGIN_NAME;
		$data['license'] = __( 'You are using a personally issued license.', 'wphave-admin' );
		$data['purchase_code'] = isset( $purchase_code ) ? $purchase_code : 'n/a';
		$data['supported_until'] = 'n/a';

		// Check Envato purchase details are available
		if( wphave_admin_purchase_code_verify( $purchase_code ) == 'valid' ) {	
			// Theme license details from Envato
			$data['theme_name'] = isset( $purchase_data['theme_name'] ) ? $purchase_data['theme_name'] : 'n/a';
			$data['buyer'] = isset( $purchase_data['buyer'] ) ? $purchase_data['buyer'] : 'n/a'; 
			$data['license'] = isset( $purchase_data['license'] ) ? $purchase_data['license'] : 'n/a';
			$data['purchase_count'] = isset( $purchase_data['purchase_count'] ) ? $purchase_data['purchase_count'] : 'n/a';
			$data['sold_at'] = isset( $purchase_data['sold_at'] ) ? $purchased : 'n/a';
			$data['supported_until'] = isset( $purchase_data['supported_until'] ) ? $supported : 'n/a';	
			$data['purchase_code'] = isset( $purchase_data['purchase_code'] ) ? $purchase_data['purchase_code'] : 'n/a';
		}

		return $data;

	}

endif;