<?php

namespace VIWEC\INCLUDES;

use function React\Promise\all;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Email_Samples {

	protected static $instance = null;

	private function __construct() {
	}

	public static function init() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public static function default_subject() {
		return apply_filters( 'viwec_sample_subjects', [
			'default'                           => esc_html__( 'This template will be used in the case of none detected template and the subject will be get from original email', 'viwec-email-template-customizer' ),
			'new_order'                         => '{customer_name} placed a new order #{order_number} on your store',
			'cancelled_order'                   => '{customer_name} has cancelled order #{order_number} on your store',
			'failed_order'                      => 'Order #{order_number} has failed on your store',
			'customer_on_hold_order'            => 'Hi {customer_name}, Your order {order_number} has been received!',
			'customer_processing_order'         => 'Hi {customer_name}, Your order {order_number} has been received!',
			'customer_completed_order'          => 'Hi {customer_name}, Your order {order_number} is now complete',
			'customer_refunded_order'           => 'Hi {customer_name}, Your order {order_number} has been refunded.',
			'customer_partially_refunded_order' => 'Hi {customer_name}, Your order {order_number} has been partially refunded.',
			'customer_invoice'                  => 'Invoice for order #{order_number} on {site_title}',
			'customer_invoice_pending'          => '{site_title} invoice',
			'customer_note'                     => 'Note added to your order {order_date} on {site_title}',
			'customer_reset_password'           => 'Hi {user_login}, Your password reset requested on {site_title}',
			'customer_new_account'              => 'Your account has been created on {site_title}'
		] );
	}

	public static function sample_header() {
		return '{"style_container":{"background-color":"transparent","background-image":"none","width":600,"responsive":"414"},"rows":{"0":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#162447","border-color":"transparent","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px; color: #ffffff;\">YOUR LOGO</span></p>"},"attrs":{"data-center_on_mobile":"true"},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"color: #ffffff;\">Help Center</span></p>"},"attrs":{"data-center_on_mobile":"true"},"childStyle":{}}}}}}}}';
	}

	public static function sample_footer() {
		return '{"style_container":{"background-color":"transparent","background-image":"none","width":600,"responsive":"414"},"rows":{"0":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#162447","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 20px;\">Get in Touch</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/social","style":{"width":"530px","text-align":"center","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"facebook":"  ' . VIWEC_IMAGES . 'fb-blue-white.png","facebook_url":"#","twitter":"  ' . VIWEC_IMAGES . 'twi-cyan-white.png","twitter_url":"#","instagram":"  ' . VIWEC_IMAGES . 'ins-white-color.png","instagram_url":"#","youtube":"  ' . VIWEC_IMAGES . 'yt-color-white.png","youtube_url":"","linkedin":"  ' . VIWEC_IMAGES . 'li-color-white.png","linkedin_url":"","whatsapp":"  ' . VIWEC_IMAGES . 'wa-color-white.png","whatsapp_url":"","direction":"","data-width":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"20px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">This email was sent by : <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>\n<p style=\"text-align: center;\"><span style=\"color: #f5f5f5; font-size: 12px;\">For any questions please send an email to <span style=\"color: #ffffff;\"><a style=\"color: #ffffff;\" href=\"{admin_email}\">{admin_email}</a></span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #f5f5f5;\"><span style=\"color: #f5f5f5;\"><span style=\"font-size: 12px;\"><a style=\"color: #f5f5f5;\" href=\"#\">Privacy Policy</a>&nbsp; |&nbsp; <a style=\"color: #f5f5f5;\" href=\"#\">Help Center</a></span></span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}}}}';
	}


	public static function origin_sample_templates() {
		//    {_site_url}/wp-content/plugins/woocommerce-email-template-customizer/assets/img/
		//   ' . VIWEC_IMAGES . '

		$basic = esc_html__( 'Basic', 'viwec-email-template-customizer' );

		return apply_filters( 'viwec_sample_templates', [
			'default' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/recover_heading","style":{"width":"530px","font-size":"30px","font-weight":"600","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"45px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"35px 35px 0px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/recover_content","style":{"width":"530px"},"content":{},"attrs":{"show_img":"true"},"childStyle":{"p":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","line-height":"22px","color":"#444444","padding":"0px"},"h2":{"font-size":"20px","font-weight":"500","font-family":"Helvetica, Arial, sans-serif","line-height":"25.2px","color":"#444444","padding":"25px 0px 10px"},".head.td":{"font-size":"16px","line-height":"18.2px","font-weight":"600","font-family":"Helvetica, Arial, sans-serif","color":"#444444","border-color":"#f4f4f4","border-style":"dotted","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"font-size":"16px","line-height":"18.2px","font-family":"Helvetica, Arial, sans-serif","color":"#444444","border-color":"#cccccc","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"},"th.body.td":{"font-weight":"500"},"td.body.td":{"font-weight":"400"},".td":{"padding":"8px 0px"},"img":{"width":"80px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"newest","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"4":"footer_block"}}',
				],
			],

			'new_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444; font-size: 24px;\">{customer_name} placed a new order on your store.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><span style=\"color: #444444;\">Order #</span><span style=\"color: #444444;\">{order_number} - Total {order_total} -&nbsp;</span><span style=\"color: #444444;\">{order_date}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"Go To Your Store"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"172px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{payment_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"25px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 50px 8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"0px","background-image":"none"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":"footer_block"}}',
				],
			],

			'cancelled_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444; font-size: 24px;\">{customer_name} has cancelled order on your store.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><span style=\"color: #444444;\">Order #</span><span style=\"color: #444444;\">{order_number} - Total {order_total} -&nbsp;</span><span style=\"color: #444444;\">{order_date}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"Go To Your Store"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"172px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{customer_note}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":"footer_block"}}',
				],
			],

			'failed_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444; font-size: 24px;\">Order #{order_number} has failed on your store</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px;\"><span style=\"color: #444444;\">Total {order_total} - </span><span style=\"color: #444444;\">{order_date}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"Go To Your Store"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"172px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":"footer_block"}}',
				],
			],

			'customer_on_hold_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Order #{order_number}.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}, Thank you for your purchase.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"related","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"7":"footer_block"}}',
				],
			],

			'customer_processing_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Order #{order_number}.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}, Thank you for your purchase.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px; color: #444444;\">We are processing your order.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"related","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"7":"footer_block"}}',
				],
			],

			'customer_completed_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-cart-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Order #{order_number}.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name}, Thank you for your purchase.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 20px; color: #444444;\">We will send you a follow-up email with tracking information when your order ships.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"related","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"7":"footer_block"}}',
					// {"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"300"},"rows":{"0":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#f2f2f2","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"5px 5px 0px 0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"#ffffff","padding":"5px 20px 10px","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"15px 15px 0px 0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><strong style=\"font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 20px; text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><img src=\"{_site_url}/wp-content/uploads/2022/06/Color-Splash-Email.png\" alt=\"Vivid Splash\" width=\"331\" height=\"300\"><br>Heartfelt Thanks!</span></strong></span></p>\n<p style=\"text-align: Justify;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><br>Congratulations! you have just invested in your personal development!</span></p>\n<p style=\"text-align: Justify;\">&nbsp;</p>\n<p style=\"text-align: Justify;\"><span style=\"font-family: arial, helvetica, sans-serif;\">The <strong>Core Values Finder</strong> is designed to help you carve out your intrinsic motivational core &amp; you have just taken the next step to integrate your core values.&nbsp;<br><br>Your <strong>personalized evaluation</strong> will be now created by us and sent as a pdf. Due to our high-quality standards, this takes on average <strong>24 hours</strong>. </span><span style=\"font-family: arial, helvetica, sans-serif;\">Be patient, but stay excited for your results! To get into the right mood for <strong>self reflection</strong> during your wait we recommend you to watch our <span style=\"color: #3366ff;\"><a style=\"color: #3366ff;\" href=\"https://bit.ly/3xNCH3C\" target=\"_blank\" rel=\"noopener\">motivational video.</a></span></span></p>\n<p style=\"text-align: Justify;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><br></span><span style=\"font-family: arial, helvetica, sans-serif;\">May your journey be one full of<strong> trust</strong>, <strong>insight</strong> and <strong>colorful</strong> experiences!<br><br></span></p>"},"attrs":{"data-center_on_mobile":"false"},"childStyle":{}}}}}},"1":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#f2f2f2","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"1px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"25px","background-image":"url()","background-color":"#ffffff","padding":"15px 0px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><strong><span style=\"font-family: arial, helvetica, sans-serif;\"><span style=\"font-size: 12px;\"><a href=\"https://bit.ly/3txvF0c\" target=\"_blank\" rel=\"noopener\"><img style=\"vertical-align: sub;\" src=\"{_site_url}/wp-content/plugins/email-template-customizer-for-woo/assets/img/fb-blue-border.png\" width=\"35\" height=\"35\"> &nbsp;</a><a href=\"https://bit.ly/3tyBomI\" target=\"_blank\" rel=\"noopener\"> <img style=\"vertical-align: sub;\" src=\"{_site_url}/wp-content/plugins/email-template-customizer-for-woo/assets/img/yt-color-border.png\" width=\"35\" height=\"35\">&nbsp; &nbsp;</a><a href=\"instagram://user?username=corevaluesfinder\" target=\"_blank\" rel=\"noopener\"><img style=\"vertical-align: sub;\" src=\"{_site_url}/wp-content/plugins/email-template-customizer-for-woo/assets/img/ins-color-border.png\" width=\"35\" height=\"35\"> </a><a href=\"https://bit.ly/3mLxQK4\" target=\"_blank\" rel=\"noopener\">&nbsp; <img style=\"vertical-align: sub;\" src=\"{_site_url}/wp-content/plugins/email-template-customizer-for-woo/assets/img/li-color-border.png\" width=\"35\" height=\"35\"></a></span></span></strong></p>\n<p style=\"text-align: center;\"><strong><span style=\"font-family: arial, helvetica, sans-serif;\">For Future Updates Follow Us&nbsp;</span></strong></p>\n<p style=\"text-align: center;\"><strong style=\"color: #999999; font-size: 12px;\"><span style=\"font-family: arial, helvetica, sans-serif;\">We are continuously improving our tests &amp; adding new insights to our reports.</span></strong></p>"},"attrs":{"data-center_on_mobile":"true"},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"0px 35px 18px","background-image":"url()","background-color":"#f2f2f2","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"url({_site_url}/wp-content/uploads/2021/02/Values-in-Action-e1645981342890.png)","background-color":"#ffffff","padding":"12px 0px 12px 20px","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"0px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px 0px 15px 15px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-family: arial, helvetica, sans-serif; text-align: start;\">Yours truly,</span><br style=\"font-family: arial, helvetica, sans-serif; text-align: start;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><strong>Find Your Values - Team&nbsp;</strong><span style=\"font-size: 11.5pt; color: #444444;\"><br><span style=\"font-size: 14px;\"><span style=\"color: #000000;\">Vivid Ground</span><span style=\"color: #000000;\">&nbsp;|&nbsp;<a style=\"color: #000000;\" href=\"https://bit.ly/3xqdZVE\" target=\"_blank\" rel=\"noopener\">Support &amp; FAQ</a></span></span></span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"28px 0px 0px"}}}}}}},"3":{"props":{"style_outer":{"padding":"15px 35px 0px","background-image":"none","background-color":"#ffffff","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid3cols","dataCols":"3"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"176px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"176px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/image","style":{"width":"176px","text-align":"left","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"{_site_url}/wp-content/uploads/2022/02/Picture1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"65px"}}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"176px"}},"elements":{"0":{"type":"html/image","style":{"width":"176px","text-align":"center","padding":"24px 45px 0px 38px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":"{_site_url}/wp-content/plugins/email-template-customizer-for-woo/assets/img/icon-barcode-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"72px"}}},"1":{"type":"html/text","style":{"width":"176px","line-height":"22px","background-image":"none","padding":"0px 0px 4px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\">&nbsp;</p>\n<p style=\"text-align: center;\"><span style=\"font-size: 40px;\"><strong><span style=\"font-family: arial, helvetica, sans-serif;\">INVOICE</span></strong></span></p>"},"attrs":{"data-center_on_mobile":"true"},"childStyle":{}},"2":{"type":"html/divider","style":{"width":"176px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}},"2":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"176px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"176px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/text","style":{"width":"176px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: right;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><strong>Address</strong></span></p>\n<p style=\"text-align: right;\"><span style=\"font-family: arial, helvetica, sans-serif;\">Vivid Ground<br>Kentuckallee 82</span></p>\n<p style=\"text-align: right;\"><span style=\"font-family: arial, helvetica, sans-serif;\">Karlsruhe, 76149</span></p>\n<p style=\"text-align: right;\"><span style=\"font-family: arial, helvetica, sans-serif;\">Germany</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}},"4":{"props":{"style_outer":{"padding":"4px 35px 0px 32px","background-image":"none","background-color":"#ffffff","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"0px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265.5px"}},"elements":{"0":{"type":"html/text","style":{"width":"265.5px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"2px 0px 0px 2px","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-size: 18px;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><strong><span style=\"color: #444444;\">Order No.&nbsp;</span></strong></span><span style=\"color: #444444; font-family: arial, helvetica, sans-serif; text-align: center;\">{order_number}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/spacer","style":{"width":"265.5px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"2":{"type":"html/text","style":{"width":"265.5px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"2px 0px 0px 2px","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-size: 14px;\"><span style=\"font-family: arial, helvetica, sans-serif;\"><strong><span style=\"color: #444444;\">Email: </span></strong></span><span style=\"color: #444444; font-family: arial, helvetica, sans-serif; text-align: center;\">{user_email}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265.5px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"265.5px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"14px 0px 0px"}}},"1":{"type":"html/text","style":{"width":"265.5px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"12px 0px 8px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 24px;\"><strong>Order Details</strong></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265.5px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"3px 0px 0px 2px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 18px;\"><span style=\"color: #444444; font-family: arial, helvetica, sans-serif; text-align: center;\">{order_date}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 6px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"1px","border-top-width":"0px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"528px"}},"elements":{"0":{"type":"html/divider","style":{"width":"528px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/divider","style":{"width":"528px","padding":"0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#000000","border-top-width":"1px"}}},"2":{"type":"html/order_detail","style":{"width":"528px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"false","remove_product_link":"false","use_hook_order_download":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"110px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"14px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"3":{"type":"html/divider","style":{"width":"528px","padding":"0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#000000","border-top-width":"1px"}}},"4":{"type":"html/divider","style":{"width":"528px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 4px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"1px","border-top-width":"0px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"264px"}},"elements":{"0":{"type":"html/text","style":{"width":"264px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"1px 0px 5px 2px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 18px;\"><strong><span style=\"color: #444444;\">Payment Method</span></strong></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"264px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 1px 0px 2px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-family: arial, helvetica, sans-serif;\">{payment_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"264px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"264px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px 0px 0px 6px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"","refund-full":"Refund (Full)","refund-part":"Refund (Partial)"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"40%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/divider","style":{"width":"264px","padding":"0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#000000","border-top-width":"1px"}}},"2":{"type":"html/order_total","style":{"width":"264px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"60%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"3":{"type":"html/divider","style":{"width":"264px","padding":"0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#000000","border-top-width":"1px"}}},"4":{"type":"html/text","style":{"width":"264px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #000000;\"><strong><span style=\"font-size: 24px; font-family: arial, helvetica, sans-serif;\">Thank you!</span></strong></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/divider","style":{"width":"264px","padding":"0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#000000","border-top-width":"1px"}}}}}}},"7":{"props":{"style_outer":{"padding":"12px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"1px","border-top-width":"0px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"528px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"528px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/text","style":{"width":"528px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; color: #808080;\">Got questions? Please do write us by visiting the <span style=\"color: #3366ff;\"><a style=\"color: #3366ff;\" href=\"https://bit.ly/3xqdZVE\" target=\"_blank\" rel=\"noopener\">Support &amp; FAQ page</a>.</span></span></p>"},"attrs":{"data-center_on_mobile":"true"},"childStyle":{}}}}}},"8":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#f2f2f2","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}}}}}},"9":{"props":{"style_outer":{"padding":"15px 35px 1px","background-image":"none","background-color":"#ffffff","border-color":"#3c434a","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"528px"}},"elements":{"0":{"type":"html/text","style":{"width":"528px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\">The unique <strong>20%</strong> discount code to share with your <strong>closest friend</strong> or <strong>family</strong>.</p>\n<p style=\"text-align: center;\">Use before <strong>{coupon_expire_date}</strong></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/spacer","style":{"width":"528px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"2":{"type":"html/coupon","style":{"width":"528px","font-size":"15px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#3c434a","line-height":"22px","text-align":"center","padding":"0px"},"content":{"data-coupon-code":"COUPONCODE"},"attrs":{"data-coupon-type":"2","data-discount-type":"","data-coupon-amount":"20%","data-coupon-expiry-date":"28","data-coupon-min-spend":"","data-coupon-max-spend":"","data-coupon-include-product":"3409","data-coupon-exclude-product":"","data-coupon-include-categories":"20","data-coupon-exclude-categories":"","data-coupon-limit-quantity":"1","data-coupon-limit-items":"","data-coupon-limit-users":"1","data-coupon-allow-free-shipping":"","data-coupon-individual":"true","data-coupon-exclude-sale":""},"childStyle":{".viwec-coupon":{"border-width":"2px","border-radius":"12px","border-color":"#cfcfcf","border-style":"dashed","background-color":"#eeeeee","padding":"15px 30px"}}},"3":{"type":"html/spacer","style":{"width":"528px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"4":{"type":"html/text","style":{"width":"528px","line-height":"22px","background-image":"none","padding":"0px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\">Compare your results with them!</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/spacer","style":{"width":"528px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}}}}}},"10":{"props":{"style_outer":{"padding":"15px 35px","background-image":"none","background-color":"#f2f2f2","border-color":"transparent","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#f2f2f2","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#3c434a","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 9.0pt; font-family: 'Times New Roman',serif; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; color: #999999; background: #F2F2F2; mso-ansi-language: EN-US; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\">Vivid Ground</span></p>\n<p style=\"text-align: center;\"><span style=\"font-size: 9.0pt; font-family: 'Times New Roman',serif; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; color: #999999; mso-ansi-language: EN-US; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\"><span><span>USt-IdNr.: DE352430285 | Steuernummer: 35027/00694</span></span><br><span style=\"background: #F2F2F2;\">Managing Directors: Dr. Benedict Heblich, Mouzzam Mehmood Mukadam&nbsp;&nbsp;</span></span></p>\n<p style=\"text-align: center;\"><span style=\"font-size: 9.0pt; font-family: 'Times New Roman',serif; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; color: #999999; mso-ansi-language: EN-US; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;\"><span style=\"background: #F2F2F2;\">You received this email because you ordered a personality test on <a href=\"http://www.findyourvalues.com\">www.findyourvalues.com</a></span></span></p>"},"attrs":{"data-center_on_mobile":"true"},"childStyle":{}}}}}}}}
				],
			],

			'customer_refunded_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-star-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name},&nbsp;</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 20px;\">Your order #{order_number} has been refunded.</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"related","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"7":"footer_block"}}',
				],
			],

			'customer_partially_refunded_order' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-star-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 24px; color: #444444;\">Hi {first_name},&nbsp;</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 20px;\">Your order #{order_number} has been partially refunded.</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"35px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"related","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"7":"footer_block"}}',
				],
			],

			'customer_invoice' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-barcode-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 24px;\">Invoice for order #{order_number}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 16px;\">Hi {customer_name}, Here are the details of your order placed on {order_date}.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"product":"Product","quantity":"Quantity","price":"Price"},"attrs":{"data-template":"1","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{},".viwec-product-img":{},".viwec-product-distance":{},".viwec-product-name":{},".viwec-text-price":{"width":"30%"},".viwec-item-style-1":{"font-size":"15px","color":"#444444","line-height":"22px"},".viwec-product-price":{},".viwec-price-width":{},".viwec-product-quantity":{}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Pay with {payment_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Shipping via {shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Note: {customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"16px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":"footer_block"}}',
				],
			],

			'customer_invoice_pending' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-barcode-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #444444;\"><span style=\"font-size: 24px;\">Invoice for order #{order_number}</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 16px;\">Hi {customer_name}, Here are the details of your order placed on {order_date}. With a <span style=\"font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif;\">link to make payment when you\'re ready: <span style=\"color: #333333;\"><a style=\"color: #333333;\" href=\"{payment_url}\">Pay for this order</a></span></span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"product":"Product","quantity":"Quantity","price":"Price"},"attrs":{"data-template":"1","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{},".viwec-product-img":{},".viwec-product-distance":{},".viwec-product-name":{},".viwec-text-price":{"width":"30%"},".viwec-item-style-1":{"font-size":"15px","color":"#444444","line-height":"22px"},".viwec-product-price":{},".viwec-price-width":{},".viwec-product-quantity":{}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Pay with {payment_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Shipping via {shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"24px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 16px;\">Note: {customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"16px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":"footer_block"}}',
				],
			],

			'customer_note' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-info-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px;\">Hi {customer_name},</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"10px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 16px;\">The following note has been added to your order #{order_number}:</span></p>\n<p><span style=\"font-size: 16px;\"><span style=\"font-size: 16px;\"><strong>{order_note}</strong></span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"10px 0px 0px"},"content":{"text":"VIEW YOUR ORDER"},"attrs":{"href":"{site_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"204px"}}}}}}},"2":{"props":{"style_outer":{"padding":"25px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/order_detail","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"quantity":"Quantity:"},"attrs":{"data-template":"3","show_sku":"","remove_product_link":""},"childStyle":{".viwec-item-row":{"background-color":"transparent","border-width":"0px","border-color":"#808080"},".viwec-product-img":{"width":"150px"},".viwec-product-distance":{"padding":"20px 0px 0px"},".viwec-product-name":{"font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-text-price":{},".viwec-item-style-1":{},".viwec-product-price":{"font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px"},".viwec-price-width":{"width":"120px"},".viwec-product-quantity":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px"}}},"1":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"3":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Payment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p>{payment_method}</p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipment Method</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{shipping_method}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"4":{"type":"html/text","style":{"width":"265px","line-height":"30px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Note</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"5":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"5px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 15px;\">{customer_note}</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/order_subtotal","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"24px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{"subtotal":"Subtotal","discount":"Discount","shipping":"Shipping","refund-full":"Order fully refunded","refund-part":"Refund"},"attrs":{"data-remove_shipping":""},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-subtotal-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}},"1":{"type":"html/order_total","style":{"width":"265px","font-size":"20px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"30px","background-image":"none","background-color":"transparent","padding":"0px"},"content":{"order_total":"Total"},"attrs":{},"childStyle":{".viwec-td-right":{"width":"30%","text-align":"right"},".viwec-td-left":{"text-align":"left"},".viwec-order-total-style":{"border-width":"0px","border-color":"#444444","padding":"0px"}}}}}}},"4":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/spacer","style":{"width":"530px"},"content":{},"attrs":{},"childStyle":{".viwec-spacer":{"padding":"18px 0px 0px"}}},"1":{"type":"html/wc_hook","style":{"width":"530px"},"content":{},"attrs":{"data-wc-hook":"woocommerce_email_order_meta"},"childStyle":{"h2":{"font-size":"20px","font-weight":"400","line-height":"22px","color":"#23282d","background-color":"transparent","padding":"10px 0px"},".td":{"font-size":"15px","line-height":"22px","padding":"8px 0px"},".head.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"1px"},".body.td":{"color":"#444444","background-color":"transparent","border-color":"#e5e5e5","border-style":"dashed","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"0px"}}},"2":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 0px","background-image":"none"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}}}}}},"5":{"props":{"style_outer":{"padding":"0px 35px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid2cols","dataCols":"2"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Billing Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/billing_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{}}}},"1":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"265px"}},"elements":{"0":{"type":"html/text","style":{"width":"265px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"25px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"font-size: 15px;\"><span style=\"font-size: 20px;\">Shipping Address</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"1":{"type":"html/shipping_address","style":{"width":"265px","font-size":"15px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"22px","text-align":"start","padding":"20px 0px 0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-shipping_instance_id":"","data-text_local_pickup":""},"childStyle":{}}}}}},"6":{"props":{"style_outer":{"padding":"0px 35px 25px","background-image":"none","background-color":"#ffffff","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/divider","style":{"width":"530px","padding":"25px 0px 24px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{},"childStyle":{"hr":{"border-top-color":"#f9f9f9","border-top-width":"10px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"22px","background-image":"none","background-color":"transparent","padding":"0px 0px 25px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p><span style=\"font-size: 20px;\">You May Also Like</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/suggest_product","style":{"width":"530px","padding":"0px","background-image":"none","background-color":"transparent"},"content":{},"attrs":{"data-product_type":"related","data-max_row":"1","data-column":"4","data-auto-atc":"","character-limit":"30"},"childStyle":{".viwec-product-name":{"font-size":"14px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-price":{"font-size":"12px","font-weight":"300","font-family":"Helvetica, Arial, sans-serif","color":"#444444","line-height":"18px"},".viwec-product-distance":{"padding":"5px"},".viwec-product-h-distance":{}}}}}}},"7":"footer_block"}}'
				],
			],

			'customer_reset_password' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-badged-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px;\">Password Reset Request</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-size: 16px;\">Hi <strong>{user_login}</strong>, Someone has requested a new password for the following account on {site_title}: </span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\">Username:&nbsp;<strong>{user_login}</strong></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\">If you didn\'t make this request, just ignore this email. If you\'d like to proceed:</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"20px 0px 0px"},"content":{"text":"Click to reset your password"},"attrs":{"href":"{reset_password_url}"},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"260px"}}},"4":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 16px;\">Thanks for reading.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}},"2":"footer_block"}}'
				],
			],

			'customer_new_account' => [
				'basic' => [
					'name' => $basic,
					'data' => '{"style_container":{"background-color":"#f2f2f2","background-image":"none","width":600,"responsive":"414"},"rows":{"0":"header_block","1":{"props":{"style_outer":{"padding":"45px 35px","background-image":"none","background-color":"#f9f9f9","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"100%"},"type":"layout/grid1cols","dataCols":"1"},"cols":{"0":{"props":{"style":{"padding":"0px","background-image":"none","background-color":"transparent","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","width":"530px"}},"elements":{"0":{"type":"html/image","style":{"width":"530px","text-align":"center","padding":"0px","background-image":"none"},"content":{},"attrs":{"src":" ' . VIWEC_IMAGES . 'icon-badged-dark-blue-200x200-1.png","data-href":"","data-alt":""},"childStyle":{"img":{"width":"100px"}}},"1":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"35px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"font-size: 30px; color: #444444;\">Hi {user_login},&nbsp;</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"2":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">Thanks for creating an account on {site_title}. </span></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">Your username is <strong>{user_login}</strong>.</span></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">Your password is:<strong> {user_password}</strong></span></span></p>\n<p style=\"text-align: left;\"><span style=\"font-size: 16px;\"><span style=\"color: #444444;\">You can access your account area to view orders, change your password, and more at:&nbsp;</span></span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}},"3":{"type":"html/button","style":{"width":"530px","font-size":"16px","font-weight":"400","font-family":"Helvetica, Arial, sans-serif","color":"#eeeeee","line-height":"44px","text-align":"center","padding":"20px 0px 0px"},"content":{"text":"Go to your account"},"attrs":{"href":"{myaccount_url} "},"childStyle":{"a":{"border-width":"0px","border-radius":"0px","border-color":"#eeeeee","border-style":"solid","background-color":"#e43f5a","width":"186px"}}},"4":{"type":"html/text","style":{"width":"530px","line-height":"30px","background-image":"none","padding":"20px 0px 0px","border-color":"#444444","border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px"},"content":{"text":"<p style=\"text-align: center;\"><span style=\"color: #636363; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif; font-size: 16px;\">We look forward to seeing you soon.</span></p>"},"attrs":{"data-center_on_mobile":""},"childStyle":{}}}}}},"2":"footer_block"}}'
				],
			],
		] );
	}

	public static function sample_templates( $header, $footer ) {
		$header      = strval( $header );
		$footer      = strval( $footer );
		$all_samples = self::origin_sample_templates();
		foreach ( $all_samples as $key => $samples ) {
			foreach ( $samples as $type => $fields ) {
				$full_template = $fields['data'];
				$full_template = str_replace( [ '"header_block"', '"footer_block"' ], [ $header, $footer ], $full_template );

				$all_samples[ $key ][ $type ]['data'] = $full_template;
			}
		}

		return $all_samples;
	}
}

