<?php
/*
	Plugin Name: Stockie Portfolio
	Plugin URI: http://clbthemes.com
	Description: Supercharge your WordPress site with extended portfolio features.
	Version: 1.0.1
	Author: Colabrio
	Author URI: http://clbthemes.com

	
	Copyright 2024 Colabrio (email: team@clbthemes.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
*/

add_action( 'plugins_loaded', 'stockie_portfolio_load_plugin_textdomain' );

function stockie_portfolio_load_plugin_textdomain() {
    load_plugin_textdomain( 'stockie-portfolio', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}

add_action( 'init', 'stockie_portfolio_register_my_cpts_portfolio' );

function stockie_portfolio_register_my_cpts_portfolio() {
    $labels = array(
        'name' => __( 'Portfolio', 'stockie-portfolio' ),
        'singular_name' => __( 'Project', 'stockie-portfolio' ),
        'menu_name' => __( 'Portfolio', 'stockie-portfolio' ),
        'all_items' => __( 'All Projects', 'stockie-portfolio' ),
        'add_new' => __( 'Add New', 'stockie-portfolio' ),
        'add_new_item' => __( 'Add New Portfolio Project', 'stockie-portfolio' ),
        'edit_item' => __( 'Edit Project', 'stockie-portfolio' ),
        'new_item' => __( 'New Portfolio Project', 'stockie-portfolio' ),
        'view_item' => __( 'View Project', 'stockie-portfolio' ),
        'search_items' => __( 'Search Projects', 'stockie-portfolio' ),
        'not_found' => __( 'No projects found', 'stockie-portfolio' ),
        'not_found_in_trash' => __( 'No projects found in Trash', 'stockie-portfolio' ),
        'parent_item_colon' => __( 'Parent Portfolio:', 'stockie-portfolio' ),
        'featured_image' => __( 'Featured image for this project', 'stockie-portfolio' ),
        'set_featured_image' => __( 'Set featured image for this project', 'stockie-portfolio' ),
        'remove_featured_image' => __( 'Remove featured image for this project', 'stockie-portfolio' ),
        'use_featured_image' => __( 'Use featured image for this project', 'stockie-portfolio' ),
        'archives' => __( 'Portfolio projects archive', 'stockie-portfolio' ),
        'insert_into_item' => __( 'Insert into project', 'stockie-portfolio' ),
        'uploaded_to_this_item' => __( 'Upload to this project', 'stockie-portfolio' ),
        'filter_items_list' => __( 'Filter projects', 'stockie-portfolio' ),
        'items_list_navigation' => __( 'Portfolio projects list navigation', 'stockie-portfolio' ),
        'items_list' => __( 'Portfolio projects list', 'stockie-portfolio' ),
        'parent_item_colon' => __( 'Parent Portfolio:', 'stockie-portfolio' ),
    );

    $args = array(
        'label' => __( 'Portfolio', 'stockie-portfolio' ),
        'labels' => $labels,
        'description' => __( 'Portfolio post type for stockie theme.', 'stockie' ),
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_rest' => true,
        'rest_base' => '',
        'has_archive' => false,
        'show_in_menu' => true,
        'exclude_from_search' => false,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => false,
        'rewrite' => array( 'slug' => 'project', 'with_front' => true ),
        'query_var' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-portfolio',
        'supports' => array( 'title', 'comments', 'editor', 'thumbnail' ),
    );
    register_post_type( 'stockie_portfolio', $args );
}

function stockie_portfolio_category_init() {
    $labels = array(
        'name' => _x( 'Categories', 'taxonomy general name', 'stockie-portfolio' ),
        'singular_name' => _x( 'Category', 'taxonomy singular name', 'stockie-portfolio' ),
        'search_items' => __( 'Search Categories', 'stockie-portfolio' ),
        'popular_items' => __( 'Popular Categories', 'stockie-portfolio' ),
        'all_items' => __( 'Categories', 'stockie-portfolio' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit Category', 'stockie-portfolio' ),
        'update_item' => __( 'Update Category', 'stockie-portfolio' ),
        'add_new_item' => __( 'Add New Category', 'stockie-portfolio' ),
        'new_item_name' => __( 'New Portfolio Category', 'stockie-portfolio' ),
        'separate_items_with_commas' => __( 'Separate categories with commas', 'stockie-portfolio' ),
        'add_or_remove_items' => __( 'Add or remove categories', 'stockie-portfolio' ),
        'choose_from_most_used' => __( 'Choose from the most used categories', 'stockie-portfolio' ),
        'not_found' => __( 'No categories found.', 'stockie-portfolio' ),
        'menu_name' => __( 'Categories', 'stockie-portfolio' ),
    );

    $args = array(
        'hierarchical' => false,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'portfolio_category' ),
    );

    register_taxonomy( 'stockie_portfolio_category', array( 'stockie_portfolio' ), $args );

    $labels = array(
        'name' => _x( 'Tags', 'taxonomy general name', 'stockie-portfolio' ),
        'singular_name' => _x( 'Tag', 'taxonomy singular name', 'stockie-portfolio' ),
        'search_items' => __( 'Search Tags', 'stockie-portfolio' ),
        'popular_items' => __( 'Popular Tags', 'stockie-portfolio' ),
        'all_items' => __( 'Tags', 'stockie-portfolio' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit Tag', 'stockie-portfolio' ),
        'update_item' => __( 'Update Tag', 'stockie-portfolio' ),
        'add_new_item' => __( 'Add New Tag', 'stockie-portfolio' ),
        'new_item_name' => __( 'New Portfolio Tag', 'stockie-portfolio' ),
        'separate_items_with_commas' => __( 'Separate tags with commas', 'stockie-portfolio' ),
        'add_or_remove_items' => __( 'Add or remove tags', 'stockie-portfolio' ),
        'choose_from_most_used' => __( 'Choose from the most used tags', 'stockie-portfolio' ),
        'not_found' => __( 'No tags found.', 'stockie-portfolio' ),
        'menu_name' => __( 'Tags', 'stockie-portfolio' ),
    );
    $args = array(
        'hierarchical' => false,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'portfolio_tags' ),
    );

    register_taxonomy( 'stockie_portfolio_tags', array( 'stockie_portfolio' ), $args );
}

add_action( 'init', 'stockie_portfolio_category_init' );


function stockie_portfolio_flush() {
    flush_rewrite_rules(); // Fix 404 page on projects. Flush rules
}

register_activation_hook( __FILE__, 'stockie_portfolio_flush' );

?>