<?php

/**
* WPBakery Page Builder Stockie Video shortcode params
*/

vc_map( array(
	'name' => __( 'WooCommerce Products', 'stockie-extra' ),
	'description' => __( 'Styled WC products grid block', 'stockie-extra' ),
	'base' => 'stockie_woo_grid',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Product grid layout', 'stockie-extra' ),
			'param_name' => 'grid_type',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_inherit.svg',
					'key' => 'inherit',
					'title' => __( 'Theme settings inherited', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_092.svg',
					'key' => 'type_1',
					'title' => __( 'Classic', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_093.svg',
					'key' => 'type_2',
					'title' => __( 'Minimal', 'stockie-extra' ),
				),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_094.svg',
                    'key' => 'type_3',
                    'title' => __( 'Scattered', 'stockie-extra' ),
                ),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_095.svg',
                    'key' => 'type_4',
                    'title' => __( 'Carousel', 'stockie-extra' ),
                )
			)
		),
        array(
            'type' => 'stockie_choose_box',
            'group' => __( 'General', 'stockie-extra' ),
            'heading' => __( 'Product grid hover effects', 'stockie-extra' ),
            'param_name' => 'grid_hover',
            'value' => array(
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_inherit.svg',
                    'key' => 'inherit',
                    'title' => __( 'Theme settings inherited', 'stockie-extra' ),
                ),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_096.svg',
                    'key' => 'type_1',
                    'title' => __( 'Nav buttons', 'stockie-extra' ),
                ),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_097.svg',
                    'key' => 'type_2',
                    'title' => __( 'Image overlay', 'stockie-extra' ),
                ),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_006.svg',
                    'key' => 'type_3',
                    'title' => __( 'Color overlay', 'stockie-extra' ),
                ),
            )
        ),
		array(
			'type' => 'stockie_woo_categories_types',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Product categories', 'stockie-extra' ),
			'param_name' => 'woo_categories',
			'description' => 'Leave empty if you want use all categories'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Overlay background color', 'stockie-extra' ),
			'param_name' => 'background_overlay',
			'value' => array(
				__( 'Enable', 'stockie-extra' ) => '1'
			),
			'description' => __( 'Choose background color for overlay', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'grid_hover',
				'value' => array(
					'type_3',
				)
			),
		),


		// Grid
        array(
            'type' => 'textfield',
            'holder' => 'em',
            'group' => __( 'Grid', 'stockie-extra' ),
            'heading' => __( 'Product images in gallery', 'stockie-extra' ),
            'param_name' => 'product_images_count',
            'description' => __( 'Choose the number of product images for single product gallery', 'stockie-extra' ),
        ),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Masonry layout', 'stockie-extra' ),
			'param_name' => 'masonry_layout',
			'value' => array(
				__( 'Enable', 'stockie-extra' ) => '1'
			),
			'description' => __( 'Enable masonry layout for product items', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'grid_type',
				'value' => array(
					'inherit',
					'type_1',
					'type_2',
					'type_3',
				)
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Mouse wheel scroll', 'stockie-extra' ),
			'param_name' => 'slider_mouse_scroll',
			'value' => array(
				__( 'Enable', 'stockie-extra' ) => '1'
			),
			'description' => __( 'Enable mouse wheel scroll navigation', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'grid_type',
				'value' => array(
					'type_4',
				)
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Grid animation effect', 'stockie-extra' ),
			'param_name' => 'animation_type',
			'value' => array(
				__( 'Disable animation', 'stockie-extra' ) => 'without-animation',
				__( 'Sync animation', 'stockie-extra' ) => 'sync',
				__( 'Async animation', 'stockie-extra' ) => 'async',
			),
			'description' => __( 'Choose grid animation type', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'masonry_layout',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Grid animation effect', 'stockie-extra' ),
			'param_name' => 'animation_effect',
			'value' => array(
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out',
			),
			'description' => __( 'Choose items appear effect.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'masonry_layout',
				'value' => array(
					'1'
				)
			),
		),
        array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Grid alignment', 'stockie-extra' ),
			'param_name' => 'text_alignment',
			'value' => array(
				__( 'Use from Theme Settings', 'stockie-extra' ) => 'inherit',
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'description' => __( 'Choose text alignment for product items.', 'stockie-extra' ),
			'dependency' => 0,
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Grid', 'stockie-extra' ),
			'param_name' => 'views_tab_divider_title',
			'value' => __( 'Product items per row', 'stockie-extra' )
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Desktop devices', 'stockie-extra' ),
			'param_name' => 'desktop_items',
			'value' => array(
				__( '1 column', 'stockie-extra' ) => '1',
				__( '2 columns', 'stockie-extra' ) => '2',
				__( '3 columns', 'stockie-extra' ) => '3',
				__( '4 columns', 'stockie-extra' ) => '4',
				__( '5 columns', 'stockie-extra' ) => '5',
				__( '6 columns', 'stockie-extra' ) => '6',
				__( '12 columns', 'stockie-extra' ) => '12',
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Tablet devices', 'stockie-extra' ),
			'param_name' => 'tablet_items',
			'value' => array(
				__( '1 column', 'stockie-extra' ) => '1',
				__( '2 columns', 'stockie-extra' ) => '2',
				__( '3 columns', 'stockie-extra' ) => '3',
				__( '4 columns', 'stockie-extra' ) => '4',
				__( '5 columns', 'stockie-extra' ) => '5',
				__( '6 columns', 'stockie-extra' ) => '6',
				__( '12 columns', 'stockie-extra' ) => '12',
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Mobile devices', 'stockie-extra' ),
			'param_name' => 'mobile_items',
			'value' => array(
				__( '1 column', 'stockie-extra' ) => '1',
				__( '2 columns', 'stockie-extra' ) => '2',
				__( '3 columns', 'stockie-extra' ) => '3',
				__( '4 columns', 'stockie-extra' ) => '4',
				__( '5 columns', 'stockie-extra' ) => '5',
				__( '6 columns', 'stockie-extra' ) => '6',
				__( '12 columns', 'stockie-extra' ) => '12',
			),
		),
		array(
			'type' => 'textfield',
			'holder' => 'em',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Product items per page', 'stockie-extra' ),
			'param_name' => 'items_per_page',
			'description' => __( 'Choose the number of product items per page.', 'stockie-extra' ),
		),

		// Pagination
		array(
			'type' => 'dropdown',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Pagination', 'stockie-extra' ),
			'param_name' => 'pagination_type',
			'value' => array(
				__( 'Simple', 'stockie-extra' ) => 'simple',
				__( 'Lazy load', 'stockie-extra' ) => 'lazy_scroll',
				__( 'Load more', 'stockie-extra' ) => 'lazy_button',
			),
			'description' => __( 'Choose pagination type for shop page', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'grid_type',
				'value' => array(
					'inherit',
					'type_1',
					'type_2',
					'type_3',
				)
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Pagination position', 'stockie-extra' ),
			'param_name' => 'pagination_position',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'description' => __( 'Choose pagination type for shop page', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'grid_type',
				'value' => array(
					'inherit',
					'type_1',
					'type_2',
					'type_3',
				)
			),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_category',
			'value' => __( 'Caterory', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'category_typo'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_price',
			'value' => __( 'Price', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'price_typo'
		),

        // Styles
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_colors',
			'value' => __( 'Colors', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Category color', 'stockie-extra' ),
			'param_name' => 'category_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Price color', 'stockie-extra' ),
			'param_name' => 'price_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Sale tag background color', 'stockie-extra' ),
			'param_name' => 'sale_background_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Out of stock tag background color', 'stockie-extra' ),
			'param_name' => 'stock_background_color'
		),

		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),
	)
) );