<?php

/**
 * WPBakery Page Builder Stockie WooCoomerce products grid module shortcode
 */

add_shortcode('stockie_woo_grid', 'stockie_woo_grid_func');

function stockie_woo_grid_func($atts)
{
    $grid_type = $background_overlay = $grid_hover = $product_images_count = $animation_effect = $text_alignment = $woo_categories = $masonry_layout = $animation_type = $desktop_items = $tablet_items = $mobile_items = $items_per_page = $pagination_type = $pagination_position = $title_typo = $category_typo = $price_typo = $title_color = $category_color = $price_color = $sale_background_color = $stock_background_color = $css_class = NULL;
    if (isset($atts) && is_array($atts)) extract($atts);

    // Default values, parsing and filtering

    global $post;

    $grid_type = StockieExtraFilter::string($grid_type, 'string', 'inherit');

    $hover_type = StockieExtraFilter::string($grid_hover, 'string', 'inherit');

    if (in_array($grid_type, array('inherit', NULL))) {
        $grid_type = StockieSettings::get('woocommerce_grid_type', 'global');
        if ($grid_type == NULL) {
            $grid_type = 'type_1';
        }
    }
    if (in_array($hover_type, array('inherit', NULL))) {
        $hover_type = StockieSettings::get('woocommerce_grid_hover', 'global');
        if ($grid_hover == NULL) {
            $hover_type = 'default';
        }
    }
    $hover_type_class = '';
    if ($hover_type == NULL) {
        $hover_type_class = 'product-hover-1';
    }
    if ($hover_type == 'type_1') {
        $hover_type_class = 'product-hover-1';
    }
    if ($hover_type == 'type_2') {
        $hover_type_class = 'product-hover-2';
    }
    if ($hover_type == 'type_3') {
        $hover_type_class = 'product-hover-3';
    }

    $product_images_count = StockieExtraFilter::string($product_images_count, 'string', '2');
    if(empty($product_images_count)) {
        $product_images_count = 2;
    }

    $items_per_page = StockieExtraFilter::string($items_per_page, 'attr', '1');
    if (get_query_var('paged')) {
        $paged = get_query_var('paged');
    } elseif (get_query_var('page')) {
        $paged = get_query_var('page');
    } else {
        $paged = 1;
    }

    $woo_categories = StockieExtraFilter::string($woo_categories, 'string', '');

    $use_masonry_grid = isset($masonry_layout) ? StockieExtraFilter::boolean($masonry_layout) : true;

    $animation_type = StockieExtraFilter::string($animation_type, 'attr', 'without-animation');
    $animation_effect = StockieExtraFilter::string($animation_effect, 'attr', 'fade-up');

    $text_alignment= StockieExtraFilter::string($text_alignment, 'string', 'inherit');
    if (in_array($text_alignment, array('inherit', NULL))) {
        $text_alignment = StockieSettings::get('woocommerce_text_alignment', 'global');
        if ($grid_hover == NULL) {
            $text_alignment = 'left';
        }
    }

    $desktop_items = StockieExtraFilter::string($desktop_items, 'attr', '1');
    $tablet_items = StockieExtraFilter::string($tablet_items, 'attr', '1');
    $mobile_items = StockieExtraFilter::string($mobile_items, 'attr', '1');
    $row_class = '';
    $row_class .= ' columns-' . $desktop_items;
    $row_class .= ' columns-md-' . $tablet_items;
    $row_class .= ' columns-sm-' . $mobile_items;

    $row_atts = '';
    $row_atts = ' data-desktop-items=' . $desktop_items;
    $row_atts .= ' data-tablet-items=' . $tablet_items;
    $row_atts .= ' data-mobile-items=' . $mobile_items;


    $css_class = StockieExtraFilter::string($css_class, 'attr', 'simple');

    $pagination_type = StockieExtraFilter::string($pagination_type, 'attr', 'simple');
    $pagination_position = StockieExtraFilter::string($pagination_position, 'attr', 'left');

    $title_typo = StockieExtraFilter::string($title_typo, 'string', '');
    $category_typo = StockieExtraFilter::string($category_typo, 'string', '');
    $price_typo = StockieExtraFilter::string($price_typo, 'string', '');

    // Styling
    $woo_grid_uniqid = uniqid('stockie-shop-grid-');

    $title_css = StockieExtraParser::VC_typo_to_CSS($title_typo);
    $title_css .= StockieExtraParser::VC_color_to_CSS($title_color, 'color:{{color}};');
    $category_css = StockieExtraParser::VC_typo_to_CSS($category_typo);
    $category_css .= StockieExtraParser::VC_color_to_CSS($category_color, 'color:{{color}};');
    $price_css = StockieExtraParser::VC_typo_to_CSS($price_typo);
    $price_css .= StockieExtraParser::VC_color_to_CSS($price_color, 'color:{{color}};');
    $sale_background_color = StockieExtraParser::VC_color_to_CSS($sale_background_color, 'background-color:{{color}};');
    $stock_background_color = StockieExtraParser::VC_color_to_CSS($stock_background_color, 'background-color:{{color}};');
    $background_overlay = StockieExtraParser::VC_color_to_CSS($background_overlay, 'background-color:{{color}};');
    
    include(plugin_dir_path(__FILE__) . 'woo_grid__style.php');

    // Assembling

    if ($woo_categories) {
        $woo_categories = explode(',', $woo_categories);
        $args = array(
            'posts_per_page' => $items_per_page,
            'post_type' => 'product',
            'paged' => $paged,
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field' => 'id',
                    'terms' => $woo_categories
                )
            )
        );
    } else {
        $args = array(
            'posts_per_page' => $items_per_page,
            'post_type' => 'product',
            'paged' => $paged
        );
    }
    $query = new WP_Query($args);

    ob_start();
    echo '<div class="'. esc_attr($css_class) .'" id="' . $woo_grid_uniqid . '">';
    switch ($grid_type) {
        case 'type_1':
            include(plugin_dir_path(__FILE__) . 'views/type_1.php');
            break;
        case 'type_2':
            include(plugin_dir_path(__FILE__) . 'views/type_2.php');
            break;
        case 'type_3':
            include(plugin_dir_path(__FILE__) . 'views/type_3.php');
            break;
        case 'type_4':
            include(plugin_dir_path(__FILE__) . 'views/type_4.php');
            break;
        default:
            include(plugin_dir_path(__FILE__) . 'views/type_1.php');
            break;
    }
    wp_reset_query();
    echo "</div>";
    return ob_get_clean();
}
