<nav class="pagination text-<?php echo esc_attr( $pagination_position ); ?>">
	<?php

		switch ( $pagination_type ) {
			case 'simple':
                if ( get_query_var( 'paged' ) ) {
                    $current = get_query_var( 'paged' );
                } elseif ( get_query_var( 'page' ) ) {
                    $current = get_query_var( 'page' );
                } else {
                    $current = 1;
                }
				$paginate = paginate_links( apply_filters( 'woocommerce_pagination_args', array(
					'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
					'format'       => '',
					'add_args'     => false,
					'current'      => $current,
					'total'        => $query->max_num_pages,
					'prev_text'    => '<span class="btn btn-link"><i class="ion-left ion ion-ios-arrow-back"></i> Prev</span>',
					'next_text'    => '<span class="btn btn-link">Next  <i class="ion-right ion ion-ios-arrow-forward"></i></span>',
					'type'         => 'list',
					'end_size'     => 3,
					'mid_size'     => 3,
				) ) );


				$paginate = str_replace( '<a class="', '<a class=" ', $paginate );
				echo str_replace( '<a class=\'', '<a class=\' ', $paginate );
				break;
		 	case 'lazy_scroll':
				echo '<div class="lazy-load loading font-titles text-' . $pagination_position . '" data-lazy-load="scroll" data-lazy-pages-count="' . esc_attr( $query->max_num_pages ) . '">';
				echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie' ) . '</span>';
				echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
				echo '</div>';
				break;
			case 'lazy_button':
				echo '<div class="lazy-load load-more font-titles text-' . $pagination_position . '" data-lazy-load="click" data-lazy-pages-count="' . esc_attr( $query->max_num_pages ) . '">';
				echo '<span class="loadmore-text">' . esc_html__( 'Load More', 'stockie' ) . '</span>';
				echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie' ) . '</span>';
				echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
				echo '</div>';
				break;
		}

	?>
</nav>
