<?php

/**
* WPBakery Page Builder Stockie Video shortcode params
*/

vc_map( array(
	'name' => __( 'WooCommerce Categories', 'stockie-extra' ),
	'description' => __( 'Styled WC categories block', 'stockie-extra' ),
	'base' => 'stockie_woo_categories',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Categories layout', 'stockie-extra' ),
			'param_name' => 'layout',
			'value' => array(
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_086.svg',
                    'key' => 'block',
                    'title' => __( 'Overlay', 'stockie-extra' ),
                ),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_088.svg',
					'key' => 'default',
					'title' => __( 'Offset', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_088.svg',
					'key' => 'boxed',
					'title' => __( 'Boxed', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Categories alignment', 'stockie-extra' ),
			'param_name' => 'alignment',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_035.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_036.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_037.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Description position', 'stockie-extra' ),
			'param_name' => 'subtitle_position',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_038.svg',
					'key' => 'top',
					'title' => __( 'Top', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_035.svg',
					'key' => 'bottom',
					'title' => __( 'Bottom', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Reverse row for boxed layout', 'stockie-extra' ),
			'param_name' => 'row_reverse',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0',
			),
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'boxed',
					true
				)
			)
		),
		array(
			'type' => 'stockie_woo_categories_types',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Categories', 'stockie-extra' ),
			'param_name' => 'woo_categories',
			'description' => 'Leave empty if you want use all categories'
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Columns number', 'stockie-extra' ),
			'param_name' => 'layout_columns',
			'value' => array(
				__( '1 column', 'stockie-extra' ) => '1',
				__( '2 columns', 'stockie-extra' ) => '2',
				__( '3 columns', 'stockie-extra' ) => '3',
				__( '4 columns', 'stockie-extra' ) => '4'
			),
			'description' => __( 'Choose grid columns number.', 'stockie-extra' ),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_description',
			'value' => __( 'Description', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'description_typo'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_button',
			'value' => __( 'Button', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'button_typo'
		),

		// Styles
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_colors',
			'value' => __( 'Colors', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Description color', 'stockie-extra' ),
			'param_name' => 'description_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Decoration color', 'stockie-extra' ),
			'param_name' => 'decoration_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Overlay color', 'stockie-extra' ),
			'param_name' => 'overlay_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background color', 'stockie-extra' ),
			'param_name' => 'background_color'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_button',
			'value' => __( 'Button', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_button',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( '', 'stockie-extra' ),
			'param_name' => 'button'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_other',
			'value' => __( 'Other', 'stockie-extra' )
		),

		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );