<?php 

/**
* WPBakery Page Builder Stockie Video shortcode
*/

add_shortcode( 'stockie_video', 'stockie_video_func' );

function stockie_video_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$layout = isset( $layout ) ? StockieExtraFilter::string( $layout, 'string', 'boxed_shape') : 'boxed_shape';
	$button_layout = isset( $button_layout ) ? StockieExtraFilter::string( $button_layout, 'string', 'filled') : 'filled';
	$preview_image = isset( $preview_image ) ? wp_get_attachment_url( $preview_image ) : false;
	$link = isset( $link ) ? StockieExtraFilter::string( $link, 'string', '' ) : '';
	$title = isset( $title ) ? rawurldecode( base64_decode( $title ) ) : '';
	$title = StockieExtraFilter::string( $title, 'string', '' );
	$alignment = isset( $alignment ) ? StockieExtraFilter::string( $alignment, 'string', 'center' ) : 'center';

	$title_typo = isset( $title_typo ) ? StockieExtraFilter::string( $title_typo ) : false;

	$border_color = isset( $border_color ) ? StockieExtraFilter::string( $border_color, 'string', false ) : false;
	$button_anim = isset( $button_anim ) ? StockieExtraFilter::boolean( $button_anim ) : false;
	$button_color = isset( $button_color ) ? StockieExtraFilter::string( $button_color, 'string', false ) : false;
	$button_hover_color = isset( $button_hover_color ) ? StockieExtraFilter::string( $button_hover_color, 'string', false ) : false;
	$icon_color = isset( $icon_color ) ? StockieExtraFilter::string( $icon_color, 'string', false ) : false;
	$icon_hover_color = isset( $icon_hover_color ) ? StockieExtraFilter::string( $icon_hover_color, 'string', false ) : false;
	$title_color = isset( $title_color ) ? StockieExtraFilter::string( $title_color, 'string', false ) : false;

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' ) : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false ) : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) : '';

	$url = parse_url( $link );

	// YouTube
	if ( isset( $url['host'] ) ) {
		if ( $url['host'] == 'www.youtube.com' || $url['host'] == 'youtube.com' || $url['host'] == 'youtu.be' ) {
			if ( isset( $url['query'] ) ) {
				parse_str( $url['query'], $query );
			}

			if ( isset( $query['v'] ) && $query['v'] ) {
				$link = 'https://www.youtube.com/embed/' . $query['v'];
			}
		}

		// Vimeo
		if ( isset( $url['host'] ) && ( $url['host'] == 'www.vimeo.com' || $url['host'] == 'vimeo.com' ) ) {
			if ( isset( $url['path'] ) && $url['path'] ) {
				$link = 'https://player.vimeo.com/video' . $url['path'];
			}
		}
	}
	
	// Styling
	$video_module_uniqid = uniqid( 'stockie-custom-' );
	
	$video_module_class = '';

	if ( $layout == 'boxed_shape' || $layout == 'outline' ) {
		$video_module_class .= ' boxed';
	}
	if ( $button_anim ){
		$video_module_class .= ' with-anim';
	}
	
	$title_settings = StockieExtraParser::VC_color_to_CSS( $title_color, 'color:{{color}};' );

	$video_module_settings = '';
	if ( $layout != 'with_preview' ) {
		$border_settings = StockieExtraParser::VC_color_to_CSS( $border_color, 'border-color:{{color}};' );
		$video_module_settings .= $border_settings;
	}
	
	$button_settings = '';
	$button_hover_settings = '';
	$button_outline_settings = '';

	if ( $button_layout == 'outline' ) {
		$button_settings = StockieExtraParser::VC_color_to_CSS( $button_color, 'border-color:{{color}};' );
		$button_outline_settings = StockieExtraParser::VC_color_to_CSS( $button_color, 'background:{{color}};' );
		$button_hover_settings = StockieExtraParser::VC_color_to_CSS( $button_hover_color, 'background:{{color}} !important; border-color:{{color}}!important;' );
	} else {
		$button_settings = StockieExtraParser::VC_color_to_CSS( $button_color, 'background-color:{{color}};border-color:{{color}};' );
		$button_hover_settings = StockieExtraParser::VC_color_to_CSS( $button_hover_color, 'background:{{color}} !important; border-color:{{color}}!important;' );
	}

	$button_after_before_css = '';
	if ( $button_color && $button_color != 'brand' ) {
		$button_after_before_css .= 'border-color:' . $button_color . ';';
	}

	$button_settings_class = '';
	if ( $button_layout == 'outline' ) {
		$button_settings_class .= ' outline';
	}

	$icon_settings = StockieExtraParser::VC_color_to_CSS( $icon_color, 'color:{{color}};' );
	$icon_hover_settings = StockieExtraParser::VC_color_to_CSS( $icon_hover_color, 'color:{{color}} !important;' );

	StockieExtraParser::VC_typo_custom_font( $title_typo );

	$title_settings .= StockieExtraParser::VC_typo_to_CSS( $title_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'video__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'video__view.php' );
	return ob_get_clean();
}