<?php

/**
* WPBakery Page Builder Stockie Message module shortcode params
*/


vc_map( array(
	'name' => __( 'Text', 'stockie-extra' ),
	'description' => __( 'Simple text block', 'stockie-extra' ),
	'base' => 'stockie_text',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'textarea_html',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Content', 'stockie-extra' ),
			'param_name' => 'content',
			'description' => '',
			'holder' => 'span',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_text',
			'value' => __( 'Typography', 'stockie-extra' ),
		),

		// Typography
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'text_typo',
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Text color', 'stockie-extra' ),
			'param_name' => 'text_color'
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );