<?php


vc_map( array(
	'name' => __( 'Testimonial', 'stockie-extra' ),
	'description' => __( 'Testimonial module', 'stockie-extra' ),
	'base' => 'stockie_testimonial',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'js_view' => 'VcStockieTestimonialView',
	'custom_markup' => '{{title}}<div class="vc_stockie_testimonial-container">
			<div class="lines"><div class="line"></div><div class="line"></div><div class="line"></div></div>
			<div class="photo"></div>
			<div class="name">%%author%%</div>
			<div class="position"></div>
		</div>',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Testimonial layout', 'stockie-extra' ),
			'param_name' => 'block_type_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_071.svg',
					'key' => 'default',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_065.svg',
					'key' => 'photo_top',
					'title' => __( 'Image Top', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_068.svg',
					'key' => 'photo_middle',
					'title' => __( 'Image Middle', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Testimonial alignment', 'stockie-extra' ),
			'param_name' => 'block_type_alignment_default',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_071.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_070.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_072.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			),
			'dependency' => array(
				'element' => 'block_type_layout',
				'value' => array(
					'default'
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Box alignment', 'stockie-extra' ),
			'param_name' => 'block_type_alignment_top',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_065.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_064.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_066.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			),
			'dependency' => array(
				'element' => 'block_type_layout',
				'value' => array(
					'photo_top'
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Box alignment', 'stockie-extra' ),
			'param_name' => 'block_type_alignment_middle',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_068.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_067.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_069.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			),
			'dependency' => array(
				'element' => 'block_type_layout',
				'value' => array(
					'photo_middle'
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Headline text', 'stockie-extra' ),
			'param_name' => 'headline'
		),
		array(
			'type' => 'textarea',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Testimonial text', 'stockie-extra' ),
			'param_name' => 'quote'
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Author image', 'stockie-extra' ),
			'param_name' => 'photo',
			'description' => __( 'Choose author photo.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'block_type_layout',
				'value' => array(
					'photo_top',
					'photo_middle',
					'photo_and_mark'
				)
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'em',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Author name', 'stockie-extra' ),
			'param_name' => 'author',
			'description' => __( 'Testimonial author name.', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Author position', 'stockie-extra' ),
			'param_name' => 'position',
			'description' => __( 'For example, <strong>Product manager</strong>.', 'stockie-extra' )
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_headline',
			'value' => __( 'Headline text', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'headline_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_quote',
			'value' => __( 'Testimonial text', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'quote_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_author',
			'value' => __( 'Author', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'author_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_position',
			'value' => __( 'Position', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'position_typo',
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Headline color', 'stockie-extra' ),
			'param_name' => 'headline_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Testimonial color', 'stockie-extra' ),
			'param_name' => 'quote_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Author image border color', 'stockie-extra' ),
			'param_name' => 'image_border_color',
			'dependency' => array(
				'element' => 'block_type_layout',
				'value' => array(
					'photo_top',
					'photo_middle',
				)
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Author name color', 'stockie-extra' ),
			'param_name' => 'author_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Author position color', 'stockie-extra' ),
			'param_name' => 'position_color'
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );