<?php 

/**
* WPBakery Page Builder Stockie Team Members Group shortcode
*/

add_shortcode( 'stockie_team_members_group', 'stockie_team_members_group_func' );

function stockie_team_members_group_func( $atts, $content = '' ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$content_bg = isset( $content_bg ) ? StockieExtraFilter::string( $content_bg ) : false;
	
	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' ) : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false ) : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	// Styling
	$team_group_uniqid = uniqid( 'argenta-custom-' );

	$content_bg_css = '';
	if ( $content_bg ) {
		$content_bg_css = 'background-color:' . $content_bg . ';';
	}

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'team_members_group__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'team_members_group__view.php' );
	return ob_get_clean();
}