<?php 

/**
* WPBakery Page Builder Stockie Team member inner shortcode
*/

add_shortcode( 'stockie_team_member_inner', 'stockie_team_member_inner_func' );

function stockie_team_member_inner_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$name = isset( $name ) ? StockieExtraFilter::string( $name, 'string', '' ) : '';
	$position = isset( $position ) ? StockieExtraFilter::string( $position, 'string', '' ) : '';
	$description = isset( $description ) ? StockieExtraFilter::string( $description, 'textarea', '' ) : '';
	$photo = isset( $photo ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $photo ) ), 'attr' ) : false;

	// Social networks
	$artstation_link = isset( $artstation_link ) ? StockieExtraFilter::string( $artstation_link ) : false;
	$behance_link = isset( $behance_link ) ? StockieExtraFilter::string( $behance_link ) : false;
	$deviantart_link = isset( $deviantart_link ) ? StockieExtraFilter::string( $deviantart_link ) : false;
	$digg_link = isset( $digg_link ) ? StockieExtraFilter::string( $digg_link ) : false;
	$discord_link = isset( $discord_link ) ? StockieExtraFilter::string( $discord_link ) : false;
	$dribbble_link = isset( $dribbble_link ) ? StockieExtraFilter::string( $dribbble_link ) : false;
	$facebook_link = isset( $facebook_link ) ? StockieExtraFilter::string( $facebook_link ) : false;
	$flickr_link = isset( $flickr_link ) ? StockieExtraFilter::string( $flickr_link ) : false;
	$github_link = isset( $github_link ) ? StockieExtraFilter::string( $github_link ) : false;
	$houzz_link = isset( $houzz_link ) ? StockieExtraFilter::string( $houzz_link ) : false;
	$instagram_link = isset( $instagram_link ) ? StockieExtraFilter::string( $instagram_link ) : false;
	$kaggle_link = isset( $kaggle_link ) ? StockieExtraFilter::string( $kaggle_link ) : false;
	$linkedin_link = isset( $linkedin_link ) ? StockieExtraFilter::string( $linkedin_link ) : false;
	$medium_link = isset( $medium_link ) ? StockieExtraFilter::string( $medium_link ) : false;
	$mixer_link = isset( $mixer_link ) ? StockieExtraFilter::string( $mixer_link ) : false;
	$pinterest_link = isset( $pinterest_link ) ? StockieExtraFilter::string( $pinterest_link ) : false;
	$producthunt_link = isset( $producthunt_link ) ? StockieExtraFilter::string( $producthunt_link ) : false;
	$quora_link = isset( $quora_link ) ? StockieExtraFilter::string( $quora_link ) : false;
	$reddit_link = isset( $reddit_link ) ? StockieExtraFilter::string( $reddit_link ) : false;
	$snapchat_link = isset( $snapchat_link ) ? StockieExtraFilter::string( $snapchat_link ) : false;
	$soundcloud_link = isset( $soundcloud_link ) ? StockieExtraFilter::string( $soundcloud_link ) : false;
	$spotify_link = isset( $spotify_link ) ? StockieExtraFilter::string( $spotify_link ) : false;
	$teamspeak_link = isset( $teamspeak_link ) ? StockieExtraFilter::string( $teamspeak_link ) : false;
	$telegram_link = isset( $telegram_link ) ? StockieExtraFilter::string( $telegram_link ) : false;
	$threads_link = isset( $threads_link ) ? StockieExtraFilter::string( $threads_link ) : false;
	$tiktok_link = isset( $tiktok_link ) ? StockieExtraFilter::string( $tiktok_link ) : false;
	$tumblr_link = isset( $tumblr_link ) ? StockieExtraFilter::string( $tumblr_link ) : false;
	$twitch_link = isset( $twitch_link ) ? StockieExtraFilter::string( $twitch_link ) : false;
	$twitter_link = isset( $twitter_link ) ? StockieExtraFilter::string( $twitter_link ) : false;
	$vimeo_link = isset( $vimeo_link ) ? StockieExtraFilter::string( $vimeo_link ) : false;
	$vine_link = isset( $vine_link ) ? StockieExtraFilter::string( $vine_link ) : false;
	$whatsapp_link = isset( $whatsapp_link ) ? StockieExtraFilter::string( $whatsapp_link ) : false;
	$xing_link = isset( $xing_link ) ? StockieExtraFilter::string( $xing_link ) : false;
	$youtube_link = isset( $youtube_link ) ? StockieExtraFilter::string( $youtube_link ) : false;
	$fivehundred_link = isset( $fivehundred_link ) ? StockieExtraFilter::string( $fivehundred_link ) : false;

	$name_typo = isset( $name_typo ) ? StockieExtraFilter::string( $name_typo ) : false;
	$position_typo = isset( $position_typo ) ? StockieExtraFilter::string( $position_typo ) : false;
	$desription_typo = isset( $desription_typo ) ? StockieExtraFilter::string( $desription_typo ) : false;
	$overlay_color = isset( $overlay_color ) ? StockieExtraFilter::string( $overlay_color ) : false;
	$name_color = isset( $name_color ) ? StockieExtraFilter::string( $name_color ) : false;
	$position_color = isset( $position_color ) ? StockieExtraFilter::string( $position_color ) : false;
	$description_color = isset( $description_color ) ? StockieExtraFilter::string( $description_color ) : false;
	$social_color = isset( $social_color ) ? StockieExtraFilter::string( $social_color ) : false;
	$social_hover_color = isset( $social_hover_color ) ? StockieExtraFilter::string( $social_hover_color ) : false;
	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	// Styling
	$team_member_uniqid = uniqid( 'stockie-custom-' );
	$overlay_settings = StockieExtraParser::VC_color_to_CSS( $overlay_color, 'background:{{color}};' );
	$name_settings = StockieExtraParser::VC_color_to_CSS( $name_color, 'color:{{color}};' );
	$position_settings = StockieExtraParser::VC_color_to_CSS( $position_color, 'color:{{color}};' );
	$description_settings = StockieExtraParser::VC_color_to_CSS( $description_color, 'color:{{color}};' );
	$social_settings = StockieExtraParser::VC_color_to_CSS( $social_color, 'background-color:{{color}};border-color:{{color}};' );
	$social_hover_settings = StockieExtraParser::VC_color_to_CSS( $social_hover_color, 'color:{{color}};border-color:{{color}};background:transparent;' );

	if( !$social_hover_settings && $name_color ) {
		$social_hover_settings = 'background:transparent;';
	}

	$social_settings_class = '';
	if ( !$social_color ) {
		$social_settings_class .= ' default';
	}

	$name_settings .= StockieExtraParser::VC_typo_to_CSS( $name_typo );
	$position_settings .= StockieExtraParser::VC_typo_to_CSS( $position_typo );
	$description_settings .= StockieExtraParser::VC_typo_to_CSS( $desription_typo );

	StockieExtraParser::VC_typo_custom_font( $name_typo );
	StockieExtraParser::VC_typo_custom_font( $position_typo );
	StockieExtraParser::VC_typo_custom_font( $desription_typo );

	$social_bar = ( $facebook_link || $twitter_link || $dribbble_link || $pinterest_link || $github_link || $instagram_link || $linkedin_link );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'team_member_inner__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'team_member_inner__view.php' );
	return ob_get_clean();
}