<?php

/**
* WPBakery Page Builder Stockie Tabs shortcode params
*/

vc_map( array(
	'name' => __( 'Tabs', 'stockie-extra' ),
	'description' => __( 'Tabs module', 'stockie-extra' ),
	'base' => 'stockie_tabs',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'is_container' => true,
	'show_settings_on_create' => true,
	'as_parent' => array(
		'only' => 'stockie_tabs_inner',
	),
	'js_view' => 'VcStockieBackendTtaTabsView',
	'custom_markup' => '
		<div class="vc_tta-container" data-vc-action="collapse">
			<div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
				<div class="vc_tta-tabs-container">'
					. '<ul class="vc_tta-tabs-list">'
					. '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
					. '</ul>
				</div>
				<div class="vc_tta-panels vc_clearfix {{container-class}}">
				  {{ content }}
				</div>
			</div>
		</div>
	',
	'default_content' => '
		[stockie_tabs_inner title="' . sprintf( '%s %d', __( 'Tab', 'stockie-extra' ), 1 ) . '"][/stockie_tabs_inner]
		[stockie_tabs_inner title="' . sprintf( '%s %d', __( 'Tab', 'stockie-extra' ), 2 ) . '"][/stockie_tabs_inner]
	',
	'admin_enqueue_js' => array(
		vc_asset_url( 'lib/vc/vc_tabs/vc-tabs.min.js' ),
	),
	'params' => array(
		// Styles
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Tabs layout', 'stockie-extra' ),
			'param_name' => 'tabs_type',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_058.svg',
					'key' => 'default',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_059.svg',
					'key' => 'filled',
					'title' => __( 'Filled', 'stockie-extra' ),
				)
			),
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Tabs direction', 'stockie-extra' ),
			'param_name' => 'tabs_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_059.svg',
					'key' => 'ontop',
					'title' => __( 'Horizontal', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_060.svg',
					'key' => 'onleft',
					'title' => __( 'Vertical', 'stockie-extra' ),
				)
			),
			'dependency' => array(
				'element' => 'tabs_type',
				'value' => 'filled'
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Tabs direction', 'stockie-extra' ),
			'param_name' => 'tabs_layout_2',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_058.svg',
					'key' => 'ontop',
					'title' => __( 'Horizontal', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_061.svg',
					'key' => 'onleft',
					'title' => __( 'Vertical', 'stockie-extra' ),
				)
			),
			'dependency' => array(
				'element' => 'tabs_type',
				'value' => 'default'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Tabs alignment', 'stockie-extra' ),
			'param_name' => 'tabs_alignment',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right'
			),
			'dependency' => array(
				'element' => 'tabs_layout_2',
				'value' => 'ontop'
			)
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_tabs_title',
			'value' => __( 'Tabs title', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'tabs_title_typo'
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background color', 'stockie-extra' ),
			'param_name' => 'bg_color',
			'dependency' => array(
				'element' => 'tabs_type',
				'value' => 'filled'
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Content color', 'stockie-extra' ),
			'param_name' => 'content_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Tab color', 'stockie-extra' ),
			'param_name' => 'tab_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Active tab color', 'stockie-extra' ),
			'param_name' => 'tab_active_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Tabs border color', 'stockie-extra' ),
			'param_name' => 'tabs_border_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Tabs line color', 'stockie-extra' ),
			'param_name' => 'tabs_line_color',
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Stockie_Tabs extends WPBakeryShortCode {
		static $filter_added = false;
		protected $controls_css_settings = 'out-tc vc_controls-content-widget';
		protected $controls_list = array( 'edit', 'clone', 'delete' );

		public function __construct( $settings ) {
			parent::__construct( $settings );
			if ( ! self::$filter_added ) {
				$this->addFilter( 'vc_inline_template_content', 'setCustomTabId' );
				self::$filter_added = true;
			}
		}

		public function getTabTemplate() {
			return '<div class="wpb_template">' . do_shortcode( '[vc_tab title="Tab" tab_id=""][/vc_tab]' ) . '</div>';
		}

		public function setCustomTabId( $content ) {
			return preg_replace( '/tab\_id\=\"([^\"]+)\"/', 'tab_id="$1-' . time() . '"', $content );
		}
	}
}
