<?php 

/**
* WPBakery Page Builder Stockie Split Screen page shortcode
*/

add_shortcode( 'stockie_split_screen', 'stockie_split_screen_func' );

function stockie_split_screen_func( $atts, $content = '' ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$bg_color = isset( $bg_color ) ? StockieExtraFilter::string( $bg_color ) : false;
	$bg_image = isset( $bg_image ) ? StockieExtraFilter::string( $bg_image ) : false;
	$bg_size = isset( $bg_size ) ? StockieExtraFilter::string( $bg_size, 'string', 'cover' ) : 'cover';
	$side_paddings = isset( $side_paddings ) ? StockieExtraFilter::string( $side_paddings ) : '7%';
	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	// Style
	$split_screen_uniqid = uniqid( 'stockie-custom-' );

	$bg_css = '';
	if ( $bg_color ) {
		$bg_css .= 'background-color: ' . $bg_color . ';';
	}
	if ( $bg_image ) {
		$bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
		if ( is_array( $bg_image ) ) {
			$bg_image = $bg_image[0];
		}
		$bg_css .= 'background-image: url(\'' . $bg_image . '\');';
		switch ( $bg_size ) {
			case 'contain':
				$bg_css .= 'background-size: contain;';
				break;
			case 'no-repeat':
				$bg_css .= 'background-repeat: no-repeat;';
				break;
			case 'repeat':
				$bg_css .= 'background-repeat: repeat;';
				break;
			case 'cover':
			default:
				$bg_css .= 'background-size: cover;';
				break;
		}
	}

	$side_paddings_css = ( $side_paddings ) ? 'padding: 0 ' . $side_paddings . ';' : '';

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'split_screen__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'split_screen__view.php' );
	return ob_get_clean();
}