<?php

/**
* WPBakery Page Builder Stockie Social Networks shortcode params
*/

vc_map( array(
	'name' => __( 'Social Networks', 'stockie-extra' ),
	'description' => __( 'Social sharing buttons block', 'stockie-extra' ),
	'base' => 'stockie_social_networks',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Social networks layout', 'stockie-extra' ),
			'param_name' => 'icon_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_052.svg',
					'key' => 'outline',
					'title' => __( 'Outline', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_053.svg',
					'key' => 'fill',
					'title' => __( 'Fill', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_054.svg',
					'key' => 'flat',
					'title' => __( 'Flat', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_055.svg',
					'key' => 'inline',
					'title' => __( 'Inline', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_056.svg',
					'key' => 'text',
					'title' => __( 'Text', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_057.svg',
					'key' => 'boxed',
					'title' => __( 'Boxed', 'stockie-extra' ),
				),
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Social networks alignment', 'stockie-extra' ),
			'param_name' => 'alignment',
			'std' => 'center',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'dependency' => array(
				'element' => 'icon_layout',
				'value' => array(
					'outline',
					'fill',
					'flat',
					'inline',
					'text'
				),
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Use small shapes', 'stockie-extra' ),
			'param_name' => 'small_shapes',
			'std' => '0',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'icon_layout',
				'value' => array(
					'outline',
					'fill',
					'flat',
					'inline',
					'text'
				),
			),
		),

		// Links
		array(
			'type' => 'dropdown',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => __( 'Type links', 'stockie-extra' ),
			'param_name' => 'type_links',
			'value' => array(
				__( 'Share', 'stockie-extra' ) => 'share',
				__( 'Custom', 'stockie-extra' ) => 'custom',
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<em class="stockie_is ion-social-facebook"></em> ' . __( 'Facebook', 'stockie-extra' ),
			'param_name' => 'facebook',
			'value' => array(
				__( 'Add', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'share',
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<em class="stockie_is ion-social-twitter"></em> ' . __( 'Twitter', 'stockie-extra' ),
			'param_name' => 'twitter',
			'value' => array(
				__( 'Add', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'share',
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<em class="stockie_is ion-social-linkedin-outline"></em> ' . __( 'LinkedIn', 'stockie-extra' ),
			'param_name' => 'linkedin',
			'value' => array(
				__( 'Add', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'share',
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<em class="stockie_is ion-social-pinterest-outline"></em> ' . __( 'Pinterest', 'stockie-extra' ),
			'param_name' => 'pinterest',
			'value' => array(
				__( 'Add', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'share',
			),
		),
		/* Custom */

		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-artstation"></i> ' . __( 'ArtStation', 'stockie-extra' ),
			'param_name' => 'artstation_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-behance"></i> ' . __( 'Behance', 'stockie-extra' ),
			'param_name' => 'behance_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-deviantart"></i> ' . __( 'DeviantArt', 'stockie-extra' ),
			'param_name' => 'deviantart_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
        array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-digg"></i> ' . __( 'Digg', 'stockie-extra' ),
			'param_name' => 'digg_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
        array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-discord"></i> ' . __( 'Discord', 'stockie-extra' ),
			'param_name' => 'discord_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-dribbble"></i> ' . __( 'Dribbble', 'stockie-extra' ),
			'param_name' => 'dribbble_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-facebook-f"></i> ' . __( 'Facebook', 'stockie-extra' ),
			'param_name' => 'facebook_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-flickr"></i> ' . __( 'Flickr', 'stockie-extra' ),
			'param_name' => 'flickr_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-github"></i> ' . __( 'GitHub', 'stockie-extra' ),
			'param_name' => 'github_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-houzz"></i> ' . __( 'Houzz', 'stockie-extra' ),
			'param_name' => 'houzz_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-instagram"></i> ' . __( 'Instagram', 'stockie-extra' ),
			'param_name' => 'instagram_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-kaggle"></i> ' . __( 'Kaggle', 'stockie-extra' ),
			'param_name' => 'kaggle_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-linkedin"></i> ' . __( 'LinkedIn', 'stockie-extra' ),
			'param_name' => 'linkedin_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-medium-m"></i> ' . __( 'Medium', 'stockie-extra' ),
			'param_name' => 'medium_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-mixer"></i> ' . __( 'Mixer', 'stockie-extra' ),
			'param_name' => 'mixer_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-pinterest"></i> ' . __( 'Pinterest', 'stockie-extra' ),
			'param_name' => 'pinterest_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-product-hunt"></i> ' . __( 'Product Hunt', 'stockie-extra' ),
			'param_name' => 'producthunt_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-quora"></i> ' . __( 'Quora', 'stockie-extra' ),
			'param_name' => 'quora_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-reddit"></i> ' . __( 'Reddit', 'stockie-extra' ),
			'param_name' => 'reddit_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-snapchat"></i> ' . __( 'Snapchat', 'stockie-extra' ),
			'param_name' => 'snapchat_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-soundcloud"></i> ' . __( 'SoundCloud', 'stockie-extra' ),
			'param_name' => 'soundcloud_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-spotify"></i> ' . __( 'Spotify', 'stockie-extra' ),
			'param_name' => 'spotify_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-teamspeak"></i> ' . __( 'TeamSpeak', 'stockie-extra' ),
			'param_name' => 'teamspeak_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-telegram"></i> ' . __( 'Telegram', 'stockie-extra' ),
			'param_name' => 'telegram_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-threads"></i> ' . __( 'Threads', 'stockie-extra' ),
			'param_name' => 'threads_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-tiktok"></i> ' . __( 'TikTok', 'stockie-extra' ),
			'param_name' => 'tiktok_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-tumblr"></i> ' . __( 'Tumblr', 'stockie-extra' ),
			'param_name' => 'tumblr_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-twitch"></i> ' . __( 'Twitch', 'stockie-extra' ),
			'param_name' => 'twitch_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-x-twitter"></i> ' . __( 'Twitter', 'stockie-extra' ),
			'param_name' => 'twitter_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-vimeo"></i> ' . __( 'Vimeo', 'stockie-extra' ),
			'param_name' => 'vimeo_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-vine"></i> ' . __( 'Vine', 'stockie-extra' ),
			'param_name' => 'vine_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-whatsapp"></i> ' . __( 'Whatsapp', 'stockie-extra' ),
			'param_name' => 'whatsapp_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-xing"></i> ' . __( 'Xing', 'stockie-extra' ),
			'param_name' => 'xing_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-youtube"></i> ' . __( 'YouTube', 'stockie-extra' ),
			'param_name' => 'youtube_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Links', 'stockie-extra' ),
			'heading' => '<i class="fa-brands fa-500px"></i> ' . __( '500px', 'stockie-extra' ),
			'param_name' => 'fivehundred_link_custom',
			'dependency' => array(
				'element' => 'type_links',
				'value' => 'custom',
			),
		),
		
		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Outline hover', 'stockie-extra' ),
			'param_name' => 'outline_hover',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'icon_layout',
				'value' => 'flat',
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Default colors', 'stockie-extra' ),
			'param_name' => 'default_colors',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Hover default colors', 'stockie-extra' ),
			'param_name' => 'hover_default_colors',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'default_colors',
				'value' => '0',
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Shape color', 'stockie-extra' ),
			'param_name' => 'color',
			'dependency' => array(
				'element' => 'default_colors',
				'value' => '0',
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon color', 'stockie-extra' ),
			'param_name' => 'icon_color',
			'dependency' => array(
				'element' => 'default_colors',
				'value' => '0',
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon hover color', 'stockie-extra' ),
			'param_name' => 'icon_hover_color',
			'dependency' => array(
				'element' => 'default_colors',
				'value' => '0',
			),
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );