<div data-stockie-portfolio-grid="true"
	id="<?php echo $recent_projects_uniqid; ?>"
	class="stockie-recent-projects-sc"
	<?php if ( $appearance_effect != 'none' ) { echo ' data-aos="' . $appearance_effect . '"'; } ?>
	<?php if ( $appearance_duration ) { echo ' data-aos-duration="' . intval( $appearance_duration ) . '"'; } ?>>

	<?php if ( $show_projects_filter ) : ?>
		<?php
			if ( is_array( $projects_category ) ) {
				$cat_ids = get_terms( array( 'taxonomy' => 'stockie_portfolio_category', 'include' => $projects_category ) );
			} else {
				$cat_ids = get_terms( array( 'taxonomy' => 'stockie_portfolio_category' ) );
			}
			if ( is_array( $cat_ids ) && $cat_ids ) :
		?>
		<div class="portfolio-sorting<?php echo $filter_align_class; ?>" data-filter="portfolio">
			<ul class="unstyled font-titles">
				<li>
					<a class="active" href="#all" data-isotope-filter="*">
						<span class="name"><?php esc_html_e( 'All', 'stockie-extra' ); ?></span>
						<span class="num"></span>
					</a>
				</li>
				<?php foreach ( $cat_ids as $cat_obj ) : ?>
					<li>
						<a href="#<?php echo $cat_obj->slug; ?>" data-isotope-filter=".stockie-filter-project-<?php echo hash( 'md4', $cat_obj->slug, false ); ?>">
							<span class="name"><?php echo $cat_obj->name; ?></span>
							<span class="num"></span>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		<?php endif; ?>
	<?php endif; ?>

	<?php
		$items_per_page = intval( $pagination_items_per_page );
	?>

	<div class="vc_row <?php echo $css_class; ?> portfolio-grid" data-isotope-grid="true" data-lazy-container="projects">

		<?php
			$_post_start = 0;
			$_post_end = count( $projects_data );
		?>

		<?php for ( $_post_i = $_post_start; $_post_i < $_post_end; $_post_i++ ) : ?>
		<?php
			$_project_object = $projects_data[$_post_i];
			$stockie_project = StockieExtraParser::project_object( $_project_object );
			$stockie_project['metro_style'] = $metro_style;
			StockieHelper::set_storage_item_data( $stockie_project );



			$col_class = $column_class;
			if ( $stockie_project['grid_style'] == '2col' ) {
				$col_class = $column_double_class;
			}

			// Animation calculating
			$_anim_attrs = '';
			if ( in_array( $animation_type, array( 'sync', 'async' ) ) ) {
				$_anim_attrs .= ' data-aos-once="true"';
				$_anim_attrs .= ' data-aos="' . $animation_effect . '"';
				if ( $animation_type == 'async' ) {
					$_columns_in_row = (int) substr( $columns_in_row, 0, 1 );
					if ( $columns_in_row <= 0 ) { $columns_in_row = 1; }
					$_delay = ( 400 / $_columns_in_row ) * ( $_post_i % $_columns_in_row );
					$_delay = (int) $_delay - ( $_delay % 50 );
					$_anim_attrs .= ' data-aos-delay="' . $_delay . '"';
				}
			}

			echo '<div class="portfolio-item-wrap masonry-block' . (( $stockie_project['grid_style'] != '2col' ) ? ' grid-item' : '') . $col_class . ( ( $projects_solid ) ? ' post-offset' : '' ) . ' stockie-project-item ' . $stockie_project['categories_group'] . '" data-lazy-item="">';

			if ( $_anim_attrs ) {
				echo '<div' . $_anim_attrs . '>';
			}

			switch ( $card_layout ) {
				case 'grid_1_hover_1':
					include( locate_template( 'parts/portfolio-cards/grid_1_hover_1.php' ) );
					break;
				case 'grid_1_hover_2':
					include( locate_template( 'parts/portfolio-cards/grid_1_hover_2.php' ) );
					break;
				case 'grid_2_hover_1':
					include( locate_template( 'parts/portfolio-cards/grid_2_hover_1.php' ) );
					break;
				case 'grid_2_hover_2':
					include( locate_template( 'parts/portfolio-cards/grid_2_hover_2.php' ) );
					break;
				default:
					include( locate_template( 'parts/portfolio-cards/grid_1_hover_1.php' ) );
					break;
			}

			if ( $_anim_attrs ) {
				echo '</div>';
			}

		?>
			<div class="clear"></div>
		</div>
	<?php endfor; ?>
	</div>

	<?php
		if ( $use_pagination ) {

			$large_number = 10000000;
			$paginator_pattern = str_replace( $large_number, '{{page}}', get_pagenum_link( $large_number ) );
 
			if ( $pagination_type == 'simple' ) {

				StockieLayout::the_paginator_layout( $paged, $query->max_num_pages, $pagination_position );

			} else if ( $pagination_type == 'lazy_scroll' ) {

				echo '<div class="lazy-load loading font-titles text-' . $pagination_position . '" data-lazy-load="scroll" data-lazy-pages-count="' . esc_attr( $query->max_num_pages ) . '" data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" data-lazy-load-scope="projects">';
				echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie-extra' ) . '</span>';
				echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
				echo '</div>';

			}  else if ( $pagination_type == 'lazy_button' ) {

				echo '<div class="lazy-load load-more font-titles text-' . $pagination_position . '" data-lazy-load="click" data-lazy-pages-count="' . esc_attr( $query->max_num_pages ) . '" data-lazy-load-url-pattern="' . esc_attr( $paginator_pattern ) . '" data-lazy-load-scope="projects">';
				echo '<span class="loadmore-text">' . esc_html__( 'Load More', 'stockie-extra' ) . '</span>';
				echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie-extra' ) . '</span>';
				echo '<span class="ion btn-round"><i class="ion ion-android-sync"></i></span>';
				echo '</div>';

			}
		}
	?>
</div>