<?php

/**
* WPBakery Page Builder Stockie Recent Projects shortcode params
*/

vc_map( array(
	'name' => __( 'Portfolio Projects', 'stockie-extra' ),
	'description' => __( 'Block with portfolio projects', 'stockie-extra' ),
	'base' => 'stockie_recent_projects',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Portfolio layout', 'stockie-extra' ),
			'param_name' => 'card_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_098.svg',
					'key' => 'grid_2',
					'title' => __( 'Classic', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_006.svg',
					'key' => 'grid_1',
					'title' => __( 'Minimal', 'stockie-extra' )
				)
			)
		),
        array(
            'type' => 'stockie_choose_box',
            'group' => __( 'General', 'stockie-extra' ),
            'heading' => __( 'Hover effect', 'stockie-extra' ),
            'param_name' => 'portfolio_grid_1_hover',
            'value' => array(
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_101.svg',
                    'key' => 'hover_1',
                    'title' => __( 'Centered Details', 'stockie-extra' )
                ),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_102.svg',
                    'key' => 'hover_2',
                    'title' => __( 'Side Details', 'stockie-extra' )
                )
            ),
            'dependency' => array(
                'element' => 'card_layout',
                'value' => array(
                    'grid_1',
                )
            )
        ),
        array(
            'type' => 'stockie_choose_box',
            'group' => __( 'General', 'stockie-extra' ),
            'heading' => __( 'Hover effect', 'stockie-extra' ),
            'param_name' => 'portfolio_grid_2_hover',
            'value' => array(
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_099.svg',
                    'key' => 'hover_1',
                    'title' => __( 'Image Opacity', 'stockie-extra' )
                ),
                array(
                    'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_100.svg',
                    'key' => 'hover_2',
                    'title' => __( 'Overlay Button', 'stockie-extra' )
                )
            ),
            'dependency' => array(
                'element' => 'card_layout',
                'value' => array(
                    'grid_2',
                )
            )
        ),
		array(
			'type' => 'stockie_portfolio_types',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Portfolio categories', 'stockie-extra' ),
			'param_name' => 'projects_category',
			'value' => ''
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Metro style', 'stockie-extra' ),
			'param_name' => 'metro_style',
			'description' => '',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'card_layout',
				'value' => array(
					'grid_1',
				)
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Grid animation', 'stockie-extra' ),
			'param_name' => 'animation_type',
			'value' => array(
				__( 'Disable animation', 'stockie-extra' ) => 'default',
				__( 'Sync animation', 'stockie-extra' ) => 'sync',
				__( 'Async animation', 'stockie-extra' ) => 'async'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Grid animation effect', 'stockie-extra' ),
			'param_name' => 'animation_effect',
			'value' => array(
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),


		// Grid
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Grid', 'stockie-extra' ),
			'param_name' => 'row_items_title',
			'value' => __( 'Portfolio items per row', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_columns',
			'group' => __( 'Grid', 'stockie-extra' ),
			'param_name' => 'columns_in_row',
			'std' => '4-3-2-1'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Items gap', 'stockie-extra' ),
			'param_name' => 'grid_items_gap',
			'description' => __( 'CSS value.', 'stockie-extra' ),
			'value' => '15px'
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Show category filter', 'stockie-extra' ),
			'param_name' => 'show_projects_filter',
			'description' => '',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Category filter position', 'stockie-extra' ),
			'param_name' => 'filter_align',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'std' => 'center',
			'dependency' => array(
				'element' => 'show_projects_filter',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Enable pagination', 'stockie-extra' ),
			'param_name' => 'use_pagination',
			'description' => '',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Pagination type', 'stockie-extra' ),
			'param_name' => 'pagination_type',
			'value' => array(
				__( 'Simple', 'stockie-extra' ) => 'simple',
				__( 'Lazy load', 'stockie-extra' ) => 'lazy_scroll',
				__( 'Load more button', 'stockie-extra' ) => 'lazy_button',
			),
			'std' => 'simple',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),
        array(
			'type' => 'dropdown',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Pagination position', 'stockie-extra' ),
			'param_name' => 'pagination_position',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'std' => 'left',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Project items per page', 'stockie-extra' ),
			'param_name' => 'projects_in_block_pagination',
			'description' => __( 'Chose number of last projects in the block.', 'stockie-extra' ),
			'value' => '4',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Project items per page', 'stockie-extra' ),
			'param_name' => 'projects_in_block',
			'description' => __( 'Chose number of last projects in the block.', 'stockie-extra' ),
			'value' => '4',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'0'
				)
			)
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Overlay color', 'stockie-extra' ),
			'param_name' => 'overlay_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Category color', 'stockie-extra' ),
			'param_name' => 'category_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'More color', 'stockie-extra' ),
			'param_name' => 'more_color'
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
));