<?php 

/**
* WPBakery Page Builder Stockie Process shortcode
*/

add_shortcode( 'stockie_process', 'stockie_process_func' );

function stockie_process_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$number = isset( $number ) ? StockieExtraFilter::string( $number, 'string', '01.' ) : '01.';
	$title = isset( $title ) ? StockieExtraFilter::string( $title, 'string', '' ) : '';
	$description = isset( $description ) ? StockieExtraFilter::string( $description, 'textarea', '' ) : '';
	$number_typo = isset( $number_typo ) ? StockieExtraFilter::string( $number_typo ) : false;
	$title_typo = isset( $title_typo ) ? StockieExtraFilter::string( $title_typo ) : false;
	$description_typo = isset( $description_typo ) ? StockieExtraFilter::string( $description_typo ) : false;
	$boxed = isset( $boxed ) ? StockieExtraFilter::boolean( $boxed ) : false;
	$bg_color = isset( $bg_color ) ? StockieExtraFilter::string( $bg_color ) : false;
	$number_color = isset( $number_color ) ? StockieExtraFilter::string( $number_color ) : false;
	$title_color = isset( $title_color ) ? StockieExtraFilter::string( $title_color ) : false;
	$description_color = isset( $description_color ) ? StockieExtraFilter::string( $description_color ) : false;
	
	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );
	
	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	// Styling
	$process_uniqid = uniqid( 'stockie-custom-' );

	$process_settings = StockieExtraParser::VC_color_to_CSS( $bg_color, 'background-color:{{color}};' );

	$number_settings = StockieExtraParser::VC_color_to_CSS( $number_color, 'color:{{color}};' );
	$number_settings .= StockieExtraParser::VC_typo_to_CSS( $number_typo );

	$title_settings = StockieExtraParser::VC_color_to_CSS( $title_color, 'color:{{color}};' );
	$title_settings .= StockieExtraParser::VC_typo_to_CSS( $title_typo );

	$description_settings = StockieExtraParser::VC_color_to_CSS( $description_color, 'color:{{color}};' );
	$description_settings .= StockieExtraParser::VC_typo_to_CSS( $description_typo );

	$process_settings_class = '';
	if ( $boxed ) {
		$process_settings_class .= ' boxed';
	}

	StockieExtraParser::VC_typo_custom_font( $title_typo );
	StockieExtraParser::VC_typo_custom_font( $description_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'process__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'process__view.php' );
	return ob_get_clean();
}