<?php

/**
* WPBakery Page Builder Stockie Pricing Table shortcode params
*/

vc_map( array(
	'name' => __( 'Pricing Table', 'stockie-extra' ),
	'description' => __( 'Simple pricing table block', 'stockie-extra' ),
	'base' => 'stockie_pricing_table',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'js_view' => 'VcStockiePricingTableView',
	'custom_markup' => '{{title}}<div class="vc_stockie_pricing_table-container">
			<div class="title">%%title%%</div>
			<div class="subtitle"></div>
			<div class="divider"></div>
			<div class="price"><span></span>%%price%%</div>
			<div class="divider"></div>
			<div class="item"></div>
			<div class="divider"></div>
			<div class="item"></div>
			<div class="divider"></div>
			<div class="item"></div>
			<div class="divider"></div>
			<div class="item"></div>
			<div class="divider"></div>
			<div class="read_more"></div>
		</div>',
	'params' => array(
		// General
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Headline', 'stockie-extra' ),
			'param_name' => 'title',
			'value' => '',
			'description' => __( 'You can specify the name of the tariff plan like <b>Basic</b> and <b>Business</b> or your product name.', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Subtitle', 'stockie-extra' ),
			'param_name' => 'subtitle',
			'value' => '',
			'description' => ''
		),
		array(
			'type' => 'textarea',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Description', 'stockie-extra' ),
			'param_name' => 'description',
			'value' => '',
			'description' => __( 'Short description.', 'stockie-extra' ),
		),

		// Price
		array(
			'type' => 'textfield',
			'group' => __( 'Price', 'stockie-extra' ),
			'heading' => __( 'Price', 'stockie-extra' ),
			'param_name' => 'price',
			'value' => '',
			'description' => __( 'Number or specific phrases like <b>Free</b>, <b>Personal price</b> and <b>Beta testers only</b>.', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Price', 'stockie-extra' ),
			'heading' => __( 'Currency', 'stockie-extra' ),
			'param_name' => 'price_currency',
			'value' => '',
			'description' => __( '<b>&#36;</b>, <b>&euro;</b>, <b>&pound;</b>, <b>&yen;</b>, USD, EUR, anything.', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Price', 'stockie-extra' ),
			'heading' => __( 'Caption', 'stockie-extra' ),
			'param_name' => 'price_caption',
			'value' => '',
			'description' => __( 'You can write that this amount per year or month. For ex. <b>per month</b> or <b>per year</b>', 'stockie-extra' ),
		),

		// Features
		array(
			'type' => 'param_group',
			'group' => __( 'Features', 'stockie-extra' ),
			'heading' => __( 'Features', 'stockie-extra' ),
			'param_name' => 'features_value',
			'value' => array(
				false
			),
			'params' => array(
				array(
					'type' => 'dropdown',
					'group' => __( 'Icon', 'stockie-extra' ),
					'heading' => __( 'Icon', 'stockie-extra' ),
					'param_name' => 'feature_icon',
					'value' => array(
						__( 'Without icon', 'stockie-extra' ) => 'without_icon',
						__( 'Enable icon', 'stockie-extra' ) => 'icon_plus',
						__( 'Disable icon', 'stockie-extra' ) => 'icon_minus'
					),
				),
				array(
					'type' => 'textfield',
					'heading' => __( 'Headline', 'stockie-extra' ),
					'param_name' => 'feature_title',
				),
			),					
		),
		
		// Button
		array(
			'type' => 'stockie_check',
			'group' => __( 'Button', 'stockie-extra' ),
			'heading' => __( 'Add button', 'stockie-extra' ),
			'param_name' => 'add_button',
			'value' => array(
				__( 'Yes, please', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'vc_link',
			'group' => __( 'Button', 'stockie-extra' ),
			'heading' => __( 'Button link', 'stockie-extra' ),
			'param_name' => 'button_link',
			'dependency' => array(
				'element' => 'add_button',
				'value' => array(
					'1'
				)
			),
			'description' => __( 'Fill title field to change the <strong>Get started</strong> inscription.', 'stockie-extra' ),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Headline', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_subtitle',
			'value' => __( 'Subtitle', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'subtitle_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_description',
			'value' => __( 'Description', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'description_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_price',
			'value' => __( 'Price', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'price_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_features_title',
			'value' => __( 'Features title', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'features_title_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_features_subtitle',
			'value' => __( 'Features subtitle', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'features_subtitle_typo',
		),

		// Style
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_content',
			'value' => __( 'Content', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background color', 'stockie-extra' ),
			'param_name' => 'bg_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Borders color', 'stockie-extra' ),
			'param_name' => 'borders_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Headline color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Subtitle color', 'stockie-extra' ),
			'param_name' => 'subtitle_color',
			'value' => 'brand'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Description color', 'stockie-extra' ),
			'param_name' => 'description_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_price',
			'value' => __( 'Price', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Price color', 'stockie-extra' ),
			'param_name' => 'price_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Price caption color', 'stockie-extra' ),
			'param_name' => 'price_caption_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Price caption background color', 'stockie-extra' ),
			'param_name' => 'price_caption_bg_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_features',
			'value' => __( 'Features', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Titles color', 'stockie-extra' ),
			'param_name' => 'features_titles_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icons color', 'stockie-extra' ),
			'param_name' => 'features_icons_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Disabled titles color', 'stockie-extra' ),
			'param_name' => 'features_disabled_titles_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Disabled icons color', 'stockie-extra' ),
			'param_name' => 'features_disabled_icons_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_button',
			'value' => __( 'Button', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'add_button',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'stockie_button',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'readmore_button',
			'value' => 'type=outline',
			'dependency' => array(
				'element' => 'add_button',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_other',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		
		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );