<?php

/**
* WPBakery Page Builder Stockie Pricing List shortcode params
*/

vc_map( array(
	'name' => __( 'Pricing List', 'stockie-extra' ),
	'description' => __( 'Pricing list module', 'stockie-extra' ),
	'base' => 'stockie_pricing_list',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Headline', 'stockie-extra' ),
			'param_name' => 'name'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Details', 'stockie-extra' ),
			'param_name' => 'indigriends'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Sale price', 'stockie-extra' ),
			'param_name' => 'sale_price'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Regular price', 'stockie-extra' ),
			'param_name' => 'regular_price'
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'New', 'stockie-extra' ),
			'param_name' => 'new',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_name',
			'value' => __( 'Headline', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'name_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_indigriends',
			'value' => __( 'Details', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'indigriends_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_sale_price',
			'value' => __( 'Sale price', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'sale_price_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_regular_price',
			'value' => __( 'Regular price', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'regular_price_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_mark',
			'value' => __( 'Mark', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'new',
				'value' => '1'
			)
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'mark_typo',
			'dependency' => array(
				'element' => 'new',
				'value' => '1'
			)
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Headline color', 'stockie-extra' ),
			'param_name' => 'name_color',
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Details color', 'stockie-extra' ),
			'param_name' => 'indigriends_color',
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Sale price color', 'stockie-extra' ),
			'param_name' => 'sale_price_color',
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Regular price color', 'stockie-extra' ),
			'param_name' => 'regular_price_color',
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Mark color', 'stockie-extra' ),
			'param_name' => 'mark_color',
			'dependency' => array(
				'element' => 'new',
				'value' => '1'
			)
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Mark background color', 'stockie-extra' ),
			'param_name' => 'mark_background_color',
			'dependency' => array(
				'element' => 'new',
				'value' => '1'
			)
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );