<?php

/**
* WPBakery Page Builder Stockie Parallax shortcode params
*/

vc_map( array(
	'name' => __( 'Parallax', 'stockie-extra' ),
	'description' => __( 'Parallax block', 'stockie-extra' ),
	'base' => 'stockie_parallax',
	'category' => __( 'Stockie', 'stockie-extra' ),
	"content_element" => true,
	"is_container" => true,
	"js_view" => 'VcColumnView',
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General

		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Parallax type', 'stockie-extra' ),
			'param_name' => 'parallax',
			'value' => array(
				__( 'Vertical', 'stockie-extra' ) => 'vertical',
				__( 'Horizontal', 'stockie-extra' ) => 'horizontal'
			),
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Image', 'stockie-extra' ),
			'param_name' => 'image',
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Background size', 'stockie-extra' ),
			'param_name' => 'size',
			'value' => array(
				__( 'Auto', 'stockie-extra' ) => '',
				__( 'Contain', 'stockie-extra' ) => 'contain',
				__( 'Cover', 'stockie-extra' )   => 'cover',
				__( 'auto 100%', 'stockie-extra' )  => 'auto 100%',
				__( '100% auto', 'stockie-extra' )  => '100% auto',
				__( '100% 100%', 'stockie-extra' )  => '100% 100%',
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Parallax speed', 'stockie-extra' ),
			'param_name' => 'parallax_speed',
			'description' => __( 'Parallax speed (default 1.0).', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Use overlay?', 'stockie-extra' ),
			'param_name' => 'use_overlay',
			'value' => array(
				__( 'Yes, sure', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Overlay color', 'stockie-extra' ),
			'param_name' => 'overlay_color',
			'dependency' => array(
				'element' => 'use_overlay',
				'value' => '1'
			),
		),

		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),
	)
) );


if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Stockie_Parallax extends WPBakeryShortCodesContainer {
		
	}
}