<?php 

/**
* WPBakery Page Builder Stockie Paralax shortcode
*/

add_shortcode( 'stockie_parallax', 'stockie_parallax_func' );

function stockie_parallax_func( $atts, $content = '' ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$image = isset( $image ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $image ) ), 'attr' ) : false;
	$size = isset( $size ) ? StockieExtraFilter::string( $size, 'string', '' ) : '';
	$parallax = isset( $parallax ) ? StockieExtraFilter::string( $parallax, 'string', 'vertical' ) : 'vertical';
	$parallax_speed = isset( $parallax_speed ) ? StockieExtraFilter::string( $parallax_speed, 'attr', '1.0' )  : '1.0';
	$use_overlay = isset( $use_overlay ) ? StockieExtraFilter::boolean( $use_overlay ) : false;
	$overlay_color = isset( $overlay_color ) ? StockieExtraFilter::string( $overlay_color ) : false;
	$css_class = isset( $css_class ) ? ( ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) )  : '';

	// Styling
	$parallax_uniqid = uniqid( 'stockie-custom-' );

	$parallax_css = '';
	$parallax_css .= ( $image ) ? 'background-image:url(\'' . esc_url( $image ) . '\');' : '';
	$parallax_css .= ( $size ) ? 'background-size:' . esc_attr( $size ) . ';' : '';

	$overlay_css = '';
	if ( $use_overlay && $overlay_color ) {
		$overlay_css .= 'background-color:' . $overlay_color . ';';
	}

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'parallax__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'parallax__view.php' );
	return ob_get_clean();
}