<?php

/**
* WPBakery Page Builder Stockie Message module shortcode params
*/

vc_map( array(
	'name' => __( 'Message Module', 'stockie-extra' ),
	'description' => __( 'Messages and notifications module', 'stockie-extra' ),
	'base' => 'stockie_message_module',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Message type', 'stockie-extra' ),
			'param_name' => 'layout',
			'value' => array(
				__( 'Default', 'stockie-extra' ) => 'default',
				__( 'Warning', 'stockie-extra' ) => 'warning',
				__( 'Primary', 'stockie-extra' ) => 'primary',
				__( 'Success', 'stockie-extra' ) => 'success',
				__( 'Danger', 'stockie-extra' ) => 'danger'
			),
			'description' => __( 'Choose message module appearance type.', 'stockie-extra' ),
		),
		array(
			'type' => 'textarea_raw_html',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Text', 'stockie-extra' ),
			'param_name' => 'text',
			'description' => __( 'Enter message text (HTML allowed).', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Full width', 'stockie-extra' ),
			'param_name' => 'full_width',
			'description' => __( 'If checked message box will be 100% width.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'std' => '1'
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Hide close button?', 'stockie-extra' ),
			'param_name' => 'without_close_button',
			'description' => __( 'If checked close button will be hidden.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Use block as link?', 'stockie-extra' ),
			'description' => __( 'If checked wrap message box in link tag.', 'stockie-extra' ),
			'param_name' => 'use_link',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'vc_link',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Link', 'stockie-extra' ),
			'param_name' => 'link',
			'dependency' => array(
				'element' => 'use_link',
				'value' => '1'
			)
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_text',
			'value' => __( 'Text typography', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'text_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_link',
			'value' => __( 'Link', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'use_link',
				'value' => '1'
			)
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'link_typo',
			'dependency' => array(
				'element' => 'use_link',
				'value' => '1'
			)
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background color', 'stockie-extra' ),
			'param_name' => 'bg_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Text color', 'stockie-extra' ),
			'param_name' => 'text_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Link color', 'stockie-extra' ),
			'param_name' => 'link_color',
			'dependency' => array(
				'element' => 'use_link',
				'value' => '1'
			)
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );