<?php

/**
* WPBakery Page Builder Stockie Icon Box shortcode params
*/

vc_map( array(
	'name' => __( 'Icon Box', 'stockie-extra' ),
	'description' => __( 'Stockie eye catching icons', 'stockie-extra' ),
	'base' => 'stockie_icon_box',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'js_view' => 'VcStockieIconBoxView',
	'custom_markup' => '{{title}}<div class="vc_stockie_icon_box-container">
			<div class="icon">%%icon%%</div>
			<div class="title">%%title%%</div>
			<div class="subtitle"></div>
			<div class="divider"></div>
			<div class="lines"><div class="line"></div><div class="line"></div><div class="line"></div></div>
			<div class="read_more"></div>
		</div>',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Icon box layout', 'stockie-extra' ),
			'param_name' => 'box_type_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_012.svg',
					'key' => 'top_icon',
					'title' => __( 'Top Icon', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_015.svg',
					'key' => 'left_icon',
					'title' => __( 'Left Icon', 'stockie-extra' ),
				),
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Icon box alignment', 'stockie-extra' ),
			'param_name' => 'box_alignment',
			'dependency' => array(
				'element' => 'box_type_layout',
				'value' => array(
					'top_icon'
				)
			),
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_012.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_013.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_014.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Box layout', 'stockie-extra' ),
			'param_name' => 'content_full',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_015.svg',
					'key' => 'none',
					'title' => __( 'Float content', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_016.svg',
					'key' => 'full',
					'title' => __( 'Fullsize content', 'stockie-extra' ),
				)
			),
			'dependency' => array(
				'element' => 'box_type_layout',
				'value' => array(
					'left_icon',
					'right_icon'
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Title', 'stockie-extra' ),
			'param_name' => 'title',
			'description' => __( 'Main title for block.', 'stockie-extra' ),
		),
		array(
			'type' => 'textarea',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Description', 'stockie-extra' ),
			'param_name' => 'description',
			'description' => __( 'Description content.', 'stockie-extra' ),
		),

		// Icon
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon layout', 'stockie-extra' ),
			'param_name' => 'icon_type_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_017.svg',
					'key' => 'default',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_018.svg',
					'key' => 'border',
					'title' => __( 'Border', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_019.svg',
					'key' => 'fill_and_border',
					'title' => __( 'Fill and Border', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_020.svg',
					'key' => 'only_fill',
					'title' => __( 'Only Fill', 'stockie-extra' ),
				),
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon type', 'stockie-extra' ),
			'param_name' => 'icon_type',
			'value' => array(
				__( 'Font icon', 'stockie-extra' ) => 'font_icon',
				__( 'Custom image', 'stockie-extra' ) => 'user_image'
			),
		),
		array(
			'type' => 'stockie_icon_picker',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon', 'stockie-extra' ),
			'param_name' => 'icon_as_icon',
			'settings' => array(),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'font_icon'
				)
			)
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon image', 'stockie-extra' ),
			'param_name' => 'icon_as_image',
			'description' => __( 'Choose icon image.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'user_image'
				)
			)
		),

		// Link
		array(
			'type' => 'stockie_check',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Use link?', 'stockie-extra' ),
			'param_name' => 'use_link',
			'description' => __( 'Select if you want to block links to some page.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes, sure', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'vc_link',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Link URL', 'stockie-extra' ),
			'param_name' => 'link_url',
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
			'description' => __( 'Fill title field to change the <strong>Read more</strong> label.', 'stockie-extra' ),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_description',
			'value' => __( 'Description', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'description_typo',
		),

		// Style
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_content',
			'value' => __( 'Content', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Description color', 'stockie-extra' ),
			'param_name' => 'description_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_icon',
			'value' => __( 'Icon', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Fill color', 'stockie-extra' ),
			'param_name' => 'fill_color',
			'dependency' => array(
				'element' => 'icon_type_layout',
				'value' => array(
					'fill_and_border',
					'only_fill'
				)
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Border color', 'stockie-extra' ),
			'param_name' => 'border_color',
			'value' => 'brand',
			'dependency' => array(
				'element' => 'icon_type_layout',
				'value' => array(
					'fill_and_border',
					'border',
					'double'
				)
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon color', 'stockie-extra' ),
			'param_name' => 'icon_color',
			'value' => 'brand',
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'font_icon'
				)
			)
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_readmore',
			'value' => __( 'Readmore button', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'stockie_button',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'readmore_button',
			'color_brand' => true,
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );