<?php 

/**
* WPBakery Page Builder Stockie Icon box shortcode
*/

add_shortcode( 'stockie_icon_box', 'stockie_icon_box_func' );

function stockie_icon_box_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$box_type_layout = ( isset( $box_type_layout ) ) ? StockieExtraFilter::string( $box_type_layout, 'string', 'top_icon' ) : 'top_icon';
	$box_alignment = ( isset( $box_alignment ) ) ? StockieExtraFilter::string( $box_alignment, 'string', 'center' ) : 'center';
	$title = ( isset( $title ) ) ? StockieExtraFilter::string( $title, 'string', '' ) : '';
	$description = isset( $description ) ? StockieExtraFilter::string( $description, 'textarea', '' ) : '';
	$content_full = isset( $content_full ) ? StockieExtraFilter::string( $content_full, 'string', 'full') : 'full';
	
	$image = ( isset( $image ) ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $image ) ), 'attr' ) : false;
	$icon_type_layout = ( isset( $icon_type_layout ) ) ? StockieExtraFilter::string( $icon_type_layout, 'string', 'default' ) : 'default';
	$icon_type = ( isset( $icon_type ) ) ? StockieExtraFilter::string( $icon_type, 'string', 'font_icon' ) : 'font_icon';
	$icon_as_icon = ( isset( $icon_as_icon ) ) ? StockieExtraFilter::string( $icon_as_icon, 'attr', '' ) : '';
	$icon_as_image = ( isset( $icon_as_image ) ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $icon_as_image ) ), 'attr' ) : false;
	
	$use_link = ( isset( $use_link ) ) ? StockieExtraFilter::boolean( $use_link ) : false;
	
	$title_typo = ( isset( $title_typo ) ) ? StockieExtraFilter::string( $title_typo ) : false;
	$description_typo = ( isset( $description_typo ) ) ? StockieExtraFilter::string( $description_typo ) : false;
	
	$title_color = ( isset( $title_color ) ) ? StockieExtraFilter::string( $title_color ) : false;
	$description_color = ( isset( $description_color ) ) ? StockieExtraFilter::string( $description_color ) : false;
	$fill_color = ( isset( $fill_color ) ) ? StockieExtraFilter::string( $fill_color, 'brand' ) : 'brand';
	$border_color = ( isset( $border_color ) ) ? StockieExtraFilter::string( $border_color, 'brand' ) : 'brand';
	$icon_color = ( isset( $icon_color ) ) ? StockieExtraFilter::string( $icon_color, 'brand' ) : 'brand';
	$readmore_button = ( isset( $readmore_button ) ) ? StockieExtraFilter::string( $readmore_button ) : false;
	
	$link_url = StockieExtraParser::VC_link_params( isset( $link_url ) ? $link_url : '', array( 'caption' => __( 'Read More', 'stockie-extra' ) ) );
	
	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	$appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = ( isset( $css_class ) ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';


	// Styling
	$icon_box_uniqid = uniqid('stockie-custom-');

	if ( $icon_type == 'font_icon' && $icon_as_icon ) {
		$GLOBALS['stockie_icon_fonts'][] = $icon_as_icon;
	}

	$icon_box_class_main = 'icon-box';
	if ( $box_type_layout == 'left_icon' ) {
		$icon_box_class_main .= ' box-left';
	}
	if ( $box_type_layout == 'right_icon' ) {
		$icon_box_class_main .= ' box-right';
	}
	if( $box_type_layout == 'top_icon' ){
		$icon_box_class_main .= ' text-' . $box_alignment;
	}

	$icon_box_class_icon = '';
	switch ( $icon_type_layout ) {
		case 'border':
			$icon_box_class_icon = ' shape-border';
			break;
		case 'double':
			$icon_box_class_icon = ' shape-border-double';
			break;
		case 'fill_and_border':
			$icon_box_class_icon = ' shape-border shape-fill brand-bg-color';
			break;
		case 'only_fill':
			$icon_box_class_icon = ' shape-fill brand-bg-color';
			break;
	}

	$icon_css = '';
	$icon_css .= StockieExtraParser::VC_color_to_CSS( $icon_color, 'color:{{color}};' );

	if ( $icon_type_layout == 'fill_and_border' || $icon_type_layout == 'only_fill' ) {
		$icon_css .= StockieExtraParser::VC_color_to_CSS( $fill_color, 'background-color:{{color}};' );
	}
	if ( $icon_type_layout == 'fill_and_border' || $icon_type_layout == 'border' || $icon_type_layout == 'double' ) {
		$icon_css .= StockieExtraParser::VC_color_to_CSS( $border_color, 'border-color:{{color}};' );
	}

	
	$title_settings = StockieExtraParser::VC_color_to_CSS( $title_color, 'color:{{color}};' );
	$title_settings .= StockieExtraParser::VC_typo_to_CSS( $title_typo );

	$description_settings = StockieExtraParser::VC_color_to_CSS( $description_color, 'color:{{color}};' );
	$description_settings .= StockieExtraParser::VC_typo_to_CSS( $description_typo );
	
	$description_settings_class = '';
	if ( $content_full == 'full' ) {
		$description_settings_class .= ' content-full';
	}

	// Read More button
	$readmore_button = preg_replace( '/\&amp\;/', '&', $readmore_button );
	parse_str( $readmore_button, $button_settings );
	$button_css = StockieExtraParser::VC_button_to_css( $button_settings );

	StockieExtraParser::VC_typo_custom_font( $title_typo );
	StockieExtraParser::VC_typo_custom_font( $description_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'icon_box__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'icon_box__view.php' );
	return ob_get_clean();
}