<?php

/**
* WPBakery Page Builder Stockie Heading shortcode params
*/

vc_map( array(
	'name' => __( 'Heading', 'stockie-extra' ),
	'description' => __( 'Headnig block', 'stockie-extra' ),
	'base' => 'stockie_heading',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Heading layout', 'stockie-extra' ),
			'param_name' => 'subtitle_type_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_035.svg',
					'key' => 'bottom_subtitle',
					'title' => __( 'Bottom Subtitle', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_038.svg',
					'key' => 'top_subtitle',
					'title' => __( 'Top Subtitle', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_039.svg',
					'key' => 'without_subtitle',
					'title' => __( 'Without Subtitle', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Content alignment', 'stockie-extra' ),
			'param_name' => 'module_type_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_036.svg',
					'key' => 'on_middle',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_035.svg',
					'key' => 'on_left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_037.svg',
					'key' => 'on_right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'textarea_raw_html',
			'holder' => 'div class="stockie_heading_VC_gap"',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Title', 'stockie-extra' ),
			'param_name' => 'title',
			'description' => __( 'Enter block title (HTML allowed).', 'stockie-extra' ),
		),
		array(
			'type' => 'textarea_raw_html',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Subtitle', 'stockie-extra' ),
			'param_name' => 'subtitle',
			'description' => __( 'Enter block subtitle (HTML allowed).', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'subtitle_type_layout',
				'value' => array(
					'bottom_subtitle',
					'top_subtitle'
				)
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Subtitle offset', 'stockie-extra' ),
			'param_name' => 'subtitle_offset',
			'description' => __( 'CSS value.', 'stockie-extra' ),
			'std' => '12px',
			'dependency' => array(
				'element' => 'subtitle_type_layout',
				'value' => array(
					'bottom_subtitle',
					'top_subtitle'
				)
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Heading tag', 'stockie-extra' ),
			'param_name' => 'heading_type',
			'description' => __( 'Select the tag in which the title will be displayed.', 'stockie-extra' ),
			'value' => array(
				__( '<h1>', 'stockie-extra' ) => 'h1',
				__( '<h2>', 'stockie-extra' ) => 'h2',
				__( '<h3>', 'stockie-extra' ) => 'h3',
				__( '<h4>', 'stockie-extra' ) => 'h4',
				__( '<h5>', 'stockie-extra' ) => 'h5'
			),
			'std' => 'h3',
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Show divider?', 'stockie-extra' ),
			'description' => __( 'If checked then divider will be hidden.', 'stockie-extra' ),
			'param_name' => 'divider_visible',
			'value' => array(
				'Yes' => '0'
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Divider position', 'stockie-extra' ),
			'param_name' => 'divider_alignment',
			'value' => array(
				__( 'Before title', 'stockie-extra' ) => 'before_title',
				__( 'After title', 'stockie-extra' ) => 'after_title'
			),
			'std' => 'before_title',
			'dependency' => array(
				'element' => 'divider_visible',
				'value' => array(
					'1'
				)
			),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title typography', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_subtitle',
			'value' => __( 'Subtitle typography', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'subtitle_type_layout',
				'value' => array(
					'bottom_subtitle',
					'top_subtitle'
				)
			),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'subtitle_typo',
			'dependency' => array(
				'element' => 'subtitle_type_layout',
				'value' => array(
					'bottom_subtitle',
					'top_subtitle'
				)
			),
		),

		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Subtitle color', 'stockie-extra' ),
			'param_name' => 'subtitle_color',
			'dependency' => array(
				'element' => 'subtitle_type_layout',
				'value' => array(
					'bottom_subtitle',
					'top_subtitle'
				)
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Divider color', 'stockie-extra' ),
			'param_name' => 'divider_color',
			'dependency' => array(
				'element' => 'divider_visible',
				'value' => '1',
			),
		),
		 
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	),
));