<?php

/**
* WPBakery Page Builder Stockie Google Maps shortcode params
*/

vc_map( array(
	'name' => __( 'Google Maps', 'stockie-extra' ),
	'description' => __( 'Google Maps block', 'stockie-extra' ),
	'base' => 'stockie_google_maps',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'textarea',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Location coordinates', 'stockie-extra' ),
			'param_name' => 'marker_locations',
			'description' => __( 'Use several locations by placing coordinates in separate rows. (e.g. 55.6925218, 12.5199567)', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Map height', 'stockie-extra' ),
			'param_name' => 'map_height',
			'description' => __( 'Enter map height (in pixels or leave empty for responsive map).', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Enable zoom', 'stockie-extra' ),
			'param_name' => 'map_zoom_enable',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
        array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Enable Street View', 'stockie-extra' ),
			'param_name' => 'map_street_enable',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
        array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Enable Map Type', 'stockie-extra' ),
			'param_name' => 'map_type_enable',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
        array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Enable Fullscreen', 'stockie-extra' ),
			'param_name' => 'map_fullscreen_enable',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Map zoom', 'stockie-extra' ),
			'param_name' => 'map_zoom',
			'description' => __( 'Map zoom level (min - 1, max - 20, default - 14)', 'stockie-extra' ),
		),

		// Styles

		array(
			'type' => 'attach_image',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom marker', 'stockie-extra' ),
			'param_name' => 'map_marker',
			'description' => __( 'Choose marker image.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Map style', 'stockie-extra' ),
			'param_name' => 'map_style',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/default.png',
					'key' => 'default',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/light_dream.png',
					'key' => 'light_dream',
					'title' => __( 'Light Dream', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/shades_of_grey.png',
					'key' => 'shades_of_grey',
					'title' => __( 'Shades of Grey', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/paper.png',
					'key' => 'paper',
					'title' => __( 'Paper', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/light_monochrome.png',
					'key' => 'light_monochrome',
					'title' => __( 'Monochrome', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/lunar_landscape.png',
					'key' => 'lunar_landscape',
					'title' => __( 'Lunar', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/routexl.png',
					'key' => 'routexl',
					'title' => __( 'Routexl', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/flat_pale.png',
					'key' => 'flat_pale',
					'title' => __( 'Flat Pale', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/maps/flat_design.png',
					'key' => 'flat_design',
					'title' => __( 'Flat Design', 'stockie-extra' ),
				)
			)
		),
	)
) );