<?php

/**
* WPBakery Page Builder Stockie Gallery shortcode view
*/

?>
<div class="stockie-gallery-sc <?php echo $gallery_class . $css_class; ?>"
	id="<?php echo esc_attr( $images_uniqid ); ?>"
	data-gallery="<?php echo esc_attr( $gallery_uniqid ); ?>"
	<?php if ( $appearance_effect != 'none' ) { echo ' data-aos="' . $appearance_effect . '"'; } ?> 
	<?php if ( $appearance_duration ) { echo ' data-aos-duration="' . intval( $appearance_duration ) . '"'; } ?>>

	<?php 

		$pagination_page = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		$items_per_page = intval( $pagination_items_per_page );
		
		$_image_start = 0;
		$_image_end = count( $gallery );

		if ( $use_pagination ) {
			$_image_start = $pagination_page * $items_per_page - $items_per_page;
			$_image_end = count( $gallery );

			if ( $_image_end > $_image_start + $items_per_page ) {
				$_image_end = $_image_start + $items_per_page;
			}
		}

	?>

	<div class="vc_row<?php if ( $masonry_grid ) { echo ' stockie-masonry'; } ?>" data-lazy-container="true">
	<?php for ( $_image_i = $_image_start; $_image_i < $_image_end; $_image_i++ ) : ?>
	<?php $image = $gallery[ $_image_i ]; ?>
	<div class="<?php echo $column_class; ?> masonry-block grid-item gallery-image" data-gallery-item="<?php echo $_image_i; ?>" data-lazy-item="true">
		<div class="grid-item-container">
			<?php if ( $metro_style ) : ?>
				<figure class="grid-item-image" data-stockie-bg-image="<?php echo $image['full']; ?>">
					<img class="gimg hidden-image" src="<?php echo ($image['full']) ? $image['full'] : '#'; ?>" alt="<?php echo ( $image['alt']) ?  $image['alt'] : 'Alt'; ?>">
				</figure>

			<?php else: ?>
				<img class="gimg hidden-image" src="<?php echo ($image['full']) ? $image['full'] : '#'; ?>" alt="<?php echo ($image['alt']) ?  $image['alt'] : 'Alt'; ?>">
			<?php endif; ?>
			<div class="grid-item-overlay overlay<?php echo $overlay_class; ?>">
				<div class="center-aligned">
					<div class="btn-round" tabindex="1">
						<i class="ion ion-android-add"></i>	
					</div>
					<div class="grid-item-headline font-titles">
						<?php if ( $show_title ) : ?>
							<?php echo $image['title']; ?>
						<?php else: ?>
							<a href="#" class="btn btn-link">
								<span><?php esc_html_e( 'View Fullscreen', 'stockie-extra' ); ?></span>
								<i class="ion-right ion ion-android-arrow-forward"></i>
							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<div class="gallery-description">
				<h3 class="title"><?php echo $image['title']; ?></h3>
				<p class="subtitle small">
					<?php echo $image['caption']; ?>
				</p>
			</div>
		</div>
	</div>
	<?php endfor; ?>
	</div>

	<?php 

		if ( $use_pagination ) {

			$pages_count = ceil( count( $gallery ) / $items_per_page );

			if ( $pagination_type == 'simple' ) {

				StockieLayout::the_paginator_layout( $pagination_page, $pages_count );

			} else if ( $pagination_type == 'lazy_scroll' ) {

				echo '<div class="lazy-load loading font-titles" data-lazy-load="scroll" data-lazy-pages-count="' . esc_attr( $pages_count ) . '">';
				echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie-extra' ) . '</span>';
				echo '<span class="icon ion-refresh"></span>';
				echo '</div>';

			}  else if ( $pagination_type == 'lazy_button' ) {

				echo '<div class="lazy-load load-more font-titles" data-lazy-load="click" data-lazy-pages-count="' . esc_attr( $pages_count ) . '">';
				echo '<span class="loadmore-text">' . esc_html__( 'Load More', 'stockie-extra' ) . '</span>';
				echo '<span class="loading-text">' . esc_html__( 'Loading', 'stockie-extra' ) . '</span>';
				echo '<span class="icon ion-refresh"></span>';
				echo '</div>';

			}
		}
	?>

</div>
<div class="stockie-gallery-opened-sc gallery-lightbox<?php echo $css_class; ?>" 
	id="<?php echo esc_attr( $gallery_uniqid ); ?>" 
	data-options='<?php echo $gallery_json; ?>'>
	<div class="expand btn-round round-animation circle-animation">
		<i class="ion ion-android-expand"></i>
	</div>
	<div class="close btn-round round-animation circle-animation" tabindex="0">
		<i class="ion ion-android-close"></i>
	</div>
</div>