<?php

/**
* WPBakery Page Builder Stockie Counter shortcode params
*/

vc_map( array(
	'name' => __( 'Counter', 'stockie-extra' ),
	'description' => __( 'Facts and numbers counter block', 'stockie-extra' ),
	'base' => 'stockie_counter',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Layout', 'stockie-extra' ),
			'param_name' => 'layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_034.svg',
					'key' => 'number',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_033.svg',
					'key' => 'number_with_icon',
					'title' => __( 'With icon', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Number', 'stockie-extra' ),
			'param_name' => 'count_number',
			'value' => '',
			'description' => __( 'The number of count', 'stockie-extra' ),
		),
		array(
			'type' => 'textarea',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Title', 'stockie-extra' ),
			'param_name' => 'title',
			'value' => '',
			'description' => __( 'Enter title text (HTML allowed).', 'stockie-extra' ),
		),

		// Icon
		array(
			'type' => 'dropdown',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon position', 'stockie-extra' ),
			'param_name' => 'icon_position',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Right', 'stockie-extra' ) => 'right',
				__( 'Top', 'stockie-extra' ) => 'top'
			),
			'dependency' => array(
				'element' => 'layout',
				'value' => 'number_with_icon'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon type', 'stockie-extra' ),
			'param_name' => 'icon_type',
			'value' => array(
				__( 'Font icon', 'stockie-extra' ) => 'font_icon',
				__( 'Custom image', 'stockie-extra' ) => 'user_image'
			),
			'dependency' => array(
				'element' => 'layout',
				'value' => array(
					'number_with_icon',
					'icon'
				)
			)
		),
		array(
			'type' => 'stockie_icon_picker',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon', 'stockie-extra' ),
			'param_name' => 'icon_as_icon',
			'settings' => array(),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'font_icon'
				)
			)
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon image', 'stockie-extra' ),
			'param_name' => 'icon_as_image',
			'description' => __( 'Choose icon image.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'user_image'
				)
			)
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_count',
			'value' => __( 'Number of count', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'count_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		
		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Number color', 'stockie-extra' ),
			'param_name' => 'count_color'
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon color', 'stockie-extra' ),
			'param_name' => 'icon_color',
			'dependency' => array(
				'element' => 'layout',
				'value' => 'number_with_icon'
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color'
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );