<?php 

/**
* WPBakery Page Builder Stockie Counter shortcode
*/

add_shortcode( 'stockie_counter', 'stockie_counter_func' );

function stockie_counter_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$layout = isset( $layout ) ? StockieExtraFilter::string( $layout, 'string', 'percent') : 'percent';

	$count_number = isset( $count_number ) ? StockieExtraFilter::string( str_replace( ' ', '', $count_number ), 'string', '0') : '0';
	$title = isset( $title ) ? StockieExtraFilter::string( $title, 'string', false) : false;

	$icon_position = isset( $icon_position ) ? StockieExtraFilter::string( $icon_position, 'string', 'left') : 'left';
	$icon_type = isset( $icon_type ) ? StockieExtraFilter::string( $icon_type, 'string', 'font_icon' ) : 'font_icon';
	$icon_as_icon = isset( $icon_as_icon ) ? StockieExtraFilter::string( $icon_as_icon, 'string', '' ) : '';
	$icon_as_image = isset( $icon_as_image ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $icon_as_image ) ), 'attr' ) : false;

	$title_typo = isset( $title_typo ) ? StockieExtraFilter::string( $title_typo ) : false;
	$count_typo = isset( $count_typo ) ? StockieExtraFilter::string( $count_typo ) : false;

	$count_color = isset( $count_color ) ? StockieExtraFilter::string( $count_color, 'string', false ) : false;
	$icon_color = isset( $icon_color ) ? StockieExtraFilter::string( $icon_color, 'string', false ) : false;
	$title_color = isset( $title_color ) ? StockieExtraFilter::string( $title_color, 'string', false ) : false;

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	$appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) : '';

	// Styling
	$counter_box_uniqid = uniqid( 'stockie-custom-' );
	
	if ( $icon_type == 'font_icon' && $icon_as_icon ) {
		$GLOBALS['stockie_icon_fonts'][] = $icon_as_icon;
	}

	$count_css = StockieExtraParser::VC_color_to_CSS( $count_color, 'color:{{color}};' );
	$icon_css = StockieExtraParser::VC_color_to_CSS( $icon_color, 'color:{{color}};' );
	$title_css = StockieExtraParser::VC_color_to_CSS( $title_color, 'color:{{color}};' );

	StockieExtraParser::VC_typo_custom_font( $title_typo );
	StockieExtraParser::VC_typo_custom_font( $count_typo );

	$title_css = $title_css . StockieExtraParser::VC_typo_to_CSS( $title_typo );
	$count_css = $count_css . StockieExtraParser::VC_typo_to_CSS( $count_typo );

	$title_css = $title_css ? $title_css : false;

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'counter__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'counter__view.php' );
	return ob_get_clean();
}