<?php 

/**
* WPBakery Page Builder Stockie Countdown shortcode
*/

add_shortcode( 'stockie_countdown', 'stockie_countdown_func' );

function stockie_countdown_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$layout = isset( $layout ) ? StockieExtraFilter::string( $layout, 'string', 'default') : 'default';
	$countdown_classic = isset( $countdown_classic ) ? StockieExtraFilter::boolean( $countdown_classic ) : false;
	// $rounded_shape = isset( $rounded_shape ) ? StockieExtraFilter::boolean( $rounded_shape ) : false;
	$countdown_date = isset( $countdown_date ) ? StockieExtraFilter::string( $countdown_date, 'string', '2019/1/1 0:0:0') : '2019/1/1 0:0:0';

	$numbers_typo = isset( $numbers_typo ) ? StockieExtraFilter::string( $numbers_typo ) : false;
	$titles_typo = isset( $titles_typo ) ? StockieExtraFilter::string( $titles_typo ) : false;

	$numbers_color = isset( $numbers_color ) ? StockieExtraFilter::string( $numbers_color, 'string', false ) : false;
	$titles_color = isset( $titles_color ) ? StockieExtraFilter::string( $titles_color, 'string', false ) : false;
	$box_color = isset( $box_color ) ? StockieExtraFilter::string( $box_color, 'string', false ) : false;
	$box_border_color = isset( $box_border_color ) ? StockieExtraFilter::string( $box_border_color, 'string', false ) : false;
	$divider_dots_color = isset( $divider_dots_color ) ? StockieExtraFilter::string( $divider_dots_color, 'string', false ) : false;

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) : '';

	// Styling
	$countdown_box_uniqid = uniqid( 'stockie-custom-' );

	StockieHelper::add_required_script( 'countdown-box' );

	$countdown_box_class = '';
	if ( $layout == 'boxed' ) {
		$countdown_box_class .= ' countdown-boxed';
	}
	if ( $countdown_classic ) {
		$countdown_box_class .= ' countdown-classic';
	}

	$box_bg_settings = StockieExtraParser::VC_color_to_CSS( $box_color, 'background-color:{{color}};' );
	$numbers_settings = StockieExtraParser::VC_color_to_CSS( $numbers_color, 'color:{{color}};' );
	$titles_settings = StockieExtraParser::VC_color_to_CSS( $titles_color, 'color:{{color}};' );
	$dividers_settings = StockieExtraParser::VC_color_to_CSS( $divider_dots_color, 'color:{{color}};' );

	StockieExtraParser::VC_typo_custom_font( $numbers_typo );
	StockieExtraParser::VC_typo_custom_font( $titles_typo );

	$numbers_settings .= StockieExtraParser::VC_typo_to_CSS( $numbers_typo );
	$titles_settings .= StockieExtraParser::VC_typo_to_CSS( $titles_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'countdown__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'countdown__view.php' );
	return ob_get_clean();
}