<?php

/**
* WPBakery Page Builder Stockie Clients logo shortcode params
*/

vc_map( array(
	'name' => __( 'Clients Logo', 'stockie-extra' ),
	'description' => __( 'Clients logo box', 'stockie-extra' ),
	'base' => 'stockie_clients_logo',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'js_view' => 'VcStockieClientsLogoView',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Clients logo layout', 'stockie-extra' ),
			'param_name' => 'layout_type',
			'std' => 'default',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_027.svg',
					'key' => 'default',
					'title' => __( 'Default', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_028.svg',
					'key' => 'overlay',
					'title' => __( 'Overlay', 'stockie-extra' )
				),
			)
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Clients logo image', 'stockie-extra' ),
			'param_name' => 'image_logo',
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Alignment', 'stockie-extra' ),
			'param_name' => 'alignment',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'em',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Link', 'stockie-extra' ),
			'param_name' => 'link',
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Open in new window?', 'stockie-extra' ),
			'description' => __( '', 'stockie-extra' ),
			'param_name' => 'in_new_tab',
			'value' => array(
				'Yes' => '0'
			),
		),
		array(
			'type' => 'textarea_raw_html',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Description', 'stockie-extra' ),
			'param_name' => 'description',
			'description' => __( 'Enter description text (HTML allowed).', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_description',
			'value' => __( 'Description', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'description_typo',
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),


		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_content',
			'value' => __( 'Color settings', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Overlay color', 'stockie-extra' ),
			'param_name' => 'overlay_color',
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Description color', 'stockie-extra' ),
			'param_name' => 'description_color',
			'dependency' => array(
				'element' => 'layout_type',
				'value' => array(
					'overlay'
				)
			),
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );
