<?php

/**
* WPBakery Page Builder Stockie Cliens logo box shortcode
*/

add_shortcode( 'stockie_clients_logo', 'stockie_clients_logo_func' );

function stockie_clients_logo_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$layout_type = ( isset( $layout_type ) ) ? StockieExtraFilter::string( $layout_type, 'string', 'default' ) : 'default';
	$link = ( isset( $link ) ) ? StockieExtraFilter::string( $link ) : false;
	$in_new_tab = ( isset( $in_new_tab ) ) ? StockieExtraFilter::string( $in_new_tab ) : false;

	$title = ( isset( $title ) ) ? StockieExtraFilter::string( $title ) : false;
	$description = isset( $description ) ? rawurldecode( base64_decode( $description ) ) : '';
	$description = StockieExtraFilter::string( $description, 'textarea', '' );
	$image_logo = ( isset( $image_logo ) ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $image_logo ) ), 'attr' ) : false;

	$description_typo = ( isset( $description_typo ) ) ? StockieExtraFilter::string( $description_typo ) : false;

	$overlay_color = ( isset( $overlay_color ) ) ? StockieExtraFilter::string( $overlay_color ) : false;
	$description_color = ( isset( $description_color ) ) ? StockieExtraFilter::string( $description_color ) : false;

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = ( isset( $css_class ) ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	if ( isset( $link_url ) ) {
		$link_url = StockieExtraParser::VC_link_params( $link_url, array( 'caption' => 'Read More' ) );
	} else {
		$link_url = StockieExtraParser::VC_link_params( '', array( 'caption' => 'Read More' ) );
	}

	// Styling
	$clients_logo_uniqid = uniqid('stockie-custom-');
	$clients_logo_class = '';

	if ( $layout_type == 'default' ) {
		$clients_logo_class .= ' default';
	}

	$description_settings = StockieExtraParser::VC_color_to_CSS( $description_color, 'color:{{color}};' );
	$overlay_settings = StockieExtraParser::VC_color_to_CSS( $overlay_color, 'background-color:{{color}};' );
	$alignment_settings = ( isset( $alignment ) ) ? StockieExtraFilter::string( $alignment ) : 'left';
	$alignment_settings = 'text-align: ' . $alignment_settings . ';';

	$css_class = $clients_logo_class . $css_class;
	$description_settings .= StockieExtraParser::VC_typo_to_CSS( $description_typo );

	StockieExtraParser::VC_typo_custom_font( $description_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'clients_logo__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'clients_logo__view.php' );
	return ob_get_clean();
}
