<?php

/**
* WPBakery Page Builder Stockie Carousel shortcode params
*/

vc_map( array(
	'name' => __( 'Carousel', 'stockie-extra' ),
	'description' => __( 'Carousel module', 'stockie-extra' ),
	'base' => 'stockie_carousel',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'is_container' => true,
	'show_settings_on_create' => true,
	'as_parent' => array(
		'only' => 'stockie_carousel_inner',
	),
	'js_view' => 'VcStockieBackendTtaSliderView',
	'custom_markup' => '
		<div class="vc_tta-container" data-vc-action="collapse">
			<div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
				<div class="vc_tta-tabs-container">'
					. '<ul class="vc_tta-tabs-list">'
					. '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
					. '</ul>
				</div>
				<div class="vc_tta-panels vc_clearfix {{container-class}}">
				  {{ content }}
				</div>
			</div>
		</div>
	',
	'default_content' => '
		[stockie_carousel_inner title="' . sprintf( '%s %d', __( 'Section', 'stockie-extra' ), 1 ) . '"][/stockie_carousel_inner]
		[stockie_carousel_inner title="' . sprintf( '%s %d', __( 'Section', 'stockie-extra' ), 2 ) . '"][/stockie_carousel_inner]
		[stockie_carousel_inner title="' . sprintf( '%s %d', __( 'Section', 'stockie-extra' ), 3 ) . '"][/stockie_carousel_inner]
	',
	'admin_enqueue_js' => array(
		vc_asset_url( 'lib/vc/vc_tabs/vc-tabs.min.js' ),
	),
	'params' => array(

		// General
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Offset items', 'stockie-extra' ),
			'param_name' => 'offset_items',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Offset size', 'stockie-extra' ),
			'param_name' => 'offset_size',
			'value' => '70%',
			'dependency' => array(
				'element' => 'offset_items',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Loop', 'stockie-extra' ),
			'param_name' => 'loop',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
			'description' => __( 'Infinity loop. Duplicate last and first items to get loop illusion.', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Number of visible items on desktop', 'stockie-extra' ),
			'param_name' => 'item_desktop',
			'description' => __( 'Default, 5 items.', 'stockie-extra' ),
			'value' => '5'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Number of visible items on tablet', 'stockie-extra' ),
			'param_name' => 'item_tablet',
			'description' => __( 'Default, 3 items.', 'stockie-extra' ),
			'value' => '3'
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Number of visible items on mobile', 'stockie-extra' ),
			'param_name' => 'item_mobile',
			'description' => __( 'Default, 1 items.', 'stockie-extra' ),
			'value' => '1'
		),

		// Pagination
		array(
			'type' => 'stockie_check',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Bullets', 'stockie-extra' ),
			'param_name' => 'pagination_show',
			'description' => __( 'Show bullets navigation.', 'stockie-extra' ),
			'std' => 'true',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Dots each', 'stockie-extra' ),
			'param_name' => 'dots_each',
			'description' => __( 'Show bullet each <strong>x</strong> item.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'pagination_show',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Buttons', 'stockie-extra' ),
			'param_name' => 'navigation_buttons',
			'std' => 'true',
			'description' => __( 'Show navigation buttons.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Buttons position', 'stockie-extra' ),
			'param_name' => 'position_nav_buttons',
			'value' => array(
				__( 'Default', 'stockie-extra' ) => 'default',
				__( 'Offset', 'stockie-extra' ) => 'offset',
				__( 'Inset', 'stockie-extra' ) => 'inset',
			),
			'dependency' => array(
				'element' => 'navigation_buttons',
				'value' => array(
					'1'
				)
			)
		),

		// Scroll
		array(
			'type' => 'textfield',
			'group' => __( 'Slide', 'stockie-extra' ),
			'heading' => __( 'Slide by', 'stockie-extra' ),
			'param_name' => 'slide_by',
			'description' => __( 'Navigation slide by x. `page` string can be set to slide by page.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Slide', 'stockie-extra' ),
			'heading' => __( 'Scroll per page', 'stockie-extra' ),
			'param_name' => 'scroll_per_page',
			'description' => __( 'Scroll per page not per item. This affect next/prev buttons and mouse/touch dragging.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Slide', 'stockie-extra' ),
			'heading' => __( 'Autoplay', 'stockie-extra' ),
			'param_name' => 'autoplay',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Slide', 'stockie-extra' ),
			'heading' => __( 'Autoplay time', 'stockie-extra' ),
			'param_name' => 'autoplay_time',
			'description' => __( 'Autoplay interval timeout in seconds.', 'stockie-extra' ),
			'value' => '5',
			'dependency' => array(
				'element' => 'autoplay',
				'value' => '1',
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Slide', 'stockie-extra' ),
			'heading' => __( 'Stop on hover', 'stockie-extra' ),
			'param_name' => 'stop_on_hover',
			'description' => __( 'Stop autoplay on mouse hover.', 'stockie-extra' ),
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '1'
			),
			'dependency' => array(
				'element' => 'autoplay',
				'value' => '1',
			)
		),

		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Navigation buttons background color', 'stockie-extra' ),
			'param_name' => 'nav_bg_color',
			'dependency' => array(
				'element' => 'navigation_buttons',
				'value' => '1',
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Navigation buttons color', 'stockie-extra' ),
			'param_name' => 'nav_color',
			'dependency' => array(
				'element' => 'navigation_buttons',
				'value' => '1',
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Dots color', 'stockie-extra' ),
			'param_name' => 'dots_color',
			'dependency' => array(
				'element' => 'pagination_show',
				'value' => '1',
			)
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Stockie_Carousel extends WPBakeryShortCode {
		static $filter_added = false;
		protected $controls_css_settings = 'out-tc vc_controls-content-widget';
		protected $controls_list = array( 'edit', 'clone', 'delete' );

		public function __construct( $settings ) {
			parent::__construct( $settings );
			if ( ! self::$filter_added ) {
				$this->addFilter( 'vc_inline_template_content', 'setCustomTabId' );
				self::$filter_added = true;
			}
		}

		public function getTabTemplate() {
			return '<div class="wpb_template">' . do_shortcode( '[vc_tab title="Tab" tab_id=""][/vc_tab]' ) . '</div>';
		}

		public function setCustomTabId( $content ) {
			return preg_replace( '/tab\_id\=\"([^\"]+)\"/', 'tab_id="$1-' . time() . '"', $content );
		}
	}
}
