<?php

/**
* WPBakery Page Builder Stockie Call To Action shortcode params
*/

vc_map( array(
	'name' => __( 'Call To Action', 'stockie-extra' ),
	'description' => __( 'Call to action block', 'stockie-extra' ),
	'base' => 'stockie_call_to_action',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(
		// General
		array(
			'type' => 'textarea_raw_html',
			'holder' => 'div class="stockie_heading_VC_gap"',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Title', 'stockie-extra' ),
			'param_name' => 'title',
			'description' => __( 'HTML allowed.', 'stockie-extra' ),
		),
		array(
			'type' => 'textarea_raw_html',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Subtitle', 'stockie-extra' ),
			'param_name' => 'subtitle',
			'description' => __( 'HTML allowed.', 'stockie-extra' ),
		),

		// Link
		array(
			'type' => 'vc_link',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Link', 'stockie-extra' ),
			'param_name' => 'link',
			'description' => __( 'Fill title field to change the \'Get started\' label.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Add icon?', 'stockie-extra' ),
			'param_name' => 'icon_use',
			'value' => array(
				__( 'Yes, sure', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Icon position', 'stockie-extra' ),
			'param_name' => 'icon_position',
			'std' => 'left',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'dependency' => array(
				'element' => 'icon_use',
				'value' => '1'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Icon type', 'stockie-extra' ),
			'param_name' => 'icon_type',
			'value' => array(
				__( 'Font icon', 'stockie-extra' ) => 'font_icon',
				__( 'Custom image', 'stockie-extra' ) => 'user_image'
			),
			'dependency' => array(
				'element' => 'icon_use',
				'value' => '1'
			)
		),
		array(
			'type' => 'stockie_icon_picker',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Icon', 'stockie-extra' ),
			'param_name' => 'icon_as_icon',
			'settings' => array(),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'font_icon'
				)
			)
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Icon image', 'stockie-extra' ),
			'param_name' => 'icon_as_image',
			'description' => __( 'Choose icon image.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'user_image'
				)
			)
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Title', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_subtitle',
			'value' => __( 'Subtitle', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'subtitle_typo'
		),

		// Style
		array(
			'type' => 'stockie_check',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Show without side paddings', 'stockie-extra' ),
			'param_name' => 'without_side_paddings',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background color', 'stockie-extra' ),
			'param_name' => 'bg_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Subtitle color', 'stockie-extra' ),
			'param_name' => 'subtitle_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_readmore',
			'value' => __( 'Readmore button', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_button',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'readmore_button',
			'button_full_disabled' => 'true'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_other',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		
		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	),
));