<?php 

/**
* WPBakery Page Builder Stockie Call To Action shortcode
*/

add_shortcode( 'stockie_call_to_action', 'stockie_call_to_action_func' );

function stockie_call_to_action_func( $atts ) {
	$title = $subtitle = $without_side_paddings = $icon_use = $icon_position = $icon_type = $icon_as_icon = 
	$icon_as_image = $title_typo = $subtitle_typo = $bg_color = $title_color = $subtitle_color = $readmore_button = 
	$link = $appearance_effect = $appearance_duration = $css_class = NULL;
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$title = rawurldecode( base64_decode( isset( $title ) ? $title : '' ) );
	$title = StockieExtraFilter::string( $title, 'string', '' );
	$subtitle = rawurldecode( base64_decode( isset( $subtitle ) ? $subtitle : '' ) );
	$subtitle = StockieExtraFilter::string( $subtitle, 'string', '' );
	$without_side_paddings = StockieExtraFilter::boolean( $without_side_paddings );

	$icon_use = StockieExtraFilter::boolean( $icon_use );
	$icon_position = StockieExtraFilter::string( $icon_position, 'string', 'left' );
	$icon_type = StockieExtraFilter::string( $icon_type, 'string', 'font_icon' );
	$icon_as_icon = StockieExtraFilter::string( $icon_as_icon, 'string', '' );
	$icon_as_image = StockieExtraFilter::string( $icon_as_image, 'string', '' );

	$title_typo = StockieExtraFilter::string( $title_typo );
	$subtitle_typo = StockieExtraFilter::string( $subtitle_typo );

	$bg_color = StockieExtraFilter::string( $bg_color );
	$title_color = StockieExtraFilter::string( $title_color );
	$subtitle_color = StockieExtraFilter::string( $subtitle_color );
	$readmore_button = StockieExtraFilter::string( $readmore_button );

	$link = StockieExtraParser::VC_link_params( ( $link ) ? $link : '', array( 'caption' => __( '', 'stockie-extra' ) ) );

	$appearance_effect = StockieExtraFilter::string( $appearance_effect, 'attr', 'none' );
	$appearance_duration = StockieExtraFilter::string( $appearance_duration, 'attr', false );
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = ( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) : '';

	// Styling
	$call_to_action_uniqid = uniqid( 'stockie-custom-' );

	if ( $icon_type == 'font_icon' && $icon_as_icon ) {
		$GLOBALS['stockie_icon_fonts'][] = $icon_as_icon;
	}

	$readmore_button = preg_replace( '/\&amp\;/', '&', $readmore_button );
	parse_str( $readmore_button, $button_settings );
	$button_css = StockieExtraParser::VC_button_to_css( $button_settings );

	$call_to_action_settings = StockieExtraParser::VC_color_to_CSS( $bg_color, 'background-color:{{color}};' );
	$title_settings = StockieExtraParser::VC_color_to_CSS( $title_color, 'color:{{color}};' );
	$subtitle_settings = StockieExtraParser::VC_color_to_CSS( $subtitle_color, 'color:{{color}};' );

	$title_settings .= StockieExtraParser::VC_typo_to_CSS( $title_typo );
	$subtitle_settings .= StockieExtraParser::VC_typo_to_CSS( $subtitle_typo );

	StockieExtraParser::VC_typo_custom_font( $title_typo );
	StockieExtraParser::VC_typo_custom_font( $subtitle_typo );

	if ( $without_side_paddings ) {
		$call_to_action_settings .= ' padding-left:0;padding-right:0;';
	}

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'call_to_action__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'call_to_action__view.php' );
	return ob_get_clean();
}