<?php 

/**
* WPBakery Page Builder Stockie Banner shortcode
*/

add_shortcode( 'stockie_banner', 'stockie_banner_func' );

function stockie_banner_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$block_type_layout = isset( $block_type_layout ) ? StockieExtraFilter::string( $block_type_layout, 'string', 'full' ) : 'full';
	$block_type_full_align = isset( $block_type_full_align ) ? StockieExtraFilter::string( $block_type_full_align, 'string', 'left' ) : 'left';
	$block_type_inner_align = isset( $block_type_inner_align ) ? StockieExtraFilter::string( $block_type_inner_align, 'string', 'top_left' ) : 'top_left';
	$block_type_subtitle = isset( $block_type_subtitle ) ? StockieExtraFilter::string( $block_type_subtitle, 'string', 'after' ) : 'after';
	$title = isset( $title ) ? StockieExtraFilter::string( $title ) : false;
	$description = isset( $description ) ? rawurldecode( base64_decode( $description ) ) : '';
	$description = StockieExtraFilter::string( $description, 'textarea', '' );
	$background_image = isset( $background_image ) ? StockieExtraFilter::string( wp_get_attachment_url( StockieExtraFilter::string( $background_image ) ), 'attr' ) : false;
	$use_link = isset( $use_link ) ? StockieExtraFilter::boolean( $use_link ) : true;

	$readmore_button = isset( $readmore_button ) ? StockieExtraFilter::string( $readmore_button ) : 'type=outline&size=small';

	$title_typo = isset( $title_typo ) ? StockieExtraFilter::string( $title_typo ) : false;
	$description_typo = isset( $description_typo ) ? StockieExtraFilter::string( $description_typo ) : false;
	$title_color = isset( $title_color ) ? StockieExtraFilter::string( $title_color ) : false;
	$subtitle_color = isset( $subtitle_color ) ? StockieExtraFilter::string( $subtitle_color ) : false;
	$description_color = isset( $description_color ) ? StockieExtraFilter::string( $description_color ) : false;
	$overlay_color = isset( $overlay_color ) ? StockieExtraFilter::string( $overlay_color ) : false;

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );
	
	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	$link_url = StockieExtraParser::VC_link_params( ( isset( $link_url ) ? $link_url : '' ), array( 'caption' => esc_html__( 'Read More', 'stockie-extra' ) ) );

	// Styling
	$banner_box_uniqid = uniqid( 'stockie-custom-' );

	$banner_box_class = 'banner-box';
	switch ( $block_type_layout ) {
		case 'boxed':
			$banner_box_class .= ' boxed';
			break;
		case 'inner':
			$banner_box_class .= ' inner';
			break;
		case 'inner_hover':
			$banner_box_class .= ' inner hover';
			break;
		case 'overlay_title':
			$banner_box_class .= ' overlay-title';
			break;
	}
	switch ( $block_type_full_align ) {
		case 'center':
			$banner_box_class .= ' text-center';
			break;
		case 'right':
			$banner_box_class .= ' text-right';
			break;
	}

	$title_css = StockieExtraParser::VC_typo_to_CSS( $title_typo );
	$title_css .= StockieExtraParser::VC_color_to_CSS( $title_color, 'color:{{color}};' );

	$description_css = StockieExtraParser::VC_typo_to_CSS( $description_typo );
	$description_css .= StockieExtraParser::VC_color_to_CSS( $description_color, 'color:{{color}};' );

	$overlay_css = ( $overlay_color ) ? 'background-color: ' . $overlay_color : '';

	$readmore_button = preg_replace( '/\&amp\;/', '&', $readmore_button );
	parse_str( $readmore_button, $button_settings );
	$button_css = StockieExtraParser::VC_button_to_css( $button_settings );

	StockieExtraParser::VC_typo_custom_font( $title_typo );
	StockieExtraParser::VC_typo_custom_font( $description_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'banner__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'banner__view.php' );
	return ob_get_clean();
}