<?php 

/**
* WPBakery Page Builder Stockie Accordion Inner shortcode
*/

add_shortcode( 'stockie_accordion_inner', 'stockie_accordion_inner_func' );

function stockie_accordion_inner_func( $atts, $content_html = '' ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$heading = isset( $heading ) ? StockieExtraFilter::string( $heading, 'string', '' ) : '';
	$with_icon = isset( $with_icon ) ? StockieExtraFilter::boolean( $with_icon ) : false;
	$icon_as_icon = isset( $icon_as_icon ) ? StockieExtraFilter::string( $icon_as_icon, 'attr' ) : false;

	$heading_typo = isset( $heading_typo ) ? StockieExtraFilter::string( $heading_typo ) : false;
	$content_typo = isset( $content_typo ) ? StockieExtraFilter::string( $content_typo ) : false;

	$heading_text_color = isset( $heading_text_color ) ? StockieExtraFilter::string( $heading_text_color ) : false;
	$content_color = isset( $content_color ) ? StockieExtraFilter::string( $content_color ) : false;
	$icon_color = isset( $icon_color ) ? StockieExtraFilter::string( $icon_color ) : false;
	$heading_fill_color = isset( $heading_fill_color ) ? StockieExtraFilter::string( $heading_fill_color ) : false;

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' )  : '';

	// Handling
	$content_html = wpautop( $content_html );

	// Styling
	$accordion_inner_uniqid = uniqid( 'stockie-custom-' );

	if ( $with_icon && $icon_as_icon ) {
		$GLOBALS['stockie_icon_fonts'][] = $icon_as_icon;
	}

	$heading_css = StockieExtraParser::VC_typo_to_CSS( $heading_typo ) . StockieExtraParser::VC_color_to_CSS( $heading_text_color, 'color:{{color}};' );
	$content_css = StockieExtraParser::VC_typo_to_CSS( $content_typo ) . StockieExtraParser::VC_color_to_CSS( $content_color, 'color:{{color}};' );
	$icon_css = StockieExtraParser::VC_color_to_CSS( $icon_color, 'color:{{color}};' );
	$head_fill_css = StockieExtraParser::VC_color_to_CSS( $heading_fill_color, 'background-color:{{color}};' );

	StockieExtraParser::VC_typo_custom_font( $heading_typo );
	StockieExtraParser::VC_typo_custom_font( $content_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'accordion_inner__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'accordion_inner__view.php' );
	return ob_get_clean();
}