(function ($) {
    'use strict';
    var fnMisc = {
        /**
         * Trim Function
         *
         * @param   string  text  string to trim
         *
         * @return  string
         */
        trim: function (text) {
            if (text) {
                return text.trim();
            }
            return text;
        }
    };
    // if whatsapp number not set
    if (!whatsAppAnyFormOptions.whatsAppNumber) {
        return false;
    }
    // get form selectors
    if (whatsAppAnyFormOptions.formSelector) {
        whatsAppAnyFormOptions.formSelector = ',' + whatsAppAnyFormOptions.formSelector;
    }
    // loop through the each WhatsApp any form
    $('.lw-wp-whatsapp-any-form' + whatsAppAnyFormOptions.formSelector).each(function (index, element) {
        var $element = $(element);
        if ($element.is('form')) {
            var $thisForm = $element;
        } else {
            var formInParent = $element.parents('form');
            if (formInParent.length) {
                var $thisForm = $($element.parents('form')[0]);
            } else {
                console.error('lw-whatsapp-any-form: Form not found');
                return false;
            }
        }
        $thisForm.on("submit", function (e) {
            // prevent default form behavior
            e.preventDefault();
            // text to send holder
            var textToSend = "",
                // textToSend += "```";
                // targeted form
                $form = $(e.target),
                // serialized array for the submitted form
                formData = $form.serializeArray(),
                // get form title for whatsapp message
                formTitle = fnMisc.trim($form.data('title'));
            // check if form is valid
            if (!$form.valid()) {
                return false;
            }

            if (whatsAppAnyFormOptions.includePageTitleInMessage) {
                textToSend += "*" + document.title + "*\n\n";
            }
            // if form title present prepend it
            if (formTitle) {
                textToSend += formTitle + "\n\n";
            }
            // go through the each item of the submitted form
            for (var formItem in formData) {
                if (Object.hasOwnProperty.call(formData, formItem)) {
                    // form value item
                    var element = formData[formItem],
                        // label for the value in message from
                        // data-label attribute
                        dataLabel = fnMisc.trim($(element).data('label'));
                    // If not present in the above attribute
                    // see check if there is any label for this input field
                    if (!dataLabel) {
                        var idOfInputElement = $form.find('[name="' + element.name + '"]').prop("id");
                        if (idOfInputElement) {
                            dataLabel = fnMisc.trim(
                                $form.find('label[for="' + idOfInputElement + '"]').text()
                            );
                        }
                    }
                    // see check if there is any placeholder set to use
                    if (!dataLabel) {
                        dataLabel = fnMisc.trim(
                            $form.find('[name="' + element.name + '"]').prop("placeholder")
                        );
                    }
                    // If not present in the above attribute
                    // see if the parent has the data-label attribute so we can use that
                    if (!dataLabel) {
                        dataLabel = fnMisc.trim(
                            $form.find('[name="' + element.name + '"]').parent().data('label')
                        );
                    }
                    // If immediate parent has label
                    if (!dataLabel) {
                        var parentLabel = $form.find('[name="' + element.name + '"]').parents('label');
                        if (parentLabel.length) {
                            dataLabel = fnMisc.trim(
                                $form.find(parentLabel[0]).text()
                            );
                        }
                    }
                    // if sibling has parent
                    if (!dataLabel) {
                        dataLabel = fnMisc.trim(
                            $form.find('[name="' + element.name + '"]').siblings('label').text()
                        );
                    }
                    // If still present in the all above items
                    // set the name of the field value as label
                    if (!dataLabel) {
                        dataLabel = element.name;
                    }
                    if (whatsAppAnyFormOptions.ignoreItemsStartsWith && dataLabel.match("(" + whatsAppAnyFormOptions.ignoreItemsStartsWith + ").*")) {
                        continue;
                    }
                    // prepare message for each form item
                    textToSend +=
                        dataLabel +
                        "  :  " +
                        fnMisc.trim(element.value) +
                        "\n";
                }
            }
            // closing of the message
            // textToSend += "```";
            // preparing api url
            var textWithApi =
                "https://api.whatsapp.com/send?phone=" + whatsAppAnyFormOptions.whatsAppNumber + "&text=" +
                encodeURIComponent(textToSend);
            if (whatsAppAnyFormOptions.submissionRedirectMessage) {
                $form.html(whatsAppAnyFormOptions.submissionRedirectMessage);
            }
            // check if needs to be open in new window
            if (whatsAppAnyFormOptions.openWhatsAppInNewWindow) {
                // open in new window to submit message via WhatsApp
                window.open(textWithApi);
            } else {
                // redirect user to submit message via WhatsApp
                location.href = textWithApi;
            }
        });
    });
})(jQuery);