<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://livelyworks.net
 * @since      1.0.0
 *
 * @package    Lwp_Whatsapp_Any_Form
 * @subpackage Lwp_Whatsapp_Any_Form/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Lwp_Whatsapp_Any_Form
 * @subpackage Lwp_Whatsapp_Any_Form/public
 * @author     livelyworks <contact@livelyworks.net>
 */
class Lwp_Whatsapp_Any_Form_Public
{
    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of the plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Lwp_Whatsapp_Any_Form_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Lwp_Whatsapp_Any_Form_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/lw-wp-whatsapp-any-form-public.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Lwp_Whatsapp_Any_Form_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Lwp_Whatsapp_Any_Form_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_register_script('jquery-validate', plugin_dir_url(__FILE__) . 'js/jquery.validate.min.js', array( 'jquery' ), '', true);
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/lw-wp-whatsapp-any-form-public.js', array( 'jquery-validate' ), $this->version, true);
        add_action('wp_footer', array($this, 'load_the_configurations'));
    }

    /**
     * Prepare configuration for javascript
     *
     * @return void
     */
    public function load_the_configurations()
    {
        ?>
            <script>
                (function ($) {
                    'use strict';
                    window['whatsAppAnyFormOptions'] = {
                            whatsAppNumber : '<?php echo sanitize_text_field(get_option('whatsapp_number')) ?>',
                            formSelector : '<?php echo sanitize_text_field(get_option('target_form_selectors')) ?>',
                            ignoreItemsStartsWith : '<?php echo sanitize_text_field(get_option('ignore_items_starts_with')) ?>',
                            openWhatsAppInNewWindow : <?php echo sanitize_text_field(get_option('open_whatsapp_in_new_window')) === 'yes' ? true : 0  ?>,
                            submissionRedirectMessage : <?php echo json_encode(sanitize_text_field(get_option('redirect_message'))) ?>,
                            includePageTitleInMessage : <?php echo sanitize_text_field(get_option('include_page_title_in_message')) === 'yes' ? true : 0  ?>,
                    };
                })(jQuery);
            </script>
        <?php
    }
}
