<?php

/**
 *
 * @link              https://livelyworks.net
 * @since             1.0.0
 * @package           Lwp_Whatsapp_Any_Form
 *
 * @wordpress-plugin
 * Plugin Name:       LWP WhatsApp AnyForm
 * Plugin URI:        https://livelyworks.net
 * Description:       WordPress WhatsApp AnyForm Plugin settings.
 * Author: livelyworks
 * Author URI: https://livelyworks.net
 * Version:           2.0.0
 * Text Domain:       lw-wp-whatsapp-any-form
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (! defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('LWP_WHATSAPP_ANY_FORM_VERSION', '2.0.0');
define('LWP_WHATSAPP_ANY_FORM_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-lw-wp-whatsapp-any-form-activator.php
 */
function lwp_activate_whatsapp_any_form()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-lw-wp-whatsapp-any-form-activator.php';
    Lwp_Whatsapp_Any_Form_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-lw-wp-whatsapp-any-form-deactivator.php
 */
function lwp_deactivate_whatsapp_any_form()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-lw-wp-whatsapp-any-form-deactivator.php';
    Lwp_Whatsapp_Any_Form_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'lwp_activate_whatsapp_any_form');
register_deactivation_hook(__FILE__, 'lwp_deactivate_whatsapp_any_form');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-lw-wp-whatsapp-any-form.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function lwp_whatsapp_any_form_run()
{
    $plugin = new Lwp_Whatsapp_Any_Form();
    $plugin->run();
}
lwp_whatsapp_any_form_run();
