<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://livelyworks.net
 * @since      1.0.0
 *
 * @package    Lwp_Whatsapp_Any_Form
 * @subpackage Lwp_Whatsapp_Any_Form/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Lwp_Whatsapp_Any_Form
 * @subpackage Lwp_Whatsapp_Any_Form/includes
 * @author     livelyworks <contact@livelyworks.net>
 */
class Lwp_Whatsapp_Any_Form_i18n
{
    /**
     * Load the plugin text domain for translation.
     *
     * @since    1.0.0
     */
    public function load_plugin_textdomain()
    {
        load_plugin_textdomain(
            'lw-wp-whatsapp-any-form',
            false,
            dirname(dirname(plugin_basename(__FILE__))) . '/languages/'
        );
    }
}
