<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://livelyworks.net
 * @since      1.0.0
 *
 * @package    Lwp_Whatsapp_Any_Form
 * @subpackage Lwp_Whatsapp_Any_Form/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Lwp_Whatsapp_Any_Form
 * @subpackage Lwp_Whatsapp_Any_Form/admin
 * @author     livelyworks <contact@livelyworks.net>
 */
class Lwp_Whatsapp_Any_Form_Admin
{
    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Lwp_Whatsapp_Any_Form_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Lwp_Whatsapp_Any_Form_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        // wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/lw-wp-whatsapp-any-form-admin.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Lwp_Whatsapp_Any_Form_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Lwp_Whatsapp_Any_Form_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/lw-wp-whatsapp-any-form-admin.js', array( 'jquery' ), $this->version, false);
    }

    /**
         * Add settings link to plugins page
         *
         * @param array $links
         * @return array
         * @since 2.0.0
         */
        function plugin_settings_link($links) {
            array_unshift($links, '<a href="'.admin_url("options-general.php?page={$this->plugin_name}") . '">' . esc_html__('Settings', 'lw-wp-whatsapp-any-form') . '</a>');
            return $links;
          }

    /**
     * Add an options page under the Settings submenu
     *
     * @since  1.0.0
     */
    public function add_options_page()
    {
        $this->plugin_screen_hook_suffix = add_options_page(
            __('WhatsApp Any Form Settings', 'lw-wp-whatsapp-any-form'),
            __('WhatsApp Any Form', 'lw-wp-whatsapp-any-form'),
            'manage_options',
            $this->plugin_name,
            array( $this, 'display_options_page' )
        );
    }

    /**
     * Render the options page for plugin
     *
     * @since  1.0.0
     */
    public function display_options_page()
    {
        include_once 'partials/lw-wp-whatsapp-any-form-admin-display.php';
    }

    public function register_setting_into_the_system()
    {
        // Add a General section
        add_settings_section(
            'general',
            __('General', 'lw-wp-whatsapp-any-form'),
            array( $this, 'general_cb' ),
            $this->plugin_name
        );

        add_settings_field(
            'target_form_selectors',
            __('Target Form Selector', 'lw-wp-whatsapp-any-form'),
            array( $this, 'target_form_selectors_field' ),
            $this->plugin_name,
            'general',
            array( 'label_for' => 'target_form_selectors' )
        );

        add_settings_field(
            'whatsapp_number',
            __('WhatsApp Number', 'lw-wp-whatsapp-any-form'),
            array( $this, 'whatsapp_number_field' ),
            $this->plugin_name,
            'general',
            array( 'label_for' => 'whatsapp_number' )
        );

        add_settings_field(
            'ignore_items_starts_with',
            __('Ignore Items starts with', 'lw-wp-whatsapp-any-form'),
            array( $this, 'ignore_items_starts_with_field' ),
            $this->plugin_name,
            'general',
            array( 'label_for' => 'ignore_items_starts_with' )
        );

        add_settings_field(
            'open_whatsapp_in_new_window',
            __('Open WhatsApp In new window', 'lw-wp-whatsapp-any-form'),
            array( $this, 'open_whatsapp_in_new_window_field' ),
            $this->plugin_name,
            'general',
            array( 'label_for' => 'open_whatsapp_in_new_window' )
        );

        add_settings_field(
            'redirect_message',
            __('Redirect Message', 'lw-wp-whatsapp-any-form'),
            array( $this, 'redirect_message_field' ),
            $this->plugin_name,
            'general',
            array( 'label_for' => 'redirect_message' )
        );

        add_settings_field(
            'include_page_title_in_message',
            __('Include Page Title in Message', 'lw-wp-whatsapp-any-form'),
            array( $this, 'include_page_title_in_message_field' ),
            $this->plugin_name,
            'general',
            array( 'label_for' => 'include_page_title_in_message' )
        );

        register_setting($this->plugin_name, 'whatsapp_number', array(
            'type'              => 'integer',
            'sanitize_callback' => array($this, 'validate_and_sanitize_whatsapp_number')
        ));
        register_setting($this->plugin_name, 'redirect_message');
        register_setting($this->plugin_name, 'target_form_selectors');
        register_setting($this->plugin_name, 'ignore_items_starts_with');
        register_setting($this->plugin_name, 'open_whatsapp_in_new_window');
        register_setting($this->plugin_name, 'include_page_title_in_message');
    }

    /**
     * Sanitize whatsapp number field
     *
     * @param number $whatsapp_number
     * @return number
     */
    public function validate_and_sanitize_whatsapp_number($whatsapp_number)
    {
        // check for valid number type
        if (!is_numeric($whatsapp_number) or ($whatsapp_number < 0) or (substr($whatsapp_number, 0, 1) === 0) or (substr($whatsapp_number, 0, 1) === '+')) {
            add_settings_error('whatsapp_number', 'whatsapp_number', __('Invalid WhatsApp Number', 'prefix'), 'error');
        }
        return $whatsapp_number;
    }

    /**
     * Render the text for the general section
     *
     * @since  1.0.0
     */
    public function general_cb()
    {
        echo '<p>' . __('Please change the settings accordingly.', 'lw-wp-whatsapp-any-form') . '</p>';
    }

    /**
     * Render the threshold day input for this plugin
     *
     * @since  1.0.0
     */
    public function target_form_selectors_field()
    {
        $targetFormElements = sanitize_text_field(get_option('target_form_selectors'));
        ?>
       <input type="text" id="target_form_selectors" name="target_form_selectors" value="<?php echo $targetFormElements ?>">
        <p class="description" id="target_form_selectors-description"><?php echo __('You can add "lw-wp-whatsapp-any-form" class to your form or its submit button or You can add any selector comma separated for the like . for class, # for ID etc', 'lw-wp-whatsapp-any-form') ?></p>
        <?php
    }

    /**
     * Render the threshold day input for this plugin
     *
     * @since  1.0.0
     */
    public function whatsapp_number_field()
    {
        $whatsAppNumber = sanitize_text_field(get_option('whatsapp_number'));
        ?>
        <input type="text" id="whatsapp_number" name="whatsapp_number" value="<?php echo $whatsAppNumber ?>">
        <p class="description" id="whatsapp_number-description"><?php echo __('Your WhatsApp mobile number where you want to receive messages. include your country code without leading 0 or +', 'lw-wp-whatsapp-any-form') ?></p>
        <?php
    }

    /**
     * Render the threshold day input for this plugin
     *
     * @since  1.0.0
     */
    public function open_whatsapp_in_new_window_field()
    {
        $openWhatsAppInNewWindow = sanitize_text_field(get_option('open_whatsapp_in_new_window'));
        ?>
        <input type="checkbox" id="open_whatsapp_in_new_window" name="open_whatsapp_in_new_window" value="yes" <?php checked($openWhatsAppInNewWindow, 'yes'); ?>>
        <p class="description" id="open_whatsapp_in_new_window-description"><?php echo __('Check if you want to open WhatsApp api url in new window if using WhatsApp API page.', 'lw-wp-whatsapp-any-form') ?></p>
        <?php
    }

    /**
     * Render the threshold day input for this plugin
     *
     * @since  2.0.0
     */
    public function include_page_title_in_message_field()
    {
        $includePageTitleInMessage = sanitize_text_field(get_option('include_page_title_in_message'));
        ?>
        <input type="checkbox" id="include_page_title_in_message" name="include_page_title_in_message" value="yes" <?php checked($includePageTitleInMessage, 'yes'); ?>>
        <p class="description" id="include_page_title_in_message-description"><?php echo __('Check if you want to send Page document title in message.', 'lw-wp-whatsapp-any-form') ?></p>
        <?php
    }

    /**
     * Render the threshold day input for this plugin
     *
     * @since  1.0.0
     */
    public function ignore_items_starts_with_field()
    {
        $targetFormElements = sanitize_text_field(get_option('ignore_items_starts_with'));
        ?>
       <input type="text" id="ignore_items_starts_with" name="ignore_items_starts_with" value="<?php echo $targetFormElements ?>">
        <p class="description" id="ignore_items_starts_with-description"><?php echo __('You can add any words pipe (|) separated so the system can ignore those fields to send as WhatsApp message eg. _wpcf7|wpforms', 'lw-wp-whatsapp-any-form') ?></p>
        <?php
    }

    /**
     * Render the threshold day input for this plugin
     *
     * @since  1.0.0
     */
    public function redirect_message_field()
    {
        $redirectMessage = sanitize_text_field(get_option('redirect_message'));
        ?>
        <textarea name="redirect_message" id="redirect_message" class="large-text" rows="4"><?php echo $redirectMessage ? $redirectMessage : 'You have been redirected to the WhatsApp to submit the message. We will get back to you soon!! Thank you' ?></textarea>
        <?php
    }
}
