﻿( function($) {
  	'use strict';

	/*****************************************************************/
	/* THEME TRIAL VERIFICATION */
	/*****************************************************************/

	var verifyData = window.wp_ajax_data || null;
	
	/*****************************************************************/
	// Manage theme trial period
	/*****************************************************************/
	
	$('#btn_trial_license').on('click', function(e) {

		e.preventDefault();

		if( verifyData === null ) {
			verifyData = window.wp_ajax_data || null;
		}

		// Create JSON objects
		/*****************************************************************/

		var jsonObjects = [{
			// Theme Trial Period Unlock Action
			command : 'start_plugin_trial_period',
		}];

		var jsonData = JSON.stringify( jsonObjects );

		// Create AJAX request
		/*****************************************************************/
		
		$.ajax({
			type: 'POST',
			dataType: 'json',
			url: verifyData.wp_ajax_url,
			data: { 
				action: 'wphave_admin_trial_process',
				security: WP_JS_Theme_Activation.verify_security_nonce,
				fieldData: jsonData,
			},
			beforeSend: function() {   
				// Unlocking button label
				$('#btn_trial_license').html( WP_JS_Theme_Activation.label_unlock );
			},
			cache: false,
			success: function(data) {

				//console.log($(data.trial_notice));				
				//console.log($(data.trial_action));			
				//console.log($(data.trial_attempts));
				//console.log($(data.success));				
				
				// License trial notice
				$('#license_notice').css('display', 'block');
				$('#license_notice .notice-holder').html( data.trial_notice );
				
				if( data.trial_action == 'success' ) {
					// Success notic color
					$('#license_notice').css('background', '#8db51e');					
					
					// Unlocked button label
					$('#btn_trial_license').html( WP_JS_Theme_Activation.label_unlocked );
				} else {
					// Try again button label
					$('#btn_trial_license').html( WP_JS_Theme_Activation.label_try );
				}
				
				// Reload the current page if the trial period was started
				if( data.trial_action == 'success' ) {
					setTimeout(function(){
						location.reload();
					}, 1500);			
				}
				
				//console.log('SUCCESS');
			},
			error: function(data) {
				// Try again button label
				$('#btn_trial_license').html( WP_JS_Theme_Activation.label_try );
				
				$('#license_notice .notice-holder').html( 'ERROR' );
				
				//console.log('FAILURE');
			}
		});

	});
	
})(jQuery);