﻿( function($) {
  	'use strict';

	/*****************************************************************/
	/* ENVATO PURCHASE CODE VERIFICATION */
	/*****************************************************************/

	var verifyData = window.wp_ajax_data || null;
	
	/*****************************************************************/
	// Manage purchase code verification
	/*****************************************************************/
	
	$('#purchase_verify').on('submit', function(e) {

		e.preventDefault();

		if( verifyData === null ) {
			verifyData = window.wp_ajax_data || null;
		}
		
		// Get user purchase code
		/*****************************************************************/
		
		var get_purchase_code = $("#purchase_code").val();

		// Create JSON objects
		/*****************************************************************/

		var jsonObjects = [{
			purchase_code : get_purchase_code,
		}];

		var jsonData = JSON.stringify( jsonObjects );

		// Create AJAX request
		/*****************************************************************/
		
		$.ajax({
			type: 'POST',
			dataType: 'json',
			url: verifyData.wp_ajax_url,
			data: { 
				action: 'wphave_admin_envato_activation_process',
				security: WP_JS_Theme_Activation.verify_security_nonce,
				fieldData: jsonData,
			},
			beforeSend: function() {   
				// Checking button label
				$('#btn_purchase').val( WP_JS_Theme_Activation.label_check );
			},
			cache: false,
			success: function(data) {

				//console.log($(data.trial_notice));				
				//console.log($(data.trial_action));			
				//console.log($(data.trial_attempts));
				//console.log($(data.success));				
				
				// License server notice
				$('#license_notice').css('display', 'block');
				$('#license_notice .notice-holder').html( data.license_action );
				
				if( data.license_status == 'success' ) {
					// Success notic color
					$('#license_notice').css('background', '#8db51e');
					
					// Done button label
					$('#btn_purchase').val( WP_JS_Theme_Activation.label_done );
				} else {
					// Try again button label
					$('#btn_purchase').val( WP_JS_Theme_Activation.label_try );
					
					// Show theme trial area (if activation not possible)
					$('.theme-trial').css('display', 'block');
				}			
				
				// Reload the current page if the purchase code is valid
				if( data.license_status == 'success' ) {
					setTimeout(function(){
						location.reload();
					}, 1500);				
				}
				
				//console.log('SUCCESS');
			},
			error: function(data) {
				// Try again button label
				$('#btn_purchase').val( WP_JS_Theme_Activation.label_try );
				
				$('#license_notice .notice-holder').html( 'ERROR' );
				
				//console.log('FAILURE');
			}
		});

	});
	
	/*****************************************************************/
	// Manage purchase code unlocking
	/*****************************************************************/
	
	$('#btn_delete_license').on('click', function(e) {

		e.preventDefault();

		if( verifyData === null ) {
			verifyData = window.wp_ajax_data || null;
		}

		// Create JSON objects
		/*****************************************************************/

		var jsonObjects = [{
			// Purchase Code Unlock Action
			command : 'unlock_purchase_code',
		}];

		var jsonData = JSON.stringify( jsonObjects );

		// Create AJAX request
		/*****************************************************************/
		
		$.ajax({
			type: 'POST',
			dataType: 'json',
			url: verifyData.wp_ajax_url,
			data: { 
				action: 'wphave_admin_envato_deactivation_process',
				security: WP_JS_Theme_Activation.verify_security_nonce,
				fieldData: jsonData,
			},
			beforeSend: function() {   
				// Unlocking button label
				$('#btn_delete_license').html( WP_JS_Theme_Activation.label_unlock );
			},
			cache: false,
			success: function(data) {

				//console.log($(data.license_action));
				//console.log($(data.success));				
				
				// License server notice
				$('#license_notice').css('display', 'block');
				$('#license_notice .notice-holder').html( data.license_action );
				
				if( data.license_status == 'success' ) {
					// Success notic color
					$('#license_notice').css('background', '#8db51e');
					
					// Unlocked button label
					$('#btn_delete_license').html( WP_JS_Theme_Activation.label_unlocked );
				} else {
					// Try again button label
					$('#btn_delete_license').html( WP_JS_Theme_Activation.label_try );
					
					// If license can not unlocked, show the reset license button
					$('.license-reset').css('display', 'block');
				}
				
				// Reload the current page if the purchase code is unlocked				
				if( data.license_status == 'success' ) {
					setTimeout(function(){
						location.reload();
					}, 1500);			
				}
				
				//console.log('SUCCESS');
			},
			error: function(data) {
				// Try again button label
				$('#btn_delete_license').html( WP_JS_Theme_Activation.label_try );
				
				$('#license_notice .notice-holder').html( 'ERROR' );
				
				//console.log('FAILURE');
			}
		});

	});
	
})(jQuery);