<?php 

/*
 *******************
 * OPTION UPDATE - PERFORMED CHECK
 *******************
 *
 *	This function to break the updating data process, if this process has been already performed.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists('wphave_admin_should_run_update_data') ) :

	function wphave_admin_should_run_update_data( $post_option_flag ) {
			
		$update_flag = get_option('wphave_update_data'); 
		$update_key = $post_option_flag; // <-- Identifier for this update process

		// If option key not exist, change to "unset"
		$is_updated = isset( $update_flag[$update_key] ) ? $update_flag[$update_key] : 'unset';

		if( $is_updated === 'set' ) {
			// Stop here, update operation was already performed
			// ! Notice: This is essential, to avoid querying the database each time if the page is loaded
			return false;			
		}
		
		return true;
				
	}

endif;


/*
 *******************
 * OPTION UPDATE - PERFORMED CHECK
 *******************
 *
 *	This function checks if an update of an old option value has already been performed.
 *	After the first execution, a flag such as "set" is set for this function to avoid the same operation several times.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	2.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

if ( ! function_exists('wphave_admin_update_data_performed') ) :

	function wphave_admin_update_data_performed( $post_option_flag ) {
			
		// Get post option flags
		$options_uptodate = get_option('wphave_update_data');
		
		// Check if option exist
		if( ! $options_uptodate ) {
			// Define option to set old post options up to date
			add_option('wphave_update_data', array(), '', 'yes');
		}		
		
		// If option key not exist, change to "unset"
		$option_value = isset( $options_uptodate[$post_option_flag] ) ? $options_uptodate[$post_option_flag] : 'unset';

		// Fire only for the first call if the value is "unset"
		if( $option_value === 'unset' ) {

			// If the option was updated, change option value to "set"
			// This means: This check is firing only once time
			$options_uptodate[$post_option_flag] = 'set';

			// Update option array
			update_option('wphave_update_data', $options_uptodate, 'yes');

		}
				
	}

endif;


/*
 *******************
 * RENAME OLD PLUGIN LICENSE TABLE
 *******************
 *
 *	Detect if the old license table "wp_admin_theme_cd_license_data" exist, then rename to new license table name.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	3.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

function wphave_admin_rename_old_plugin_license_db_table() {
	
	global $wpdb;
	
	// List old license table names
	$old_license_tables = array(
		'wp_admin_theme_cd_license_data',
		$wpdb->prefix . 'wp_admin_theme_cd_license_data'
	);
	
	// Define new license table name
	$new_license_table = 'wphave_admin_license_data';
	
	// Check for the old license table
	foreach( $old_license_tables as $old_license_table ) {
		$query = $wpdb->prepare( 'SHOW TABLES LIKE %s', $wpdb->esc_like( $old_license_table ) );
		
		if( $wpdb->get_var( $query ) == $old_license_table ) {
			$old_license_table = $old_license_table;	
		}
	}
	
	// Check if the old license table exist
	if( in_array( $wpdb->get_var( $query ), $old_license_tables ) ) {
		
		// MySQL connect
		$mysqli = wphave_admin_mysqli_connect();
	
		// Define new license table name
		$new_license_table = $wpdb->prefix . $new_license_table;
		
		// Search for old table name and rename to the new table name
		mysqli_query( $mysqli, "ALTER TABLE " . $old_license_table . " RENAME TO " . $new_license_table );
		
	}
	
	// Old license table not found
	return false;
	
}

//add_action('admin_init', 'wphave_admin_rename_old_plugin_license_db_table'); // ------------------------------------------------------------> CURRENTLY DEACTIVATED !


/*
 *******************
 * REFRESH LICENSE
 *******************
 *
 *	After changing the license server, we have to register old installations again, without a manual action by the user.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	3.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

function wphave_admin_license_refresh() {	
	
	// Check if updating data is necessary
	$update_key = 'wphave_admin_refresh_license';
	if( ! wphave_admin_should_run_update_data( $update_key ) ) {
		// Stop here, update operation was already performed
		// ! Notice: This is essential, to avoid querying the database each time if the page is loaded
		return;			
	}
	
	/*
	******/
	
	$activation_status_old = get_option( 'wp_admin_theme_cd_license' );
	$code = get_option( 'envato_purchase_code_' . WPHAVE_ADMIN_ENVATO_ID );
	
	if( is_multisite() ) {
		$blog_id = 1; // <-- Option from main site
		$activation_status_old = get_blog_option( $blog_id, 'wp_admin_theme_cd_license', array() );
	}
	
	if( $activation_status_old === 'active' && $code ) {
		
		// Action to install license (if process is successfully)
		$license_add = wphave_admin_license_server_api( $code, wphave_admin_root_url(), 'lock' );
	
		// Installation successful
		if( $license_add === 'LOCKED' ) {
			// ToDo after installing license
			wphave_admin_license_add_todo( $code );	
		}
		
		// Delete old options
		delete_option( 'wp_admin_theme_cd_license' );
		delete_option( 'envato_purchase_code_' . WPHAVE_ADMIN_ENVATO_ID );
		
	}
	
	/*
	******/
	
	// After the operation has been performed, the option value will changed to "set"
	wphave_admin_update_data_performed( $update_key );

}

add_action('admin_init', 'wphave_admin_license_refresh');


/*
 *******************
 * DELETE OLD LICENSE TABLE
 *******************
 *
 *	After changing the license activation process, the license table is no longer necessary.
 *
 *  @type	function
 *  @date	06/18/19
 *  @since	3.0
 *
 *  @param	N/A
 *  @return	N/A
 *
*/

function wphave_admin_delete_old_license_table() {
	
	// Check if updating data is necessary
	$update_key = 'wphave_admin_delete_old_license_table';
	if( ! wphave_admin_should_run_update_data( $update_key ) ) {
		// Stop here, update operation was already performed
		// ! Notice: This is essential, to avoid querying the database each time if the page is loaded
		return;			
	}
	
	/*
	******/
	
	// MySQL connect
	$mysqli = wphave_admin_mysqli_connect();
	
	// Check for license table
	global $wpdb;
	$license_table = ( $wpdb->prefix . 'wphave_admin_license_data' );
	$query = $wpdb->prepare( 'SHOW TABLES LIKE %s', $wpdb->esc_like( $license_table ) );

	// Check if license table exist
	if( $wpdb->get_var( $query ) == $license_table ) {
		// Action to delete license table manually
		mysqli_query( $mysqli, "DELETE FROM " . $license_table );
		mysqli_query( $mysqli, "DROP TABLE " . $license_table );
	}
	
	/*
	******/
	
	// After the operation has been performed, the option value will changed to "set"
	wphave_admin_update_data_performed( $update_key );
	
}

add_action('admin_init', 'wphave_admin_delete_old_license_table');