<?php
add_filter('woocommerce_currencies', 'add_custom_currencies');

function add_custom_currencies($currencies)
{
    $custom_currencies = array(
'AED' => __('Emirati Dirham', 'woocommerce'),
'BHD' => __('Bahraini Dinar', 'woocommerce'),
'DZD' => __('Algerian Dinar', 'woocommerce'),
'EGP' => __('Egyptian Pound', 'woocommerce'),
'FDJ' => __('Djibouti Franc', 'woocommerce'),
'IQD' => __('Iraqi Dinars', 'woocommerce'),
'JOD' => __('Jordanian Dinar', 'woocommerce'),
'KMF' => __('Comorian Franc', 'woocommerce'),
'KWD' => __('Kuwaiti Dinar', 'woocommerce'),
'LBP' => __('Lebanese Pound', 'woocommerce'),
'LYD' => __('Libyan Dinar', 'woocommerce'),
'MAD' => __('Moroccan Dirham', 'woocommerce'),
'MRO' => __('Mauritania Ouguiya', 'woocommerce'),
'OMR' => __('Omani Rial', 'woocommerce'),
'QAR' => __('Qatari Riyal', 'woocommerce'),
'SAR' => __('Saudi Riyal', 'woocommerce'),
'SDG' => __('Sudanese Pound', 'woocommerce'),
'SOS' => __('Somali shilling', 'woocommerce'),
'SYP' => __('Syrian Pound', 'woocommerce'),
'TND' => __('Tunisian Dinar', 'woocommerce'),
'YER' => __('Yemen Riyal', 'woocommerce'),
        // Add more currencies here if needed
    );

    $currencies = array_merge($currencies, $custom_currencies);

    return $currencies;
}

add_filter('woocommerce_currency_symbol', 'add_custom_currency_symbols', 10, 2);

function add_custom_currency_symbols($currency_symbol, $currency)
{
    $custom_currency_symbols = array(
'AED' => 'AED',
'BHD' => 'BHD',
'DZD' => 'DZD',
'EGP' => 'EGP',
'FDJ' => 'FDJ',
'IQD' => 'IQD',
'JOD' => 'JOD',
'KMF' => 'KMF',
'KWD' => 'KWD',
'LBP' => 'LBP',
'LYD' => 'LYD',
'MAD' => 'MAD',
'MRO' => 'MRO',
'OMR' => 'OMR',
'QAR' => 'QAR',
'SAR' => 'SAR',
'SDG' => 'SDG',
'SOS' => 'SOS',
'SYP' => 'SYP',
'TND' => 'TND',
'YER' => 'YER',
        // Add more currency symbols here if needed
    );

    if (isset($custom_currency_symbols[$currency])) {
        $currency_symbol = $custom_currency_symbols[$currency];
    }

    return $currency_symbol;
}
