<div class="directorist-create-directory">
	<div class="directorist-create-directory__header">
		<div class="directorist-create-directory__close">
			<a href="<?php echo esc_attr(
                admin_url()
            ); ?>" class="directorist-create-directory__close__btn">
				<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd"
						d="M5.24408 5.24408C5.56951 4.91864 6.09715 4.91864 6.42259 5.24408L10 8.82149L13.5774 5.24408C13.9028 4.91864 14.4305 4.91864 14.7559 5.24408C15.0814 5.56951 15.0814 6.09715 14.7559 6.42259L11.1785 10L14.7559 13.5774C15.0814 13.9028 15.0814 14.4305 14.7559 14.7559C14.4305 15.0814 13.9028 15.0814 13.5774 14.7559L10 11.1785L6.42259 14.7559C6.09715 15.0814 5.56951 15.0814 5.24408 14.7559C4.91864 14.4305 4.91864 13.9028 5.24408 13.5774L8.82149 10L5.24408 6.42259C4.91864 6.09715 4.91864 5.56951 5.24408 5.24408Z"
						fill="#141921" />
				</svg>
				Close All
			</a>
		</div>

		<div class="directorist-create-directory__upgrade">
			<!-- <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path
					d="M32 16C32 24.8366 24.8366 32 16 32C7.16344 32 0 24.8366 0 16C0 7.16344 7.16344 0 16 0C24.8366 0 32 7.16344 32 16ZM5.28 16C5.28 21.9205 10.0795 26.72 16 26.72C21.9205 26.72 26.72 21.9205 26.72 16C26.72 10.0795 21.9205 5.28 16 5.28C10.0795 5.28 5.28 10.0795 5.28 16Z"
					fill="#F0F3FF" />
				<path
					d="M16 29.36C16 30.818 17.1898 32.0222 18.6281 31.7827C19.8244 31.5835 20.9971 31.2484 22.1229 30.7821C24.0641 29.978 25.828 28.7994 27.3137 27.3137C28.7994 25.828 29.978 24.0641 30.7821 22.1229C31.5861 20.1817 32 18.1012 32 16C32 13.8989 31.5861 11.8183 30.7821 9.87706C29.978 7.93586 28.7994 6.17203 27.3137 4.68629C25.828 3.20055 24.0641 2.022 22.1229 1.21793C20.9971 0.751602 19.8244 0.416526 18.6281 0.217309C17.1898 -0.0221786 16 1.18197 16 2.64C16 4.09803 17.1994 5.24799 18.6134 5.60344C19.12 5.73077 19.6176 5.89523 20.1024 6.09601C21.403 6.63474 22.5847 7.42437 23.5802 8.41982C24.5756 9.41526 25.3653 10.597 25.904 11.8976C26.4427 13.1982 26.72 14.5922 26.72 16C26.72 17.4078 26.4427 18.8018 25.904 20.1024C25.3653 21.403 24.5756 22.5847 23.5802 23.5802C22.5847 24.5756 21.403 25.3653 20.1024 25.904C19.6176 26.1048 19.12 26.2692 18.6134 26.3966C17.1994 26.752 16 27.902 16 29.36Z"
					fill="#F6C879" />
				<path
					d="M11.3253 11.2727V20H9.74432V12.8111H9.69318L7.65199 14.1151V12.6662L9.82102 11.2727H11.3253ZM16.7713 10.8636L13.9588 21.3125H13.0384L15.8509 10.8636H16.7713ZM17.7958 20V19.3608L20.1964 16.733C20.4781 16.4252 20.7101 16.1577 20.8924 15.9304C21.0747 15.7008 21.2096 15.4853 21.2972 15.2841C21.3872 15.0805 21.4322 14.8674 21.4322 14.6449C21.4322 14.3892 21.3706 14.1679 21.2475 13.9808C21.1268 13.7938 20.9611 13.6494 20.7504 13.5476C20.5397 13.4458 20.3029 13.3949 20.0401 13.3949C19.7608 13.3949 19.5169 13.4529 19.3086 13.5689C19.1026 13.6825 18.9428 13.8423 18.8292 14.0483C18.7179 14.2543 18.6623 14.4957 18.6623 14.7727H17.8242C17.8242 14.3466 17.9225 13.9725 18.119 13.6506C18.3155 13.3286 18.583 13.0777 18.9215 12.8977C19.2624 12.7178 19.6448 12.6278 20.0685 12.6278C20.4947 12.6278 20.8723 12.7178 21.2013 12.8977C21.5304 13.0777 21.7885 13.3203 21.9755 13.6257C22.1625 13.9311 22.256 14.2708 22.256 14.6449C22.256 14.9124 22.2075 15.174 22.1104 15.4297C22.0157 15.683 21.85 15.9659 21.6133 16.2784C21.3789 16.5885 21.0534 16.9673 20.6367 17.4148L19.0032 19.1619V19.2188H22.3839V20H17.7958Z"
					fill="#141921" />
			</svg> -->
			<div class="directorist-create-directory__upgrade__content">
				<h4 class="directorist-create-directory__upgrade__title">
					<!-- You have used Builder AI<span>15</span> time(s). -->
					<!-- <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path
							d="M8.875 11.5C8.875 11.5995 8.83549 11.6948 8.76517 11.7652C8.69484 11.8355 8.59946 11.875 8.5 11.875C8.26794 11.875 8.04538 11.7828 7.88128 11.6187C7.71719 11.4546 7.625 11.2321 7.625 11V8.5C7.625 8.46685 7.61183 8.43505 7.58839 8.41161C7.56495 8.38817 7.53315 8.375 7.5 8.375C7.40055 8.375 7.30516 8.33549 7.23484 8.26516C7.16451 8.19484 7.125 8.09946 7.125 8C7.125 7.90054 7.16451 7.80516 7.23484 7.73484C7.30516 7.66451 7.40055 7.625 7.5 7.625C7.73207 7.625 7.95463 7.71719 8.11872 7.88128C8.28282 8.04538 8.375 8.26794 8.375 8.5V11C8.375 11.0332 8.38817 11.0649 8.41161 11.0884C8.43506 11.1118 8.46685 11.125 8.5 11.125C8.59946 11.125 8.69484 11.1645 8.76517 11.2348C8.83549 11.3052 8.875 11.4005 8.875 11.5ZM7.75 6.375C7.87362 6.375 7.99445 6.33834 8.09723 6.26967C8.20002 6.20099 8.28012 6.10338 8.32743 5.98918C8.37473 5.87497 8.38711 5.74931 8.36299 5.62807C8.33888 5.50683 8.27935 5.39547 8.19195 5.30806C8.10454 5.22065 7.99317 5.16112 7.87193 5.13701C7.7507 5.11289 7.62503 5.12527 7.51083 5.17258C7.39662 5.21988 7.29901 5.29999 7.23033 5.40277C7.16166 5.50555 7.125 5.62639 7.125 5.75C7.125 5.91576 7.19085 6.07473 7.30806 6.19194C7.42527 6.30915 7.58424 6.375 7.75 6.375ZM14.375 8.5C14.375 9.76086 14.0011 10.9934 13.3006 12.0418C12.6001 13.0901 11.6045 13.9072 10.4396 14.3897C9.27473 14.8722 7.99293 14.9985 6.7563 14.7525C5.51967 14.5065 4.38376 13.8994 3.4922 13.0078C2.60064 12.1162 1.99348 10.9803 1.7475 9.7437C1.50152 8.50707 1.62776 7.22527 2.11027 6.06039C2.59278 4.89551 3.40988 3.89988 4.45824 3.19938C5.50661 2.49889 6.73915 2.125 8 2.125C9.69015 2.12698 11.3105 2.79927 12.5056 3.99439C13.7007 5.1895 14.373 6.80985 14.375 8.5ZM13.625 8.5C13.625 7.38748 13.2951 6.29994 12.677 5.37492C12.0589 4.44989 11.1804 3.72892 10.1526 3.30318C9.12476 2.87743 7.99376 2.76604 6.90262 2.98308C5.81148 3.20012 4.8092 3.73585 4.02253 4.52252C3.23586 5.30919 2.70013 6.31147 2.48309 7.40262C2.26604 8.49376 2.37744 9.62476 2.80318 10.6526C3.22892 11.6804 3.94989 12.5589 4.87492 13.177C5.79995 13.7951 6.88748 14.125 8 14.125C9.49134 14.1233 10.9211 13.5302 11.9757 12.4756C13.0302 11.4211 13.6233 9.99133 13.625 8.5Z"
							fill="#747C89" />
					</svg> -->
				</h4>
				<!-- <a href="https://directorist.com/pricing/" target="_blank"
					class="directorist-create-directory__upgrade__link">
					Get Unlimited access
				</a> -->
			</div>
		</div>
	</div>
	<div class="directorist-create-directory__wrapper">
		<div class="directorist-create-directory__top">
			<div class="directorist-create-directory__step">
				<ul class="atbdp-setup-steps <?php echo esc_attr($hide); ?>">
					<li class="active"></li>
					<li></li>
					<li></li>
				</ul>
				<span class="step-count">
					<span class="current-step">
						<?php esc_html_e(
							sprintf("%d", $active_number),
						"directorist"
					); ?>
					</span>/
					<span class="total-step">3</span>
				</span>
			</div>
			<div class="directorist-create-directory__info">
				<h1 class="directorist-create-directory__info__title">
					<?php esc_html_e(
                        "Let’s set up your directory",
                        "directorist"
                    ); ?>
				</h1>
				<p class="directorist-create-directory__info__desc">
					<?php esc_html_e(
                        "Build your directory instantly. Customize with Directorist AI",
                        "directorist"
                    ); ?>
				</p>
			</div>
		</div>
		<div class="directorist-create-directory__content">
			<!-- Step 1 Building Directory -->
			<div class="directorist-create-directory__content__items directorist-create-directory__content__items--columns" data-step="1">
				<div class="directorist-create-directory__content__form-group">
					<label class="directorist-create-directory__content__form-group-label" for="directory-name">
						Directory Name <span class="required-label">*</span>
					</label>
					<div class="directorist-create-directory__content__input-group">
						<span class="directorist-create-directory__content__input-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M6.30668 2.5H14.6933C15.0589 2.49999 15.3743 2.49998 15.6353 2.51779C15.9102 2.53655 16.1851 2.5778 16.4567 2.6903C17.0693 2.94404 17.556 3.43072 17.8097 4.04329C17.9222 4.3149 17.9635 4.58982 17.9822 4.86468C18 5.12573 18 5.44114 18 5.80668V5.83333C18 6.29357 17.6269 6.66667 17.1667 6.66667C16.7064 6.66667 16.3333 6.29357 16.3333 5.83333C16.3333 5.43365 16.3329 5.17562 16.3194 4.97813C16.3064 4.78814 16.2843 4.71578 16.2699 4.6811C16.1853 4.47691 16.0231 4.31468 15.8189 4.2301C15.7842 4.21574 15.7119 4.19356 15.5219 4.18059C15.3244 4.16712 15.0664 4.16667 14.6667 4.16667H11.3333V15.8333H13C13.4602 15.8333 13.8333 16.2064 13.8333 16.6667C13.8333 17.1269 13.4602 17.5 13 17.5H8C7.53976 17.5 7.16667 17.1269 7.16667 16.6667C7.16667 16.2064 7.53976 15.8333 8 15.8333H9.66667V4.16667H6.33333C5.93365 4.16667 5.67562 4.16712 5.47813 4.18059C5.28814 4.19356 5.21578 4.21574 5.1811 4.2301C4.97691 4.31468 4.81468 4.47691 4.7301 4.6811C4.71574 4.71578 4.69356 4.78814 4.68059 4.97813C4.66712 5.17562 4.66667 5.43365 4.66667 5.83333C4.66667 6.29357 4.29357 6.66667 3.83333 6.66667C3.3731 6.66667 3 6.29357 3 5.83333L3 5.80668C2.99999 5.44114 2.99998 5.12573 3.01779 4.86468C3.03655 4.58982 3.0778 4.3149 3.1903 4.04329C3.44404 3.43072 3.93072 2.94404 4.54329 2.6903C4.8149 2.5778 5.08982 2.53655 5.36468 2.51779C5.62573 2.49998 5.94114 2.49999 6.30668 2.5Z"
									fill="currentColor" />
							</svg>
						</span>
						<input type="text" id="directory-name" name="directory-name"
							class="form-control directorist-create-directory__content__input"
							placeholder="Directory name" required />
					</div>
				</div>

				<div class="directorist-create-directory__content__form-group">
					<label class="directorist-create-directory__content__form-group-label" for="directory-location">
						Location <span class="optional-label">(optional)</span>
					</label>
					<div class="directorist-create-directory__content__input-group">
						<span class="directorist-create-directory__content__input-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M10.5 2.50016C7.27834 2.50016 4.66667 5.11183 4.66667 8.3335C4.66667 9.91025 5.37764 11.3985 6.5769 12.9557C7.58951 14.2706 8.88561 15.5562 10.2769 16.9362C10.351 17.0097 10.4254 17.0835 10.5 17.1576C10.5746 17.0835 10.649 17.0097 10.7231 16.9362C12.1144 15.5562 13.4105 14.2706 14.4231 12.9557C15.6224 11.3985 16.3333 9.91025 16.3333 8.3335C16.3333 5.11183 13.7217 2.50016 10.5 2.50016ZM3 8.3335C3 4.19136 6.35786 0.833496 10.5 0.833496C14.6421 0.833496 18 4.19136 18 8.3335C18 10.4386 17.0443 12.2837 15.7436 13.9727C14.6566 15.384 13.2654 16.7632 11.8757 18.1409C11.6128 18.4015 11.35 18.662 11.0893 18.9228C10.7638 19.2482 10.2362 19.2482 9.91074 18.9228C9.65003 18.662 9.38719 18.4015 9.12431 18.1409C7.73456 16.7632 6.34337 15.384 5.25643 13.9727C3.95569 12.2837 3 10.4386 3 8.3335ZM10.5 6.66683C9.57953 6.66683 8.83333 7.41302 8.83333 8.3335C8.83333 9.25397 9.57953 10.0002 10.5 10.0002C11.4205 10.0002 12.1667 9.25397 12.1667 8.3335C12.1667 7.41302 11.4205 6.66683 10.5 6.66683ZM7.16667 8.3335C7.16667 6.49255 8.65905 5.00016 10.5 5.00016C12.3409 5.00016 13.8333 6.49255 13.8333 8.3335C13.8333 10.1744 12.3409 11.6668 10.5 11.6668C8.65905 11.6668 7.16667 10.1744 7.16667 8.3335Z"
									fill="currentColor" />
							</svg>
						</span>
						<input type="search" id="directory-location" name="directory-location"
							class="form-control directorist-create-directory__content__input"
							placeholder="Directory location" />
					</div>
				</div>
			</div>

			<!-- Step 2 Describe business -->
			<div class="directorist-create-directory__content__items" data-step="2">
				<div class="directorist-create-directory__content__form-group">
					<label class="directorist-create-directory__content__form-group-label" for="business-name">
						Directory Type
					</label>
					<div class="directorist-create-directory__checkbox-wrapper --gap-12 --svg-size-20">
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="car-directory" value="car" checked />
							<label for="car-directory">
								<svg xmlns="http://www.w3.org/2000/svg" width="19" height="14" viewBox="0 0 19 14"
									fill="none">
									<path
										d="M6.99984 10.9997C6.99984 11.9201 6.25365 12.6663 5.33317 12.6663C4.4127 12.6663 3.6665 11.9201 3.6665 10.9997C3.6665 10.0792 4.4127 9.33301 5.33317 9.33301C6.25365 9.33301 6.99984 10.0792 6.99984 10.9997Z"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M15.3333 10.9997C15.3333 11.9201 14.5871 12.6663 13.6667 12.6663C12.7462 12.6663 12 11.9201 12 10.9997C12 10.0792 12.7462 9.33301 13.6667 9.33301C14.5871 9.33301 15.3333 10.0792 15.3333 10.9997Z"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path d="M1.1665 5.1665L14.4998 5.1665" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path
										d="M17.8332 10.9998V11.4998C18.1093 11.4998 18.3332 11.2759 18.3332 10.9998H17.8332ZM17.8332 6.8331H18.3332C18.3332 6.64371 18.2262 6.47058 18.0568 6.38588L17.8332 6.8331ZM11.1665 0.999512L11.5569 0.687176C11.4621 0.568558 11.3184 0.499508 11.1665 0.499512L11.1665 0.999512ZM14.4998 5.16643L14.1094 5.47877C14.1546 5.53527 14.2115 5.58129 14.2762 5.61365L14.4998 5.16643ZM1.1665 5.16643L0.702266 4.98074C0.678641 5.0398 0.666503 5.10282 0.666504 5.16644L1.1665 5.16643ZM1.16655 10.9998L0.666546 10.9998C0.666548 11.2759 0.890405 11.4998 1.16655 11.4998L1.16655 10.9998ZM15.3332 11.4998H17.8332V10.4998H15.3332V11.4998ZM18.3332 10.9998L18.3332 6.8331L17.3332 6.8331L17.3332 10.9998H18.3332ZM11.1665 0.499512L1.16649 0.499765L1.16652 1.49977L11.1665 1.49951L11.1665 0.499512ZM14.8903 4.8541L11.5569 0.687176L10.7761 1.31185L14.1094 5.47877L14.8903 4.8541ZM18.0568 6.38588L14.7234 4.71922L14.2762 5.61365L17.6096 7.28031L18.0568 6.38588ZM2.36893 0.81407L0.702266 4.98074L1.63074 5.35213L3.29741 1.18546L2.36893 0.81407ZM0.666504 5.16644L0.666546 10.9998L1.66655 10.9998L1.6665 5.16643L0.666504 5.16644ZM3.6665 10.4998H1.16655L1.16655 11.4998H3.6665L3.6665 10.4998ZM6.99984 11.4998L11.9998 11.4998L11.9998 10.4998L6.99984 10.4998L6.99984 11.4998Z"
										fill="currentColor" />
									<path d="M7 5.16667L7 1" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
								</svg>
								Car Directory
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="hotel-directory" value="hotel" />
							<label for="hotel-directory">
								<svg xmlns="http://www.w3.org/2000/svg" width="19" height="17" viewBox="0 0 19 17"
									fill="none">
									<path d="M17.8332 13.1665L1.1665 13.1665" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path d="M17.8332 16.5L17.8332 9L1.1665 9L1.1665 16.5" stroke="currentColor"
										stroke-width="1.5" stroke-linejoin="round" />
									<path d="M12 9V6.5L7 6.5L7 9" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path
										d="M5.33301 4L5.33301 4.75L5.76969 4.75L5.98525 4.37024L5.33301 4ZM13.6663 4L13.0141 4.37024L13.2297 4.75H13.6663V4ZM16.1663 4L16.9163 4C16.9163 3.58579 16.5806 3.25 16.1663 3.25V4ZM2.83301 4V3.25C2.41879 3.25 2.08301 3.58579 2.08301 4H2.83301ZM5.98525 4.37024C6.70692 3.09887 8.20066 2.25 9.49967 2.25V0.75C7.64232 0.75 5.65964 1.90527 4.68076 3.62976L5.98525 4.37024ZM9.49967 2.25C10.7987 2.25 12.2924 3.09887 13.0141 4.37024L14.3186 3.62976C13.3397 1.90527 11.357 0.75 9.49967 0.75V2.25ZM13.6663 4.75L16.1663 4.75V3.25L13.6663 3.25V4.75ZM15.4163 4L15.4163 9H16.9163V4L15.4163 4ZM5.33301 3.25L2.83301 3.25L2.83301 4.75H5.33301L5.33301 3.25ZM2.08301 4L2.08301 9H3.58301L3.58301 4H2.08301Z"
										fill="currentColor" />
								</svg>
								Hotel Directory
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="travel-directory" value="travel" />
							<label for="travel-directory">
								<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
									fill="none">
									<path
										d="M10.5 17.5C9.46444 17.5 8.49056 17.3028 7.57833 16.9083C6.66611 16.5133 5.8725 15.9783 5.1975 15.3033C4.52194 14.6278 3.98694 13.8339 3.5925 12.9217C3.1975 12.0094 3 11.0356 3 10C3 8.96444 3.19722 7.99056 3.59167 7.07833C3.98611 6.16611 4.52139 5.3725 5.1975 4.6975C5.87361 4.0225 6.66722 3.48722 7.57833 3.09167C8.49111 2.69722 9.465 2.5 10.5 2.5C12.4422 2.5 14.1178 3.14083 15.5267 4.4225C16.9356 5.70417 17.7419 7.28722 17.9458 9.17167H17.1025C16.9564 7.96556 16.5208 6.88306 15.7958 5.92417C15.0708 4.96528 14.1389 4.25778 13 3.80167V4.16667C13 4.625 12.8369 5.0175 12.5108 5.34417C12.1847 5.67083 11.7922 5.83389 11.3333 5.83333H9.66667V7.5C9.66667 7.73611 9.58667 7.93417 9.42667 8.09417C9.26667 8.25417 9.06889 8.33389 8.83333 8.33333H7.16667V10H8.705V12.5H8L4 8.5C3.95833 8.75 3.92028 9 3.88583 9.25C3.85139 9.5 3.83389 9.75 3.83333 10C3.83333 11.8194 4.47222 13.3819 5.75 14.6875C7.02778 15.9931 8.61111 16.6528 10.5 16.6667V17.5ZM18.0192 17.275L15.1442 14.4333C14.8953 14.6106 14.6256 14.7494 14.335 14.85C14.0444 14.95 13.7383 15 13.4167 15C12.5994 15 11.9092 14.7183 11.3458 14.155C10.7819 13.5906 10.5 12.9 10.5 12.0833C10.5 11.2667 10.7819 10.5764 11.3458 10.0125C11.9097 9.44861 12.6 9.16667 13.4167 9.16667C14.2333 9.16667 14.9239 9.44861 15.4883 10.0125C16.0528 10.5764 16.3344 11.2667 16.3333 12.0833C16.3333 12.4156 16.2806 12.7294 16.175 13.025C16.0694 13.3211 15.9222 13.5936 15.7333 13.8425L18.6083 16.6858L18.0192 17.275ZM13.4167 14.1667C14 14.1667 14.4931 13.9653 14.8958 13.5625C15.2986 13.1597 15.5 12.6667 15.5 12.0833C15.5 11.5 15.2986 11.0069 14.8958 10.6042C14.4931 10.2014 14 10 13.4167 10C12.8333 10 12.3403 10.2014 11.9375 10.6042C11.5347 11.0069 11.3333 11.5 11.3333 12.0833C11.3333 12.6667 11.5347 13.1597 11.9375 13.5625C12.3403 13.9653 12.8333 14.1667 13.4167 14.1667Z"
										fill="currentColor" />
								</svg>
								Travel Directory
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="job-listing" value="job" />
							<label for="job-listing">
								<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19"
									fill="none">
									<path d="M16.1665 9.99984V1.6665L1.1665 1.6665L1.1665 16.6665L9.49984 16.6665"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path d="M1.1665 5.83301L16.1665 5.83301" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path
										d="M7.83333 12.9163L9.5 12.9163M4.5 12.9163H6.16667M7.83333 9.58301L12.8333 9.58301M4.5 9.58301H6.16667"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M16.4169 16.9144L17.8332 18.3332M17.1665 14.6665C17.1665 13.0096 15.8234 11.6665 14.1665 11.6665C12.5096 11.6665 11.1665 13.0096 11.1665 14.6665C11.1665 16.3234 12.5096 17.6665 14.1665 17.6665C15.8234 17.6665 17.1665 16.3234 17.1665 14.6665Z"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
								</svg>
								Job Listing
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="classified-ads" value="classified" />
							<label for="classified-ads">
								<svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20"
									fill="none">
									<path
										d="M5.37599 13.3332C2.93841 12.5838 1.1665 10.3143 1.1665 7.63103C1.1665 4.33691 3.83691 1.6665 7.13103 1.6665C9.81434 1.6665 12.0838 3.43841 12.8332 5.87599"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M4.87037 8.33333C4.6367 7.99102 4.5 7.57676 4.5 7.13044C4.5 5.95383 5.45006 5 6.62202 5C7.07232 5 7.48986 5.14081 7.83333 5.38098"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path d="M17.8333 11.1111L7 7.5L10.6111 18.3333L12.4167 12.9167L17.8333 11.1111Z"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
								</svg>
								Classified Ads
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="doctors-directory" value="doctors" />
							<label for="doctors-directory">
								<svg xmlns="http://www.w3.org/2000/svg" width="17" height="20" viewBox="0 0 17 20"
									fill="none">
									<path
										d="M9.33427 1.66699C10.2542 1.66699 11 2.44304 11 3.40035L11 5.41699L6 8.33366L1 5.41699L1 3.40017C1 2.44296 1.74569 1.66699 2.66555 1.66699"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M6.00024 11.667L6.00024 14.5835C6.00024 16.6547 7.6793 18.3337 9.75052 18.3337C11.8217 18.3337 13.5008 16.6547 13.5008 14.5835V13.3337"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M10.1668 5.8335L8.50016 10.0002L5.97483 11.6668L3.50016 10.0002L1.8335 5.8335"
										stroke="currentColor" stroke-width="1.5" />
									<path
										d="M16.0002 10.8335C16.0002 12.2142 14.881 13.3335 13.5002 13.3335C12.1195 13.3335 11.0002 12.2142 11.0002 10.8335C11.0002 9.45278 12.1195 8.3335 13.5002 8.3335C14.881 8.3335 16.0002 9.45278 16.0002 10.8335Z"
										stroke="currentColor" stroke-width="1.5" />
									<path d="M13.5068 10.8335L13.4993 10.8335" stroke="currentColor" stroke-width="2"
										stroke-linecap="round" stroke-linejoin="round" />
								</svg>
								Doctor Directory
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="lawyer-directory" value="lawyer" />
							<label for="lawyer-directory">
								<svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20"
									fill="none">
									<path
										d="M5.95841 11.4587C5.95841 11.4587 6.71297 10.4406 7.20841 10.2087C8.70411 9.50855 9.0083 9.20436 9.70841 7.70866C9.94033 7.21321 10.9584 6.45866 10.9584 6.45866M8.04175 13.542C8.04175 13.542 9.05984 12.7874 9.29175 12.292C9.99186 10.7963 10.2961 10.4921 11.7917 9.79199C12.2872 9.56008 13.0417 8.54199 13.0417 8.54199"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M2.75295 14.5835L2.03165 15.3048C1.43411 15.9023 1.43411 16.8711 2.03165 17.4687C2.62919 18.0662 3.59799 18.0662 4.19553 17.4687L4.91683 16.7474"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M14.0835 3.25295L14.8048 2.53165C15.4023 1.93411 16.3711 1.93411 16.9687 2.53165C17.5662 3.12919 17.5662 4.09799 16.9687 4.69553L16.2474 5.41683"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
									<path
										d="M14.9167 10.0003L14.3863 10.5307C14.6792 10.8235 15.1541 10.8235 15.447 10.5307L14.9167 10.0003ZM9.5 4.58366L8.96967 4.05333C8.82902 4.19398 8.75 4.38475 8.75 4.58366C8.75 4.78257 8.82902 4.97334 8.96967 5.11399L9.5 4.58366ZM12.4167 1.66699L12.947 1.13666C12.6541 0.843769 12.1792 0.843769 11.8863 1.13666L12.4167 1.66699ZM17.8333 7.08366L18.3637 7.61399C18.5043 7.47334 18.5833 7.28257 18.5833 7.08366C18.5833 6.88475 18.5043 6.69398 18.3637 6.55333L17.8333 7.08366ZM15.447 9.47L10.0303 4.05333L8.96967 5.11399L14.3863 10.5307L15.447 9.47ZM11.8863 2.19732L17.303 7.61399L18.3637 6.55333L12.947 1.13666L11.8863 2.19732ZM17.303 6.55333L14.3863 9.47L15.447 10.5307L18.3637 7.61399L17.303 6.55333ZM10.0303 5.11399L12.947 2.19732L11.8863 1.13666L8.96967 4.05333L10.0303 5.11399Z"
										fill="currentColor" />
									<path
										d="M6.58341 18.3333L6.05308 18.8637C6.34598 19.1566 6.82085 19.1566 7.11374 18.8637L6.58341 18.3333ZM1.16675 12.9167L0.636418 12.3863C0.343525 12.6792 0.343525 13.1541 0.636418 13.447L1.16675 12.9167ZM4.08341 10L4.61374 9.46967C4.47309 9.32902 4.28233 9.25 4.08341 9.25C3.8845 9.25 3.69374 9.32902 3.55308 9.46967L4.08341 10ZM9.50008 15.4167L10.0304 15.947C10.1711 15.8063 10.2501 15.6156 10.2501 15.4167C10.2501 15.2178 10.1711 15.027 10.0304 14.8863L9.50008 15.4167ZM7.11374 17.803L1.69708 12.3863L0.636418 13.447L6.05308 18.8637L7.11374 17.803ZM3.55308 10.5303L8.96975 15.947L10.0304 14.8863L4.61374 9.46967L3.55308 10.5303ZM8.96975 14.8863L6.05308 17.803L7.11374 18.8637L10.0304 15.947L8.96975 14.8863ZM1.69708 13.447L4.61374 10.5303L3.55308 9.46967L0.636418 12.3863L1.69708 13.447Z"
										fill="currentColor" />
								</svg>
								Lawyer Directory
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="realestate-Directory" value="realestate" />
							<label for="realestate-Directory">
								<svg xmlns="http://www.w3.org/2000/svg" width="15" height="18" viewBox="0 0 15 18"
									fill="none">
									<path d="M0 16.5L15 16.5" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path
										d="M8.33341 1.5L9.08341 1.5C9.08341 1.24689 8.95575 1.01086 8.74393 0.872321C8.5321 0.733784 8.26469 0.711432 8.0328 0.812882L8.33341 1.5ZM1.66675 4.41667L1.36613 3.72955L0.916748 3.92616L0.916748 4.41667H1.66675ZM8.0328 0.812882L1.36613 3.72955L1.96736 5.10378L8.63403 2.18712L8.0328 0.812882ZM0.916748 4.41667L0.916748 16.5H2.41675L2.41675 4.41667H0.916748ZM7.58341 1.5L7.58341 16.5H9.08341L9.08341 1.5L7.58341 1.5Z"
										fill="currentColor" />
									<path d="M13.3332 16.5002L13.3332 8.16686L8.26196 5.51953" stroke="currentColor"
										stroke-width="1.5" />
									<path d="M3.75 6.5L6.25 6.5M3.75 9.83333H6.25M3.75 13.1667H6.25"
										stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
								</svg>
								Real-estate Directory
							</label>
						</div>
						<div class="directorist-create-directory__checkbox">
							<input type="radio" name="directory_type[]" id="others" value="others" />
							<label for="others">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18"
									fill="none">
									<path d="M10.1667 2.3335L16.0001 2.3335" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path d="M10.1667 11.5L16.0001 11.5" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path d="M10.1667 6.5L16.0001 6.5" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<path d="M10.1667 15.6665L16.0001 15.6665" stroke="currentColor" stroke-width="1.5"
										stroke-linejoin="round" />
									<circle cx="3.91667" cy="4.41667" r="2.91667" stroke="currentColor"
										stroke-width="1.5" stroke-linejoin="round" />
									<circle cx="3.91667" cy="13.5832" r="2.91667" stroke="currentColor"
										stroke-width="1.5" stroke-linejoin="round" />
								</svg>
								Other’s
							</label>
						</div>
						<!-- Input for new type name -->
						<div id="directorist-create-directory__checkbox__others" class="directorist-create-directory__content__input-group directorist-create-directory__checkbox__others" style="display: none;">
							<span class="directorist-create-directory__content__input-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
									fill="none">
									<path fill-rule="evenodd" clip-rule="evenodd"
										d="M6.30668 2.5H14.6933C15.0589 2.49999 15.3743 2.49998 15.6353 2.51779C15.9102 2.53655 16.1851 2.5778 16.4567 2.6903C17.0693 2.94404 17.556 3.43072 17.8097 4.04329C17.9222 4.3149 17.9635 4.58982 17.9822 4.86468C18 5.12573 18 5.44114 18 5.80668V5.83333C18 6.29357 17.6269 6.66667 17.1667 6.66667C16.7064 6.66667 16.3333 6.29357 16.3333 5.83333C16.3333 5.43365 16.3329 5.17562 16.3194 4.97813C16.3064 4.78814 16.2843 4.71578 16.2699 4.6811C16.1853 4.47691 16.0231 4.31468 15.8189 4.2301C15.7842 4.21574 15.7119 4.19356 15.5219 4.18059C15.3244 4.16712 15.0664 4.16667 14.6667 4.16667H11.3333V15.8333H13C13.4602 15.8333 13.8333 16.2064 13.8333 16.6667C13.8333 17.1269 13.4602 17.5 13 17.5H8C7.53976 17.5 7.16667 17.1269 7.16667 16.6667C7.16667 16.2064 7.53976 15.8333 8 15.8333H9.66667V4.16667H6.33333C5.93365 4.16667 5.67562 4.16712 5.47813 4.18059C5.28814 4.19356 5.21578 4.21574 5.1811 4.2301C4.97691 4.31468 4.81468 4.47691 4.7301 4.6811C4.71574 4.71578 4.69356 4.78814 4.68059 4.97813C4.66712 5.17562 4.66667 5.43365 4.66667 5.83333C4.66667 6.29357 4.29357 6.66667 3.83333 6.66667C3.3731 6.66667 3 6.29357 3 5.83333L3 5.80668C2.99999 5.44114 2.99998 5.12573 3.01779 4.86468C3.03655 4.58982 3.0778 4.3149 3.1903 4.04329C3.44404 3.43072 3.93072 2.94404 4.54329 2.6903C4.8149 2.5778 5.08982 2.53655 5.36468 2.51779C5.62573 2.49998 5.94114 2.49999 6.30668 2.5Z"
										fill="currentColor" />
								</svg>
							</span>
							<input type="text" id="new-directory-type" class="form-control directorist-create-directory__content__input" name="new-directory-type" placeholder="New directory type" />
						</div>
					</div>
				</div>
				<div class="directorist-create-directory__content__form-group">
					<label class="directorist-create-directory__content__form-group-label" for="directorist-ai-prompt">
						Tell us about your directory
					</label>
					<div class="directorist-create-directory__content__input-group">
						<span class="directorist-create-directory__content__input-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24"
								fill="none">
								<path
									d="M5.00022 6C5.00022 5.80109 5.07924 5.61032 5.21989 5.46967C5.36055 5.32902 5.55131 5.25 5.75022 5.25H7.25022V3.75C7.25022 3.55109 7.32924 3.36032 7.46989 3.21967C7.61055 3.07902 7.80131 3 8.00022 3C8.19913 3 8.3899 3.07902 8.53055 3.21967C8.67121 3.36032 8.75022 3.55109 8.75022 3.75V5.25H10.2502C10.4491 5.25 10.6399 5.32902 10.7806 5.46967C10.9212 5.61032 11.0002 5.80109 11.0002 6C11.0002 6.19891 10.9212 6.38968 10.7806 6.53033C10.6399 6.67098 10.4491 6.75 10.2502 6.75H8.75022V8.25C8.75022 8.44891 8.67121 8.63968 8.53055 8.78033C8.3899 8.92098 8.19913 9 8.00022 9C7.80131 9 7.61055 8.92098 7.46989 8.78033C7.32924 8.63968 7.25022 8.44891 7.25022 8.25V6.75H5.75022C5.55131 6.75 5.36055 6.67098 5.21989 6.53033C5.07924 6.38968 5.00022 6.19891 5.00022 6ZM17.7502 18H17.0002V17.25C17.0002 17.0511 16.9212 16.8603 16.7806 16.7197C16.6399 16.579 16.4491 16.5 16.2502 16.5C16.0513 16.5 15.8605 16.579 15.7199 16.7197C15.5792 16.8603 15.5002 17.0511 15.5002 17.25V18H14.7502C14.5513 18 14.3605 18.079 14.2199 18.2197C14.0792 18.3603 14.0002 18.5511 14.0002 18.75C14.0002 18.9489 14.0792 19.1397 14.2199 19.2803C14.3605 19.421 14.5513 19.5 14.7502 19.5H15.5002V20.25C15.5002 20.4489 15.5792 20.6397 15.7199 20.7803C15.8605 20.921 16.0513 21 16.2502 21C16.4491 21 16.6399 20.921 16.7806 20.7803C16.9212 20.6397 17.0002 20.4489 17.0002 20.25V19.5H17.7502C17.9491 19.5 18.1399 19.421 18.2806 19.2803C18.4212 19.1397 18.5002 18.9489 18.5002 18.75C18.5002 18.5511 18.4212 18.3603 18.2806 18.2197C18.1399 18.079 17.9491 18 17.7502 18ZM23.0002 13.5H21.5002V12C21.5002 11.8011 21.4212 11.6103 21.2806 11.4697C21.1399 11.329 20.9491 11.25 20.7502 11.25C20.5513 11.25 20.3605 11.329 20.2199 11.4697C20.0792 11.6103 20.0002 11.8011 20.0002 12V13.5H18.5002C18.3013 13.5 18.1105 13.579 17.9699 13.7197C17.8292 13.8603 17.7502 14.0511 17.7502 14.25C17.7502 14.4489 17.8292 14.6397 17.9699 14.7803C18.1105 14.921 18.3013 15 18.5002 15H20.0002V16.5C20.0002 16.6989 20.0792 16.8897 20.2199 17.0303C20.3605 17.171 20.5513 17.25 20.7502 17.25C20.9491 17.25 21.1399 17.171 21.2806 17.0303C21.4212 16.8897 21.5002 16.6989 21.5002 16.5V15H23.0002C23.1991 15 23.3899 14.921 23.5306 14.7803C23.6712 14.6397 23.7502 14.4489 23.7502 14.25C23.7502 14.0511 23.6712 13.8603 23.5306 13.7197C23.3899 13.579 23.1991 13.5 23.0002 13.5ZM21.0605 7.5L8.00022 20.5603C7.71895 20.8414 7.33756 20.9993 6.93991 20.9993C6.54226 20.9993 6.16087 20.8414 5.8796 20.5603L3.93897 18.6216C3.79965 18.4823 3.68913 18.3169 3.61373 18.1349C3.53832 17.9529 3.49951 17.7578 3.49951 17.5608C3.49951 17.3638 3.53832 17.1687 3.61373 16.9867C3.68913 16.8047 3.79965 16.6393 3.93897 16.5L17.0002 3.43969C17.1395 3.30036 17.3049 3.18984 17.4869 3.11444C17.6689 3.03904 17.864 3.00023 18.061 3.00023C18.258 3.00023 18.4531 3.03904 18.6351 3.11444C18.8171 3.18984 18.9825 3.30036 19.1218 3.43969L21.0605 5.37844C21.1999 5.51773 21.3104 5.6831 21.3858 5.86511C21.4612 6.04713 21.5 6.24221 21.5 6.43922C21.5 6.63623 21.4612 6.83131 21.3858 7.01332C21.3104 7.19533 21.1999 7.36071 21.0605 7.5ZM15.939 10.5L14.0002 8.56031L5.00022 17.5603L6.93897 19.5L15.939 10.5ZM20.0002 6.43969L18.0605 4.5L15.0605 7.5L17.0002 9.43969L20.0002 6.43969Z"
									fill="currentColor" />
							</svg>
						</span>
						<textarea
							class="form-control directorist-create-directory__content__input --textarea directorist-ai-prompt"
							name="directorist-ai-prompt" id="directorist-ai-prompt"
							placeholder="Tell AI about your business to get better AI-powered suggestions..."></textarea>
						<span class="character-count">
							<span class="current-count">0</span>/
							<span class="max-count">500</span>
						</span>
					</div>
				</div>
			</div>

			<!-- Step 3 initial Page -->
			<div class="directorist-create-directory__content__items" data-step="3">
				<div class="directorist-box">
					<div class="directorist-box__item">
						<label class="directorist-box__label" for="directorist-tagList">Select keywords</label>
						<div class="directorist-box__input-wrapper">
							<ul id="directorist-box__tagList" class="directorist-box__tagList">
								<li><input type="text" id="directorist-box__newTag" class="directorist-box__input" placeholder="Add keyword..." /></li>
							</ul>
						</div>
						<div class="directorist-box-options__wrapper">
							<div class="directorist-box-options__left">
								After type
								<div class="directorist-box-options__hit-button">
									Hit
									<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
										fill="none">
										<path
											d="M3.00802 9.6002L5.67442 12.109C5.71266 12.145 5.74343 12.1882 5.76497 12.2362C5.78651 12.2841 5.7984 12.3358 5.79996 12.3883C5.80152 12.4408 5.79272 12.4932 5.77406 12.5423C5.75541 12.5914 5.72726 12.6364 5.69122 12.6746C5.65519 12.7128 5.61197 12.7436 5.56405 12.7651C5.51612 12.7867 5.46442 12.7986 5.4119 12.8001C5.35938 12.8017 5.30707 12.7929 5.25795 12.7742C5.20883 12.7556 5.16386 12.7274 5.12562 12.6914L1.72562 9.4914C1.68591 9.454 1.65427 9.40887 1.63264 9.3588C1.61101 9.30872 1.59985 9.25475 1.59985 9.2002C1.59985 9.14565 1.61101 9.09167 1.63264 9.0416C1.65427 8.99152 1.68591 8.94639 1.72562 8.909L5.12562 5.709C5.16386 5.67296 5.20883 5.64481 5.25795 5.62615C5.30707 5.6075 5.35938 5.5987 5.4119 5.60026C5.46442 5.60182 5.51612 5.61371 5.56405 5.63525C5.61197 5.65679 5.65519 5.68755 5.69122 5.7258C5.72726 5.76404 5.75541 5.809 5.77406 5.85812C5.79272 5.90724 5.80152 5.95955 5.79996 6.01207C5.7984 6.0646 5.78651 6.1163 5.76497 6.16422C5.74343 6.21215 5.71266 6.25536 5.67442 6.2914L3.00802 8.8002H12C12.4244 8.8002 12.8313 8.63162 13.1314 8.33157C13.4315 8.03151 13.6 7.62454 13.6 7.2002V3.6002C13.6 3.49411 13.6422 3.39237 13.7172 3.31735C13.7922 3.24234 13.8939 3.2002 14 3.2002C14.1061 3.2002 14.2079 3.24234 14.2829 3.31735C14.3579 3.39237 14.4 3.49411 14.4 3.6002V7.2002C14.4 7.83672 14.1472 8.44717 13.6971 8.89725C13.247 9.34734 12.6365 9.6002 12 9.6002H3.00802Z"
											fill="#141921"></path>
									</svg>
									<strong>
										Enter
									</strong>
								</div>
								to separate manual keyword
							</div>
							<div id="directorist-tagLimitMsg" class="directorist-box-options__right"
								style="display: none;">
								Max 5 <strong> | <span id="directorist-tagCount">0</span></strong>
							</div>
						</div>
					</div>
					<div class="directorist-box__item">
						<label class="directorist-box__label">Recommended keywords</label>
						<ul id="directorist-recommendedTags" class="directorist-box__recommended-list"></ul>
					</div>
				</div>
			</div>

			<!-- Generating Directory -->
			<div id="directorist-create-directory__generating" class="directorist-create-directory__generate">
				<div class="directory-img">
					<img id="directory-img__generating" src="<?php echo DIRECTORIST_ASSETS . '/images/directorist-ai-directory-transparent.gif'; ?>" alt="Directory AI is generating fields..." />
					<img id="directory-img__building" src="<?php echo DIRECTORIST_ASSETS . '/images/directorist-ai-directory-building.gif'; ?>" alt="Directory AI is building directory..." />
				</div>
				<h4 class="directory-title">Directory AI is generating fields... </h4>
				<p class="directory-description"><strong>Almost there!</strong> We're using your infomation to finalize your directory fields.</p>
				<div id="directory-generate-btn__progress" class="directory-generate-btn__wrapper" data-width="100">
					<div class="directory-generate-btn--bg" style="width: 0%;">
						<!-- Initial width set to 0% -->
					</div>
					<div class="directory-generate-btn__content">
						<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
							<path
								d="M15.9359 10.5828L11.9063 9.09375L10.4219 5.06094C10.334 4.82213 10.1749 4.61604 9.96622 4.47046C9.75751 4.32488 9.50916 4.24682 9.25469 4.24682C9.00022 4.24682 8.75187 4.32488 8.54316 4.47046C8.33444 4.61604 8.17541 4.82213 8.0875 5.06094L6.59375 9.09375L2.56094 10.5781C2.32213 10.666 2.11604 10.8251 1.97046 11.0338C1.82488 11.2425 1.74683 11.4908 1.74683 11.7453C1.74683 11.9998 1.82488 12.2481 1.97046 12.4568C2.11604 12.6656 2.32213 12.8246 2.56094 12.9125L6.59375 14.4062L8.07813 18.4391C8.16603 18.6779 8.32507 18.884 8.53378 19.0295C8.7425 19.1751 8.99085 19.2532 9.24532 19.2532C9.49979 19.2532 9.74813 19.1751 9.95685 19.0295C10.1656 18.884 10.3246 18.6779 10.4125 18.4391L11.9063 14.4062L15.9391 12.9219C16.1779 12.834 16.384 12.6749 16.5295 12.4662C16.6751 12.2575 16.7532 12.0092 16.7532 11.7547C16.7532 11.5002 16.6751 11.2519 16.5295 11.0432C16.384 10.8344 16.1779 10.6754 15.9391 10.5875L15.9359 10.5828ZM11.2031 13.3297C11.1183 13.361 11.0412 13.4103 10.9773 13.4742C10.9134 13.5381 10.8641 13.6152 10.8328 13.7L9.25 17.9883L7.67031 13.7031C7.6391 13.6174 7.58949 13.5395 7.52498 13.475C7.46046 13.4105 7.38261 13.3609 7.29688 13.3297L3.01172 11.75L7.29688 10.1703C7.38261 10.1391 7.46046 10.0895 7.52498 10.025C7.58949 9.96046 7.6391 9.8826 7.67031 9.79688L9.25 5.51172L10.8297 9.79688C10.861 9.88171 10.9103 9.95875 10.9742 10.0227C11.0381 10.0866 11.1152 10.1359 11.2 10.1672L15.4883 11.75L11.2031 13.3297ZM11.75 3.625C11.75 3.45924 11.8158 3.30027 11.9331 3.18306C12.0503 3.06585 12.2092 3 12.375 3H13.625V1.75C13.625 1.58424 13.6908 1.42527 13.8081 1.30806C13.9253 1.19085 14.0842 1.125 14.25 1.125C14.4158 1.125 14.5747 1.19085 14.6919 1.30806C14.8092 1.42527 14.875 1.58424 14.875 1.75V3H16.125C16.2908 3 16.4497 3.06585 16.5669 3.18306C16.6842 3.30027 16.75 3.45924 16.75 3.625C16.75 3.79076 16.6842 3.94973 16.5669 4.06694C16.4497 4.18415 16.2908 4.25 16.125 4.25H14.875V5.5C14.875 5.66576 14.8092 5.82473 14.6919 5.94194C14.5747 6.05915 14.4158 6.125 14.25 6.125C14.0842 6.125 13.9253 6.05915 13.8081 5.94194C13.6908 5.82473 13.625 5.66576 13.625 5.5V4.25H12.375C12.2092 4.25 12.0503 4.18415 11.9331 4.06694C11.8158 3.94973 11.75 3.79076 11.75 3.625ZM19.875 7.375C19.875 7.54076 19.8092 7.69973 19.6919 7.81694C19.5747 7.93415 19.4158 8 19.25 8H18.625V8.625C18.625 8.79076 18.5592 8.94973 18.4419 9.06694C18.3247 9.18415 18.1658 9.25 18 9.25C17.8342 9.25 17.6753 9.18415 17.5581 9.06694C17.4408 8.94973 17.375 8.79076 17.375 8.625V8H16.75C16.5842 8 16.4253 7.93415 16.3081 7.81694C16.1908 7.69973 16.125 7.54076 16.125 7.375C16.125 7.20924 16.1908 7.05027 16.3081 6.93306C16.4253 6.81585 16.5842 6.75 16.75 6.75H17.375V6.125C17.375 5.95924 17.4408 5.80027 17.5581 5.68306C17.6753 5.56585 17.8342 5.5 18 5.5C18.1658 5.5 18.3247 5.56585 18.4419 5.68306C18.5592 5.80027 18.625 5.95924 18.625 6.125V6.75H19.25C19.4158 6.75 19.5747 6.81585 19.6919 6.93306C19.8092 7.05027 19.875 7.20924 19.875 7.375Z"
								fill="url(#paint0_linear_5661_2975)"></path>
							<defs>
								<linearGradient id="paint0_linear_5661_2975" x1="10.8109" y1="1.125" x2="10.8109"
									y2="19.2532" gradientUnits="userSpaceOnUse">
									<stop stop-color="#E7B9EB"></stop>
									<stop offset="1" stop-color="#092AAF"></stop>
								</linearGradient>
							</defs>
						</svg>
						<span id="directory-generate-btn__content__text">Fields are being generated... </span><span class="directory-generate-btn__percentage">0%</span>
					</div>
				</div>
			</div>

			<!-- Generate Field -->
			<div id="directorist-create-directory__ai-fields" class="directorist-ai-generate-box">
				<div class="directorist-ai-generate-box__header">
					<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
						<path
							d="M30.8719 20.1656L22.8125 17.1875L19.8438 9.12188C19.6679 8.64426 19.3499 8.23207 18.9324 7.94092C18.515 7.64976 18.0183 7.49365 17.5094 7.49365C17.0004 7.49365 16.5037 7.64976 16.0863 7.94092C15.6689 8.23207 15.3508 8.64426 15.175 9.12188L12.1875 17.1875L4.12188 20.1562C3.64427 20.3321 3.23208 20.6501 2.94092 21.0676C2.64976 21.485 2.49365 21.9817 2.49365 22.4906C2.49365 22.9996 2.64976 23.4963 2.94092 23.9137C3.23208 24.3311 3.64427 24.6492 4.12188 24.825L12.1875 27.8125L15.1563 35.8781C15.3321 36.3557 15.6501 36.7679 16.0676 37.0591C16.485 37.3502 16.9817 37.5064 17.4906 37.5064C17.9996 37.5064 18.4963 37.3502 18.9137 37.0591C19.3311 36.7679 19.6492 36.3557 19.825 35.8781L22.8125 27.8125L30.8781 24.8438C31.3557 24.6679 31.7679 24.3499 32.0591 23.9324C32.3502 23.515 32.5064 23.0183 32.5064 22.5094C32.5064 22.0004 32.3502 21.5037 32.0591 21.0863C31.7679 20.6689 31.3557 20.3508 30.8781 20.175L30.8719 20.1656ZM21.4063 25.6594C21.2366 25.7219 21.0825 25.8205 20.9546 25.9484C20.8268 26.0762 20.7282 26.2303 20.6656 26.4L17.5 34.9766L14.3406 26.4062C14.2782 26.2348 14.179 26.0791 14.05 25.9501C13.9209 25.821 13.7652 25.7218 13.5938 25.6594L5.02344 22.5L13.5938 19.3406C13.7652 19.2782 13.9209 19.179 14.05 19.0499C14.179 18.9209 14.2782 18.7652 14.3406 18.5938L17.5 10.0234L20.6594 18.5938C20.7219 18.7634 20.8205 18.9175 20.9484 19.0454C21.0762 19.1732 21.2303 19.2718 21.4 19.3344L29.9766 22.5L21.4063 25.6594ZM22.5 6.25C22.5 5.91848 22.6317 5.60054 22.8661 5.36612C23.1005 5.1317 23.4185 5 23.75 5H26.25V2.5C26.25 2.16848 26.3817 1.85054 26.6161 1.61612C26.8505 1.3817 27.1685 1.25 27.5 1.25C27.8315 1.25 28.1495 1.3817 28.3839 1.61612C28.6183 1.85054 28.75 2.16848 28.75 2.5V5H31.25C31.5815 5 31.8995 5.1317 32.1339 5.36612C32.3683 5.60054 32.5 5.91848 32.5 6.25C32.5 6.58152 32.3683 6.89946 32.1339 7.13388C31.8995 7.3683 31.5815 7.5 31.25 7.5H28.75V10C28.75 10.3315 28.6183 10.6495 28.3839 10.8839C28.1495 11.1183 27.8315 11.25 27.5 11.25C27.1685 11.25 26.8505 11.1183 26.6161 10.8839C26.3817 10.6495 26.25 10.3315 26.25 10V7.5H23.75C23.4185 7.5 23.1005 7.3683 22.8661 7.13388C22.6317 6.89946 22.5 6.58152 22.5 6.25ZM38.75 13.75C38.75 14.0815 38.6183 14.3995 38.3839 14.6339C38.1495 14.8683 37.8315 15 37.5 15H36.25V16.25C36.25 16.5815 36.1183 16.8995 35.8839 17.1339C35.6495 17.3683 35.3315 17.5 35 17.5C34.6685 17.5 34.3505 17.3683 34.1161 17.1339C33.8817 16.8995 33.75 16.5815 33.75 16.25V15H32.5C32.1685 15 31.8505 14.8683 31.6161 14.6339C31.3817 14.3995 31.25 14.0815 31.25 13.75C31.25 13.4185 31.3817 13.1005 31.6161 12.8661C31.8505 12.6317 32.1685 12.5 32.5 12.5H33.75V11.25C33.75 10.9185 33.8817 10.6005 34.1161 10.3661C34.3505 10.1317 34.6685 10 35 10C35.3315 10 35.6495 10.1317 35.8839 10.3661C36.1183 10.6005 36.25 10.9185 36.25 11.25V12.5H37.5C37.8315 12.5 38.1495 12.6317 38.3839 12.8661C38.6183 13.1005 38.75 13.4185 38.75 13.75Z"
							fill="url(#paint0_linear_5814_7815)" />
						<defs>
							<linearGradient id="paint0_linear_5814_7815" x1="20.6218" y1="1.25" x2="20.6218"
								y2="37.5064" gradientUnits="userSpaceOnUse">
								<stop stop-color="#E7B9EB" />
								<stop offset="1" stop-color="#092AAF" />
							</linearGradient>
						</defs>
					</svg>
					<div class="directorist-ai-generate-box__title">
						<h6>AI-generate <span class="fields-count">12</span> fields</h6>
						<p>Pin items or regenerate up to 1 time</p>
					</div>
				</div>
				<div class="directorist-ai-generate-box__items" id="directorist_ai_generated_fields"></div>
				<input type="hidden" id="directorist-ai-generated-fields-array">
			</div>

			<div id="directorist-create-directory__creating" class="directory-generate-progress-list">
				<ul>
					<li data-type="completed">
						<div class="completed-icon" style="display: none;">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<g clip-path="url(#clip0_5681_2445)">
									<path
										d="M20.2803 9.96094C20.2803 15.4004 15.7686 19.9219 10.3193 19.9219C4.87988 19.9219 0.358398 15.4004 0.358398 9.96094C0.358398 4.51172 4.87012 0 10.3096 0C15.7588 0 20.2803 4.51172 20.2803 9.96094ZM13.3564 6.08398L9.18652 12.7832L7.2041 10.2246C6.95996 9.90234 6.74512 9.81445 6.46192 9.81445C6.02246 9.81445 5.68067 10.1758 5.68067 10.6152C5.68067 10.8398 5.76856 11.0547 5.91504 11.25L8.36621 14.2578C8.62012 14.5996 8.89356 14.7363 9.22559 14.7363C9.55762 14.7363 9.84082 14.5801 10.0459 14.2578L14.6357 7.03125C14.7529 6.82617 14.8799 6.60156 14.8799 6.38672C14.8799 5.92773 14.4795 5.63477 14.0498 5.63477C13.7959 5.63477 13.542 5.79102 13.3564 6.08398Z"
										fill="#14B570" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2445">
										<rect width="20.2832" height="19.9316" fill="white"
											transform="translate(0.358398)" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="progress-icon" style="display: none;">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
								fill="none">
								<g clip-path="url(#clip0_5681_2451)">
									<path
										d="M7.5 2.49988C7.49247 2.16696 7.55153 1.83588 7.67371 1.5261C7.7959 1.21631 7.97874 0.934062 8.2115 0.695913C8.44427 0.457764 8.72227 0.268519 9.02918 0.139287C9.33609 0.0100556 9.66573 -0.0565573 9.99874 -0.0566405C10.3317 -0.0567238 10.6614 0.00972416 10.9684 0.138802C11.2754 0.26788 11.5535 0.456987 11.7863 0.695019C12.0192 0.933051 12.2022 1.21521 12.3245 1.52494C12.4469 1.83466 12.5061 2.1657 12.4987 2.49863C12.4843 3.15183 12.2147 3.77342 11.7477 4.23034C11.2807 4.68726 10.6533 4.9432 9.99999 4.94336C9.34663 4.94352 8.71916 4.6879 8.25191 4.23122C7.78467 3.77453 7.51477 3.15307 7.5 2.49988ZM12.8038 4.69613C12.7962 4.36321 12.8553 4.03213 12.9775 3.72235C13.0996 3.41256 13.2825 3.13031 13.5153 2.89216C13.748 2.65401 14.026 2.46477 14.3329 2.33554C14.6398 2.20631 14.9695 2.13969 15.3025 2.13961C15.6355 2.13953 15.9652 2.20597 16.2721 2.33505C16.5791 2.46413 16.8572 2.65324 17.0901 2.89127C17.323 3.1293 17.506 3.41146 17.6283 3.72119C17.7506 4.03091 17.8099 4.36195 17.8025 4.69488C17.7881 5.34808 17.5185 5.96967 17.0515 6.42659C16.5844 6.88351 15.9571 7.13945 15.3037 7.13961C14.6504 7.13977 14.0229 6.88415 13.5557 6.42747C13.0884 5.97078 12.8185 5.34932 12.8038 4.69613ZM16.25 9.99988C16.25 9.66836 16.3817 9.35042 16.6161 9.116C16.8505 8.88158 17.1685 8.74988 17.5 8.74988C17.8315 8.74988 18.1495 8.88158 18.3839 9.116C18.6183 9.35042 18.75 9.66836 18.75 9.99988C18.75 10.3314 18.6183 10.6493 18.3839 10.8838C18.1495 11.1182 17.8315 11.2499 17.5 11.2499C17.1685 11.2499 16.8505 11.1182 16.6161 10.8838C16.3817 10.6493 16.25 10.3314 16.25 9.99988ZM14.0538 15.3036C14.0538 14.9721 14.1854 14.6542 14.4199 14.4197C14.6543 14.1853 14.9722 14.0536 15.3038 14.0536C15.6353 14.0536 15.9532 14.1853 16.1876 14.4197C16.4221 14.6542 16.5538 14.9721 16.5538 15.3036C16.5538 15.6352 16.4221 15.9531 16.1876 16.1875C15.9532 16.4219 15.6353 16.5536 15.3038 16.5536C14.9722 16.5536 14.6543 16.4219 14.4199 16.1875C14.1854 15.9531 14.0538 15.6352 14.0538 15.3036ZM8.75 17.4999C8.75 17.1684 8.8817 16.8504 9.11612 16.616C9.35054 16.3816 9.66848 16.2499 10 16.2499C10.3315 16.2499 10.6495 16.3816 10.8839 16.616C11.1183 16.8504 11.25 17.1684 11.25 17.4999C11.25 17.8314 11.1183 18.1493 10.8839 18.3838C10.6495 18.6182 10.3315 18.7499 10 18.7499C9.66848 18.7499 9.35054 18.6182 9.11612 18.3838C8.8817 18.1493 8.75 17.8314 8.75 17.4999ZM3.44625 15.3036C3.44625 14.9721 3.57795 14.6542 3.81237 14.4197C4.04679 14.1853 4.36473 14.0536 4.69625 14.0536C5.02777 14.0536 5.34571 14.1853 5.58013 14.4197C5.81455 14.6542 5.94625 14.9721 5.94625 15.3036C5.94625 15.6352 5.81455 15.9531 5.58013 16.1875C5.34571 16.4219 5.02777 16.5536 4.69625 16.5536C4.36473 16.5536 4.04679 16.4219 3.81237 16.1875C3.57795 15.9531 3.44625 15.6352 3.44625 15.3036ZM2.82125 4.69613C2.82125 4.19885 3.01879 3.72194 3.37042 3.3703C3.72206 3.01867 4.19897 2.82113 4.69625 2.82113C5.19353 2.82113 5.67044 3.01867 6.02208 3.3703C6.37371 3.72194 6.57125 4.19885 6.57125 4.69613C6.57125 5.19341 6.37371 5.67032 6.02208 6.02196C5.67044 6.37359 5.19353 6.57113 4.69625 6.57113C4.19897 6.57113 3.72206 6.37359 3.37042 6.02196C3.01879 5.67032 2.82125 5.19341 2.82125 4.69613ZM1.09375 9.99988C1.09375 9.62692 1.24191 9.26923 1.50563 9.00551C1.76935 8.74179 2.12704 8.59363 2.5 8.59363C2.87296 8.59363 3.23065 8.74179 3.49437 9.00551C3.75809 9.26923 3.90625 9.62692 3.90625 9.99988C3.90625 10.3728 3.75809 10.7305 3.49437 10.9942C3.23065 11.258 2.87296 11.4061 2.5 11.4061C2.12704 11.4061 1.76935 11.258 1.50563 10.9942C1.24191 10.7305 1.09375 10.3728 1.09375 9.99988Z"
										fill="#79E6B0" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2451">
										<rect width="20" height="20" fill="white" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="default-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<g opacity="0.4" clip-path="url(#clip0_5681_2455)">
									<path
										d="M10.3193 19.9561C15.7686 19.9561 20.2803 15.4346 20.2803 9.99512C20.2803 4.5459 15.7588 0.0341797 10.3096 0.0341797C4.87012 0.0341797 0.358398 4.5459 0.358398 9.99512C0.358398 15.4346 4.87988 19.9561 10.3193 19.9561ZM10.3193 18.2959C5.70996 18.2959 2.02832 14.6045 2.02832 9.99512C2.02832 5.38574 5.7002 1.69434 10.3096 1.69434C14.9189 1.69434 18.6201 5.38574 18.6201 9.99512C18.6201 14.6045 14.9287 18.2959 10.3193 18.2959Z"
										fill="#A1A9B2" />
									<path
										d="M9.24512 14.6338C9.56738 14.6338 9.84082 14.4776 10.0361 14.1748L14.499 7.15332C14.6064 6.95801 14.7334 6.74316 14.7334 6.52832C14.7334 6.08887 14.3428 5.80566 13.9326 5.80566C13.6885 5.80566 13.4443 5.96191 13.2588 6.24512L9.20606 12.749L7.28223 10.2588C7.04785 9.94629 6.83301 9.86816 6.55957 9.86816C6.13965 9.86816 5.80762 10.21 5.80762 10.6397C5.80762 10.8545 5.89551 11.0596 6.03223 11.2451L8.41504 14.1748C8.65918 14.4971 8.92285 14.6338 9.24512 14.6338Z"
										fill="#A1A9B2" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2455">
										<rect width="20.2832" height="19.9316" fill="white"
											transform="translate(0.358398 0.0341797)" />
									</clipPath>
								</defs>
							</svg>
						</div>
						Collecting you business informations.
					</li>
					<li data-type="progress">
						<div class="completed-icon" style="display: none;">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<g clip-path="url(#clip0_5681_2445)">
									<path
										d="M20.2803 9.96094C20.2803 15.4004 15.7686 19.9219 10.3193 19.9219C4.87988 19.9219 0.358398 15.4004 0.358398 9.96094C0.358398 4.51172 4.87012 0 10.3096 0C15.7588 0 20.2803 4.51172 20.2803 9.96094ZM13.3564 6.08398L9.18652 12.7832L7.2041 10.2246C6.95996 9.90234 6.74512 9.81445 6.46192 9.81445C6.02246 9.81445 5.68067 10.1758 5.68067 10.6152C5.68067 10.8398 5.76856 11.0547 5.91504 11.25L8.36621 14.2578C8.62012 14.5996 8.89356 14.7363 9.22559 14.7363C9.55762 14.7363 9.84082 14.5801 10.0459 14.2578L14.6357 7.03125C14.7529 6.82617 14.8799 6.60156 14.8799 6.38672C14.8799 5.92773 14.4795 5.63477 14.0498 5.63477C13.7959 5.63477 13.542 5.79102 13.3564 6.08398Z"
										fill="#14B570" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2445">
										<rect width="20.2832" height="19.9316" fill="white"
											transform="translate(0.358398)" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="progress-icon" style="display: none;">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
								fill="none">
								<g clip-path="url(#clip0_5681_2451)">
									<path
										d="M7.5 2.49988C7.49247 2.16696 7.55153 1.83588 7.67371 1.5261C7.7959 1.21631 7.97874 0.934062 8.2115 0.695913C8.44427 0.457764 8.72227 0.268519 9.02918 0.139287C9.33609 0.0100556 9.66573 -0.0565573 9.99874 -0.0566405C10.3317 -0.0567238 10.6614 0.00972416 10.9684 0.138802C11.2754 0.26788 11.5535 0.456987 11.7863 0.695019C12.0192 0.933051 12.2022 1.21521 12.3245 1.52494C12.4469 1.83466 12.5061 2.1657 12.4987 2.49863C12.4843 3.15183 12.2147 3.77342 11.7477 4.23034C11.2807 4.68726 10.6533 4.9432 9.99999 4.94336C9.34663 4.94352 8.71916 4.6879 8.25191 4.23122C7.78467 3.77453 7.51477 3.15307 7.5 2.49988ZM12.8038 4.69613C12.7962 4.36321 12.8553 4.03213 12.9775 3.72235C13.0996 3.41256 13.2825 3.13031 13.5153 2.89216C13.748 2.65401 14.026 2.46477 14.3329 2.33554C14.6398 2.20631 14.9695 2.13969 15.3025 2.13961C15.6355 2.13953 15.9652 2.20597 16.2721 2.33505C16.5791 2.46413 16.8572 2.65324 17.0901 2.89127C17.323 3.1293 17.506 3.41146 17.6283 3.72119C17.7506 4.03091 17.8099 4.36195 17.8025 4.69488C17.7881 5.34808 17.5185 5.96967 17.0515 6.42659C16.5844 6.88351 15.9571 7.13945 15.3037 7.13961C14.6504 7.13977 14.0229 6.88415 13.5557 6.42747C13.0884 5.97078 12.8185 5.34932 12.8038 4.69613ZM16.25 9.99988C16.25 9.66836 16.3817 9.35042 16.6161 9.116C16.8505 8.88158 17.1685 8.74988 17.5 8.74988C17.8315 8.74988 18.1495 8.88158 18.3839 9.116C18.6183 9.35042 18.75 9.66836 18.75 9.99988C18.75 10.3314 18.6183 10.6493 18.3839 10.8838C18.1495 11.1182 17.8315 11.2499 17.5 11.2499C17.1685 11.2499 16.8505 11.1182 16.6161 10.8838C16.3817 10.6493 16.25 10.3314 16.25 9.99988ZM14.0538 15.3036C14.0538 14.9721 14.1854 14.6542 14.4199 14.4197C14.6543 14.1853 14.9722 14.0536 15.3038 14.0536C15.6353 14.0536 15.9532 14.1853 16.1876 14.4197C16.4221 14.6542 16.5538 14.9721 16.5538 15.3036C16.5538 15.6352 16.4221 15.9531 16.1876 16.1875C15.9532 16.4219 15.6353 16.5536 15.3038 16.5536C14.9722 16.5536 14.6543 16.4219 14.4199 16.1875C14.1854 15.9531 14.0538 15.6352 14.0538 15.3036ZM8.75 17.4999C8.75 17.1684 8.8817 16.8504 9.11612 16.616C9.35054 16.3816 9.66848 16.2499 10 16.2499C10.3315 16.2499 10.6495 16.3816 10.8839 16.616C11.1183 16.8504 11.25 17.1684 11.25 17.4999C11.25 17.8314 11.1183 18.1493 10.8839 18.3838C10.6495 18.6182 10.3315 18.7499 10 18.7499C9.66848 18.7499 9.35054 18.6182 9.11612 18.3838C8.8817 18.1493 8.75 17.8314 8.75 17.4999ZM3.44625 15.3036C3.44625 14.9721 3.57795 14.6542 3.81237 14.4197C4.04679 14.1853 4.36473 14.0536 4.69625 14.0536C5.02777 14.0536 5.34571 14.1853 5.58013 14.4197C5.81455 14.6542 5.94625 14.9721 5.94625 15.3036C5.94625 15.6352 5.81455 15.9531 5.58013 16.1875C5.34571 16.4219 5.02777 16.5536 4.69625 16.5536C4.36473 16.5536 4.04679 16.4219 3.81237 16.1875C3.57795 15.9531 3.44625 15.6352 3.44625 15.3036ZM2.82125 4.69613C2.82125 4.19885 3.01879 3.72194 3.37042 3.3703C3.72206 3.01867 4.19897 2.82113 4.69625 2.82113C5.19353 2.82113 5.67044 3.01867 6.02208 3.3703C6.37371 3.72194 6.57125 4.19885 6.57125 4.69613C6.57125 5.19341 6.37371 5.67032 6.02208 6.02196C5.67044 6.37359 5.19353 6.57113 4.69625 6.57113C4.19897 6.57113 3.72206 6.37359 3.37042 6.02196C3.01879 5.67032 2.82125 5.19341 2.82125 4.69613ZM1.09375 9.99988C1.09375 9.62692 1.24191 9.26923 1.50563 9.00551C1.76935 8.74179 2.12704 8.59363 2.5 8.59363C2.87296 8.59363 3.23065 8.74179 3.49437 9.00551C3.75809 9.26923 3.90625 9.62692 3.90625 9.99988C3.90625 10.3728 3.75809 10.7305 3.49437 10.9942C3.23065 11.258 2.87296 11.4061 2.5 11.4061C2.12704 11.4061 1.76935 11.258 1.50563 10.9942C1.24191 10.7305 1.09375 10.3728 1.09375 9.99988Z"
										fill="#79E6B0" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2451">
										<rect width="20" height="20" fill="white" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="default-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<g opacity="0.4" clip-path="url(#clip0_5681_2455)">
									<path
										d="M10.3193 19.9561C15.7686 19.9561 20.2803 15.4346 20.2803 9.99512C20.2803 4.5459 15.7588 0.0341797 10.3096 0.0341797C4.87012 0.0341797 0.358398 4.5459 0.358398 9.99512C0.358398 15.4346 4.87988 19.9561 10.3193 19.9561ZM10.3193 18.2959C5.70996 18.2959 2.02832 14.6045 2.02832 9.99512C2.02832 5.38574 5.7002 1.69434 10.3096 1.69434C14.9189 1.69434 18.6201 5.38574 18.6201 9.99512C18.6201 14.6045 14.9287 18.2959 10.3193 18.2959Z"
										fill="#A1A9B2" />
									<path
										d="M9.24512 14.6338C9.56738 14.6338 9.84082 14.4776 10.0361 14.1748L14.499 7.15332C14.6064 6.95801 14.7334 6.74316 14.7334 6.52832C14.7334 6.08887 14.3428 5.80566 13.9326 5.80566C13.6885 5.80566 13.4443 5.96191 13.2588 6.24512L9.20606 12.749L7.28223 10.2588C7.04785 9.94629 6.83301 9.86816 6.55957 9.86816C6.13965 9.86816 5.80762 10.21 5.80762 10.6397C5.80762 10.8545 5.89551 11.0596 6.03223 11.2451L8.41504 14.1748C8.65918 14.4971 8.92285 14.6338 9.24512 14.6338Z"
										fill="#A1A9B2" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2455">
										<rect width="20.2832" height="19.9316" fill="white"
											transform="translate(0.358398 0.0341797)" />
									</clipPath>
								</defs>
							</svg>
						</div>
						Optimize directory with keywords for better content
					</li>
					<li data-type="default">
						<div class="completed-icon" style="display: none;">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<g clip-path="url(#clip0_5681_2445)">
									<path
										d="M20.2803 9.96094C20.2803 15.4004 15.7686 19.9219 10.3193 19.9219C4.87988 19.9219 0.358398 15.4004 0.358398 9.96094C0.358398 4.51172 4.87012 0 10.3096 0C15.7588 0 20.2803 4.51172 20.2803 9.96094ZM13.3564 6.08398L9.18652 12.7832L7.2041 10.2246C6.95996 9.90234 6.74512 9.81445 6.46192 9.81445C6.02246 9.81445 5.68067 10.1758 5.68067 10.6152C5.68067 10.8398 5.76856 11.0547 5.91504 11.25L8.36621 14.2578C8.62012 14.5996 8.89356 14.7363 9.22559 14.7363C9.55762 14.7363 9.84082 14.5801 10.0459 14.2578L14.6357 7.03125C14.7529 6.82617 14.8799 6.60156 14.8799 6.38672C14.8799 5.92773 14.4795 5.63477 14.0498 5.63477C13.7959 5.63477 13.542 5.79102 13.3564 6.08398Z"
										fill="#14B570" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2445">
										<rect width="20.2832" height="19.9316" fill="white"
											transform="translate(0.358398)" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="progress-icon" style="display: none;">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
								fill="none">
								<g clip-path="url(#clip0_5681_2451)">
									<path
										d="M7.5 2.49988C7.49247 2.16696 7.55153 1.83588 7.67371 1.5261C7.7959 1.21631 7.97874 0.934062 8.2115 0.695913C8.44427 0.457764 8.72227 0.268519 9.02918 0.139287C9.33609 0.0100556 9.66573 -0.0565573 9.99874 -0.0566405C10.3317 -0.0567238 10.6614 0.00972416 10.9684 0.138802C11.2754 0.26788 11.5535 0.456987 11.7863 0.695019C12.0192 0.933051 12.2022 1.21521 12.3245 1.52494C12.4469 1.83466 12.5061 2.1657 12.4987 2.49863C12.4843 3.15183 12.2147 3.77342 11.7477 4.23034C11.2807 4.68726 10.6533 4.9432 9.99999 4.94336C9.34663 4.94352 8.71916 4.6879 8.25191 4.23122C7.78467 3.77453 7.51477 3.15307 7.5 2.49988ZM12.8038 4.69613C12.7962 4.36321 12.8553 4.03213 12.9775 3.72235C13.0996 3.41256 13.2825 3.13031 13.5153 2.89216C13.748 2.65401 14.026 2.46477 14.3329 2.33554C14.6398 2.20631 14.9695 2.13969 15.3025 2.13961C15.6355 2.13953 15.9652 2.20597 16.2721 2.33505C16.5791 2.46413 16.8572 2.65324 17.0901 2.89127C17.323 3.1293 17.506 3.41146 17.6283 3.72119C17.7506 4.03091 17.8099 4.36195 17.8025 4.69488C17.7881 5.34808 17.5185 5.96967 17.0515 6.42659C16.5844 6.88351 15.9571 7.13945 15.3037 7.13961C14.6504 7.13977 14.0229 6.88415 13.5557 6.42747C13.0884 5.97078 12.8185 5.34932 12.8038 4.69613ZM16.25 9.99988C16.25 9.66836 16.3817 9.35042 16.6161 9.116C16.8505 8.88158 17.1685 8.74988 17.5 8.74988C17.8315 8.74988 18.1495 8.88158 18.3839 9.116C18.6183 9.35042 18.75 9.66836 18.75 9.99988C18.75 10.3314 18.6183 10.6493 18.3839 10.8838C18.1495 11.1182 17.8315 11.2499 17.5 11.2499C17.1685 11.2499 16.8505 11.1182 16.6161 10.8838C16.3817 10.6493 16.25 10.3314 16.25 9.99988ZM14.0538 15.3036C14.0538 14.9721 14.1854 14.6542 14.4199 14.4197C14.6543 14.1853 14.9722 14.0536 15.3038 14.0536C15.6353 14.0536 15.9532 14.1853 16.1876 14.4197C16.4221 14.6542 16.5538 14.9721 16.5538 15.3036C16.5538 15.6352 16.4221 15.9531 16.1876 16.1875C15.9532 16.4219 15.6353 16.5536 15.3038 16.5536C14.9722 16.5536 14.6543 16.4219 14.4199 16.1875C14.1854 15.9531 14.0538 15.6352 14.0538 15.3036ZM8.75 17.4999C8.75 17.1684 8.8817 16.8504 9.11612 16.616C9.35054 16.3816 9.66848 16.2499 10 16.2499C10.3315 16.2499 10.6495 16.3816 10.8839 16.616C11.1183 16.8504 11.25 17.1684 11.25 17.4999C11.25 17.8314 11.1183 18.1493 10.8839 18.3838C10.6495 18.6182 10.3315 18.7499 10 18.7499C9.66848 18.7499 9.35054 18.6182 9.11612 18.3838C8.8817 18.1493 8.75 17.8314 8.75 17.4999ZM3.44625 15.3036C3.44625 14.9721 3.57795 14.6542 3.81237 14.4197C4.04679 14.1853 4.36473 14.0536 4.69625 14.0536C5.02777 14.0536 5.34571 14.1853 5.58013 14.4197C5.81455 14.6542 5.94625 14.9721 5.94625 15.3036C5.94625 15.6352 5.81455 15.9531 5.58013 16.1875C5.34571 16.4219 5.02777 16.5536 4.69625 16.5536C4.36473 16.5536 4.04679 16.4219 3.81237 16.1875C3.57795 15.9531 3.44625 15.6352 3.44625 15.3036ZM2.82125 4.69613C2.82125 4.19885 3.01879 3.72194 3.37042 3.3703C3.72206 3.01867 4.19897 2.82113 4.69625 2.82113C5.19353 2.82113 5.67044 3.01867 6.02208 3.3703C6.37371 3.72194 6.57125 4.19885 6.57125 4.69613C6.57125 5.19341 6.37371 5.67032 6.02208 6.02196C5.67044 6.37359 5.19353 6.57113 4.69625 6.57113C4.19897 6.57113 3.72206 6.37359 3.37042 6.02196C3.01879 5.67032 2.82125 5.19341 2.82125 4.69613ZM1.09375 9.99988C1.09375 9.62692 1.24191 9.26923 1.50563 9.00551C1.76935 8.74179 2.12704 8.59363 2.5 8.59363C2.87296 8.59363 3.23065 8.74179 3.49437 9.00551C3.75809 9.26923 3.90625 9.62692 3.90625 9.99988C3.90625 10.3728 3.75809 10.7305 3.49437 10.9942C3.23065 11.258 2.87296 11.4061 2.5 11.4061C2.12704 11.4061 1.76935 11.258 1.50563 10.9942C1.24191 10.7305 1.09375 10.3728 1.09375 9.99988Z"
										fill="#79E6B0" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2451">
										<rect width="20" height="20" fill="white" />
									</clipPath>
								</defs>
							</svg>
						</div>
						<div class="default-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
								fill="none">
								<g opacity="0.4" clip-path="url(#clip0_5681_2455)">
									<path
										d="M10.3193 19.9561C15.7686 19.9561 20.2803 15.4346 20.2803 9.99512C20.2803 4.5459 15.7588 0.0341797 10.3096 0.0341797C4.87012 0.0341797 0.358398 4.5459 0.358398 9.99512C0.358398 15.4346 4.87988 19.9561 10.3193 19.9561ZM10.3193 18.2959C5.70996 18.2959 2.02832 14.6045 2.02832 9.99512C2.02832 5.38574 5.7002 1.69434 10.3096 1.69434C14.9189 1.69434 18.6201 5.38574 18.6201 9.99512C18.6201 14.6045 14.9287 18.2959 10.3193 18.2959Z"
										fill="#A1A9B2" />
									<path
										d="M9.24512 14.6338C9.56738 14.6338 9.84082 14.4776 10.0361 14.1748L14.499 7.15332C14.6064 6.95801 14.7334 6.74316 14.7334 6.52832C14.7334 6.08887 14.3428 5.80566 13.9326 5.80566C13.6885 5.80566 13.4443 5.96191 13.2588 6.24512L9.20606 12.749L7.28223 10.2588C7.04785 9.94629 6.83301 9.86816 6.55957 9.86816C6.13965 9.86816 5.80762 10.21 5.80762 10.6397C5.80762 10.8545 5.89551 11.0596 6.03223 11.2451L8.41504 14.1748C8.65918 14.4971 8.92285 14.6338 9.24512 14.6338Z"
										fill="#A1A9B2" />
								</g>
								<defs>
									<clipPath id="clip0_5681_2455">
										<rect width="20.2832" height="19.9316" fill="white"
											transform="translate(0.358398 0.0341797)" />
									</clipPath>
								</defs>
							</svg>
						</div>
						AI dynamically create primary fields
					</li>
				</ul>
				<a href="#" target="_blank" id="directorist-create-directory__preview-btn" class="directory-generate-progress-list__btn">
					<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
						<path
							d="M15.4357 10.0828L11.406 8.59375L9.92163 4.56094C9.83373 4.32213 9.67469 4.11604 9.46598 3.97046C9.25726 3.82488 9.00892 3.74682 8.75445 3.74682C8.49998 3.74682 8.25163 3.82488 8.04291 3.97046C7.8342 4.11604 7.67516 4.32213 7.58726 4.56094L6.09351 8.59375L2.0607 10.0781C1.82189 10.166 1.61579 10.3251 1.47022 10.5338C1.32464 10.7425 1.24658 10.9908 1.24658 11.2453C1.24658 11.4998 1.32464 11.7481 1.47022 11.9568C1.61579 12.1656 1.82189 12.3246 2.0607 12.4125L6.09351 13.9062L7.57788 17.9391C7.66579 18.1779 7.82482 18.384 8.03354 18.5295C8.24225 18.6751 8.4906 18.7532 8.74507 18.7532C8.99954 18.7532 9.24789 18.6751 9.4566 18.5295C9.66532 18.384 9.82436 18.1779 9.91226 17.9391L11.406 13.9062L15.4388 12.4219C15.6776 12.334 15.8837 12.1749 16.0293 11.9662C16.1749 11.7575 16.2529 11.5092 16.2529 11.2547C16.2529 11.0002 16.1749 10.7519 16.0293 10.5432C15.8837 10.3344 15.6776 10.1754 15.4388 10.0875L15.4357 10.0828ZM10.7029 12.8297C10.618 12.861 10.541 12.9103 10.4771 12.9742C10.4131 13.0381 10.3638 13.1152 10.3326 13.2L8.74976 17.4883L7.17007 13.2031C7.13885 13.1174 7.08925 13.0395 7.02473 12.975C6.96022 12.9105 6.88236 12.8609 6.79663 12.8297L2.51148 11.25L6.79663 9.67031C6.88236 9.6391 6.96022 9.58949 7.02473 9.52497C7.08925 9.46046 7.13885 9.3826 7.17007 9.29688L8.74976 5.01172L10.3294 9.29688C10.3607 9.38171 10.41 9.45875 10.4739 9.52269C10.5379 9.58662 10.6149 9.63592 10.6998 9.66719L14.988 11.25L10.7029 12.8297ZM11.2498 3.125C11.2498 2.95924 11.3156 2.80027 11.4328 2.68306C11.55 2.56585 11.709 2.5 11.8748 2.5H13.1248V1.25C13.1248 1.08424 13.1906 0.925268 13.3078 0.808058C13.425 0.690848 13.584 0.625 13.7498 0.625C13.9155 0.625 14.0745 0.690848 14.1917 0.808058C14.3089 0.925268 14.3748 1.08424 14.3748 1.25V2.5H15.6248C15.7905 2.5 15.9495 2.56585 16.0667 2.68306C16.1839 2.80027 16.2498 2.95924 16.2498 3.125C16.2498 3.29076 16.1839 3.44973 16.0667 3.56694C15.9495 3.68415 15.7905 3.75 15.6248 3.75H14.3748V5C14.3748 5.16576 14.3089 5.32473 14.1917 5.44194C14.0745 5.55915 13.9155 5.625 13.7498 5.625C13.584 5.625 13.425 5.55915 13.3078 5.44194C13.1906 5.32473 13.1248 5.16576 13.1248 5V3.75H11.8748C11.709 3.75 11.55 3.68415 11.4328 3.56694C11.3156 3.44973 11.2498 3.29076 11.2498 3.125ZM19.3748 6.875C19.3748 7.04076 19.3089 7.19973 19.1917 7.31694C19.0745 7.43415 18.9155 7.5 18.7498 7.5H18.1248V8.125C18.1248 8.29076 18.0589 8.44973 17.9417 8.56694C17.8245 8.68415 17.6655 8.75 17.4998 8.75C17.334 8.75 17.175 8.68415 17.0578 8.56694C16.9406 8.44973 16.8748 8.29076 16.8748 8.125V7.5H16.2498C16.084 7.5 15.925 7.43415 15.8078 7.31694C15.6906 7.19973 15.6248 7.04076 15.6248 6.875C15.6248 6.70924 15.6906 6.55027 15.8078 6.43306C15.925 6.31585 16.084 6.25 16.2498 6.25H16.8748V5.625C16.8748 5.45924 16.9406 5.30027 17.0578 5.18306C17.175 5.06585 17.334 5 17.4998 5C17.6655 5 17.8245 5.06585 17.9417 5.18306C18.0589 5.30027 18.1248 5.45924 18.1248 5.625V6.25H18.7498C18.9155 6.25 19.0745 6.31585 19.1917 6.43306C19.3089 6.55027 19.3748 6.70924 19.3748 6.875Z"
							fill="white" />
					</svg>
					Preview & Customize directory
				</a>
			</div>

			<!-- Footer -->
			<div class="directorist-create-directory__content__footer">
				<div class="directorist-create-directory__back">
					<a href="<?php echo esc_url(
                        wp_get_referer()
                    ); ?>" class="directorist-create-directory__back__btn">
						<svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M13 5L8 10L13 15" stroke="currentColor" stroke-width="1.5"
								stroke-miterlimit="16" />
						</svg>
						Back
					</a>
				</div>
				<div class="directorist-create-directory__next">
					<button class="directorist-create-directory__btn directorist_regenerate_fields" style="display: none;">
						<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path fill-rule="evenodd" clip-rule="evenodd" d="M14.7043 5.88371C12.7797 3.67922 9.50477 3.0689 6.87472 4.58736C5.07599 5.62586 3.98824 7.42276 3.78372 9.3442C3.73501 9.80185 3.32452 10.1334 2.86687 10.0847C2.40922 10.0359 2.0777 9.62545 2.12642 9.16779C2.3849 6.73941 3.7618 4.4601 6.04139 3.14399C9.48209 1.15749 13.7941 2.04731 16.1932 5.06737L16.2838 4.72948C16.4029 4.28493 16.8598 4.02111 17.3044 4.14023C17.7489 4.25935 18.0128 4.71629 17.8936 5.16085L17.2836 7.43756C17.2264 7.65104 17.0867 7.83306 16.8953 7.94356C16.7039 8.05407 16.4765 8.08402 16.263 8.02681L13.9863 7.41677C13.5417 7.29765 13.2779 6.84071 13.397 6.39615C13.5161 5.9516 13.9731 5.68778 14.4176 5.8069L14.7043 5.88371ZM17.1323 9.91571C17.59 9.96443 17.9215 10.3749 17.8728 10.8326C17.6143 13.261 16.2374 15.5403 13.9578 16.8564C10.5173 18.8428 6.20546 17.9531 3.80629 14.9334L3.71587 15.2709C3.59675 15.7154 3.13981 15.9793 2.69525 15.8601C2.2507 15.741 1.98688 15.2841 2.10599 14.8395L2.71604 12.5628C2.83516 12.1183 3.2921 11.8544 3.73666 11.9736L6.01337 12.5836C6.45792 12.7027 6.72174 13.1597 6.60262 13.6042C6.4835 14.0488 6.02656 14.3126 5.582 14.1935L5.29472 14.1165C7.21932 16.3211 10.4943 16.9315 13.1245 15.413C14.9232 14.3745 16.0109 12.5776 16.2155 10.6562C16.2642 10.1985 16.6747 9.867 17.1323 9.91571Z" fill="#3E62F5"/>
						</svg>
						<span class="directorist_generate_ai_directory__text">Re-generate Unpinned</span>
					</button>

					<button type="submit" class="directorist-create-directory__btn directorist-create-directory__btn--next directorist_generate_ai_directory">
						<svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path
								d="M15.9357 10.0828L11.906 8.59375L10.4216 4.56094C10.3337 4.32213 10.1747 4.11604 9.96598 3.97046C9.75726 3.82488 9.50892 3.74682 9.25445 3.74682C8.99998 3.74682 8.75163 3.82488 8.54291 3.97046C8.3342 4.11604 8.17516 4.32213 8.08726 4.56094L6.59351 8.59375L2.5607 10.0781C2.32189 10.166 2.11579 10.3251 1.97022 10.5338C1.82464 10.7425 1.74658 10.9908 1.74658 11.2453C1.74658 11.4998 1.82464 11.7481 1.97022 11.9568C2.11579 12.1656 2.32189 12.3246 2.5607 12.4125L6.59351 13.9062L8.07788 17.9391C8.16579 18.1779 8.32482 18.384 8.53354 18.5295C8.74225 18.6751 8.9906 18.7532 9.24507 18.7532C9.49954 18.7532 9.74789 18.6751 9.9566 18.5295C10.1653 18.384 10.3244 18.1779 10.4123 17.9391L11.906 13.9062L15.9388 12.4219C16.1776 12.334 16.3837 12.1749 16.5293 11.9662C16.6749 11.7575 16.7529 11.5092 16.7529 11.2547C16.7529 11.0002 16.6749 10.7519 16.5293 10.5432C16.3837 10.3344 16.1776 10.1754 15.9388 10.0875L15.9357 10.0828ZM11.2029 12.8297C11.118 12.861 11.041 12.9103 10.9771 12.9742C10.9131 13.0381 10.8638 13.1152 10.8326 13.2L9.24976 17.4883L7.67007 13.2031C7.63885 13.1174 7.58925 13.0395 7.52473 12.975C7.46022 12.9105 7.38236 12.8609 7.29663 12.8297L3.01148 11.25L7.29663 9.67031C7.38236 9.6391 7.46022 9.58949 7.52473 9.52497C7.58925 9.46046 7.63885 9.3826 7.67007 9.29688L9.24976 5.01172L10.8294 9.29688C10.8607 9.38171 10.91 9.45875 10.9739 9.52269C11.0379 9.58662 11.1149 9.63592 11.1998 9.66719L15.488 11.25L11.2029 12.8297ZM11.7498 3.125C11.7498 2.95924 11.8156 2.80027 11.9328 2.68306C12.05 2.56585 12.209 2.5 12.3748 2.5H13.6248V1.25C13.6248 1.08424 13.6906 0.925268 13.8078 0.808058C13.925 0.690848 14.084 0.625 14.2498 0.625C14.4155 0.625 14.5745 0.690848 14.6917 0.808058C14.8089 0.925268 14.8748 1.08424 14.8748 1.25V2.5H16.1248C16.2905 2.5 16.4495 2.56585 16.5667 2.68306C16.6839 2.80027 16.7498 2.95924 16.7498 3.125C16.7498 3.29076 16.6839 3.44973 16.5667 3.56694C16.4495 3.68415 16.2905 3.75 16.1248 3.75H14.8748V5C14.8748 5.16576 14.8089 5.32473 14.6917 5.44194C14.5745 5.55915 14.4155 5.625 14.2498 5.625C14.084 5.625 13.925 5.55915 13.8078 5.44194C13.6906 5.32473 13.6248 5.16576 13.6248 5V3.75H12.3748C12.209 3.75 12.05 3.68415 11.9328 3.56694C11.8156 3.44973 11.7498 3.29076 11.7498 3.125ZM19.8748 6.875C19.8748 7.04076 19.8089 7.19973 19.6917 7.31694C19.5745 7.43415 19.4155 7.5 19.2498 7.5H18.6248V8.125C18.6248 8.29076 18.5589 8.44973 18.4417 8.56694C18.3245 8.68415 18.1655 8.75 17.9998 8.75C17.834 8.75 17.675 8.68415 17.5578 8.56694C17.4406 8.44973 17.3748 8.29076 17.3748 8.125V7.5H16.7498C16.584 7.5 16.425 7.43415 16.3078 7.31694C16.1906 7.19973 16.1248 7.04076 16.1248 6.875C16.1248 6.70924 16.1906 6.55027 16.3078 6.43306C16.425 6.31585 16.584 6.25 16.7498 6.25H17.3748V5.625C17.3748 5.45924 17.4406 5.30027 17.5578 5.18306C17.675 5.06585 17.834 5 17.9998 5C18.1655 5 18.3245 5.06585 18.4417 5.18306C18.5589 5.30027 18.6248 5.45924 18.6248 5.625V6.25H19.2498C19.4155 6.25 19.5745 6.31585 19.6917 6.43306C19.8089 6.55027 19.8748 6.70924 19.8748 6.875Z"
								fill="currentColor" />
						</svg>
						<span class="directorist_generate_ai_directory__text">Continue to Generate</span>
					</button>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Step 1 Building Directory -->
<!-- <div class="directorist-create-directory__content__items directorist-create-directory__content__items--columns" data-step="1">
	Stwp One
</div> -->

<!-- Step 2 Describe business -->
<!-- <div class="directorist-create-directory__content__items" data-step="2">
	Step Two
</div> -->

<!-- Step 3 initial Page -->
<!-- <div class="directorist-create-directory__content__items" data-step="3">
	Step Three
</div> -->