<?php
if ( !function_exists( 'add_action' ) ) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}
include CT7_LOGIC_PLUGIN_PATH."backend/group.php";
include CT7_LOGIC_PLUGIN_PATH."backend/demo.php";
class cf7_logic_backend {
    function __construct(){
        add_action("admin_enqueue_scripts",array($this,"add_lib"),0,0);
        add_filter("wpcf7_editor_panels",array($this,"custom_form"));
        add_action("save_post", array($this,"save_data"));
        add_filter( 'wpcf7_posted_data', array($this,'custom_postdata'), 1, 1 );
        add_filter( 'wpcf7_validate', array($this, 'custom_validation'), 1, 2 );
        add_filter('wpcf7_form_hidden_fields',array($this,"add_logic_name_hidden"));
    }
    function custom_validation($result, $tags) {
        if (!session_id())
            session_start();
       $new_rs = $result->get_invalid_fields() ;
       if (!is_array($new_rs) || count($new_rs) == 0) {
            return $result;
       } 
       $lists_field = explode("|", $_SESSION['cf7_logic'] );
        $new_result = new WPCF7_Validation();
       foreach ($new_rs as $key => $value) {
            if ( !in_array($key, $lists_field) ) { 
                $new_result->invalidate($key, $value['reason']);
            }
       }
        return $new_result;
    }
    function custom_postdata($posted_data) {
        if (!session_id())
            session_start();
       $_SESSION['cf7_logic'] = esc_attr($_POST["_cf_logic"]);
        //$_SESSION['cf7_logic'] = $posted_data["_cf_logic"];
        //var_dump($_SESSION['cf7_logic']);
        return $posted_data;
    }
    function add_logic_name_hidden($fields) {
        return array("_cf_logic"=>"");
    }
    /*
    * Add css and js
    */
    function add_lib(){
        if (@$_GET["page"] == "wpcf7" || @$_GET["page"] == "wpcf7-new" ) :
            wp_enqueue_script("cf7_logic",CT7_LOGIC_PLUGIN_URL."backend/js/conditional-logic.js",array(),time());
            $demo = '<label> Which fields would you like to view?
    [select menu-827 "Group 1" "Group 2" "Group 3"] </label>

[group group-1]

<label> Field Name 1(required) - Group 1
    [text* field-1] </label>
<label> Field Name 2(required) - Group 1
    [text* field-2] </label>
 [/group]


[group group-2]

<label> Field Name 3(required) - Group 2
    [text* field-3] </label>
<label> Field Name 4(required) - Group 2
    [text* field-4] </label>
<label> Field Name 5(required) - Group 2
    [text* field-5] </label>
 [/group]


[group group-3]

<label> Field Name 6(required) - Group 3
    [text* field-6] </label>
<label> Field Name 7(required) - Group 3
    [text* field-7] </label>

 [/group]

[submit "Send"]';
             wp_localize_script( "cf7_logic", "cf7_logic", array("data"=>$demo,"settings"=>cf7_get_content_demo_settings()) );
        endif;
    }
    function custom_form($panels){
        $panels["form-panel-logic-setting"] = array(
				'title' => __( 'Conditional logic', 'contact-form-7-conditional-logic' ),
				'callback' => "cf7_logic_setting_form" );
        return $panels;
    }
     function save_data($post_id){
        $cf7_logic = $_POST["cf7_logic"];
        add_post_meta($post_id, 'cf7_logic', $cf7_logic,true) or update_post_meta($post_id, 'cf7_logic', $cf7_logic);
    }
}
new cf7_logic_backend;
function cf7_logic_setting_form($post){
    $datas = get_post_meta($post->id(),'cf7_logic',true);
    //var_dump($datas);
    $tags = $post->scan_form_tags();
    $tags_group = $post->scan_form_tags(array('type'=>'group'));
    //var_dump($tags);
    ?>
    <h3>Conditional logic</h3>
    <div class="hidden">
        <div id="data-li-condition">
            <input type="hidden" class="cf7_logic_main_id" value="datamain">
            <div class="cf7-loic-grounp-head">
                <div class="cf7-logic-name"><?php _e("Show or hide",'contact-form-7-conditional-logic') ?></div>
                <select name="cf7_logic_temp[type]" >
                    <option value="show"><?php _e("Show",'contact-form-7-conditional-logic') ?></option>
                    <option value="hide"><?php _e("Hide",'contact-form-7-conditional-logic') ?></option>
                </select>
                Groups: 
                 <?php 
                    foreach ($tags_group as $tag):
                 ?>
                    <label for=""><input  value="<?php echo $tag['options'][0]?>" type="checkbox" name="cf7_logic_temp[then][]"> <?php echo $tag['options'][0] ?></label>
                 <?php 
                    endforeach;
                  ?>
            </div>
            <div class="cf7-logic-when">
                <div class="cf7-logic-name"><?php _e("When to Trigger",'contact-form-7-conditional-logic') ?></div>
                <select name="cf7_logic_temp[when]" >
                    <option value="all"><?php _e("All",'contact-form-7-conditional-logic')?></option>
                    <option value="one"><?php _e("one",'contact-form-7-conditional-logic') ?></option>
                </select>
            </div>
            <div class="cf7-inner-container">
                <div class="cf7-logic-name"><?php _e("Condition",'contact-form-7-conditional-logic') ?></div>
                <ul>
                </ul>
                <a href="#" class="button button-small cf7-logic-add-equals" title=""><?php _e("Add Condition",'contact-form-7-conditional-logic') ?></a>
            </div>
             <a href="#" class="button button-small cf7-remove-condition" title=""><?php _e("Remove Condition",'contact-form-7-conditional-logic') ?></a>

        </div>

        <div id="data-li-name">
            If 
            <select name="cf7_logic_temp[condition][jjj][name]">
                <?php 
                    foreach ($tags as $tag_inner):
                        if ($tag_inner['type'] == 'group' || $tag_inner['name'] == '') continue;
                 ?>
                <option  value="<?php echo $tag_inner['name']; ?>"><?php echo $tag_inner['name']; ?></option>
                 <?php 
                    endforeach;
                  ?>
            </select>
            <select name="cf7_logic_temp[condition][jjj][equals]">
                <option value="1">==</option>
                <option value="2">!=</option>
                <option value="3">></option>
                <option value="4">>=</option>
                <option value="5"><</option>
                <option value="6"><=</option>
            </select>
            <input type="text" name="cf7_logic_temp[condition][jjj][value]" value="">
            <a href="#" class="button cf7-logic-remove-equals" title=""><span class="dashicons dashicons-no-alt"></span></a>
        </div>
    </div><!-- /.hidden -->


    <ul class="cf7-logic-main">
        <?php 
        if( is_array($datas) ) :
            $i = 1;
            foreach ($datas as $data):
         ?>
        <li>
            <input type="hidden" class="cf7_logic_main_id" value="<?php echo $i ?>">
            <div class="cf7-loic-grounp-head">
                <div class="cf7-logic-name"><?php _e("Show or hide",'contact-form-7-conditional-logic') ?></div>
                <select name="cf7_logic[<?php echo $i ?>][type]" >
                    <option value="show"><?php _e("Show",'contact-form-7-conditional-logic') ?></option>
                    <option <?php selected($data["type"],"hide") ?> value="hide"><?php _e("Hide",'contact-form-7-conditional-logic') ?></option>
                </select>
                Groups: 
                 <?php 
                    foreach ($tags_group as $tag):
                 ?>
                    <label for=""><input <?php if( @in_array($tag['options'][0],$data["then"])){ echo 'checked'; } ?>  value="<?php echo $tag['options'][0]?>" type="checkbox" name="cf7_logic[<?php echo $i ?>][then][]"> <?php echo $tag['options'][0] ?></label>
                 <?php 
                    endforeach;
                  ?>
            </div>
            <div class="cf7-logic-when">
                <div class="cf7-logic-name"><?php _e("When to Trigger",'contact-form-7-conditional-logic') ?></div>
                <select name="cf7_logic[<?php echo $i ?>][when]" >
                    <option value="all"><?php _e("All",'contact-form-7-conditional-logic') ?></option>
                    <option <?php selected($data["when"],"one") ?> value="one"><?php _e("one",'contact-form-7-conditional-logic') ?></option>
                </select>
            </div>
            <div class="cf7-inner-container">
                <div class="cf7-logic-name"><?php _e("Condition",'contact-form-7-conditional-logic') ?></div>
                <ul>
                    <?php 
                    $j = 1;    
                    foreach( $data["condition"] as $inside ): ?>
                    <li class="data-li-name">If 
                        <select name="cf7_logic[<?php echo $i ?>][condition][<?php echo $j ?>][name]">
                            <?php 
                                foreach ($tags as $tag_inner):
                                    if ($tag_inner['type'] == 'group' || $tag_inner['name'] == '') continue;
                             ?>
                            <option <?php selected($inside["name"],$tag_inner['name'] ) ?>  value="<?php echo $tag_inner['name']; ?>"><?php echo $tag_inner['name']; ?></option>
                             <?php 
                                endforeach;
                              ?>
                        </select>
                        <select name="cf7_logic[<?php echo $i ?>][condition][<?php echo $j ?>][equals]">
                            <option value="1">==</option>
                            <option <?php selected($inside["equals"],"2") ?> value="2">!=</option>
                            <option <?php selected($inside["equals"],"3") ?> value="3">></option>
                            <option <?php selected($inside["equals"],"4") ?> value="4">>=</option>
                            <option <?php selected($inside["equals"],"5") ?> value="5"><</option>
                            <option <?php selected($inside["equals"],"6") ?> value="6"><=</option>
                        </select>
                        <input type="text" name="cf7_logic[<?php echo $i ?>][condition][<?php echo $j ?>][value]" value="<?php echo $inside["value"] ?>">
                        <a href="#" class="button cf7-logic-remove-equals" title=""><span class="dashicons dashicons-no-alt"></span></a>
                    </li>
                <?php 
                $j++;
                endforeach; ?>
                </ul>
                <a href="#" class="button button-small cf7-logic-add-equals" title=""><?php _e("Add Condition",'contact-form-7-conditional-logic') ?></a>
            </div>
             <a href="#" class="button button-small cf7-remove-condition" title=""><?php _e("Remove Condition",'contact-form-7-conditional-logic') ?></a>
        </li>
    <?php 
    $i++;
    endforeach;
    endif; ?>
        
    </ul>
    <a class="button" id="cf7-logic-add" href="#" title=""><?php _e("Add New",'contact-form-7-conditional-logic') ?></a>
    <?php
}